"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserConfigFrom = void 0;
var _lodash = require("lodash");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* The file contains helper functions for visualizaitons operations
 * getUserConfigFrom - returns input objects'  user_configs or userConfigs, JSON parsed if necessary
 */

const getUserConfigFrom = container => {
  const config = (container === null || container === void 0 ? void 0 : container.user_configs) || (container === null || container === void 0 ? void 0 : container.userConfigs) || {};
  if ((0, _lodash.isEmpty)(config)) return {};
  if ((0, _lodash.isString)(config)) return JSON.parse(config);else return {};
};
exports.getUserConfigFrom = getUserConfigFrom;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwicmVxdWlyZSIsImdldFVzZXJDb25maWdGcm9tIiwiY29udGFpbmVyIiwiY29uZmlnIiwidXNlcl9jb25maWdzIiwidXNlckNvbmZpZ3MiLCJpc0VtcHR5IiwiaXNTdHJpbmciLCJKU09OIiwicGFyc2UiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsidmlzdWFsaXphdGlvbl9oZWxwZXJzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IGlzRW1wdHksIGlzU3RyaW5nIH0gZnJvbSAnbG9kYXNoJztcclxuXHJcbi8qIFRoZSBmaWxlIGNvbnRhaW5zIGhlbHBlciBmdW5jdGlvbnMgZm9yIHZpc3VhbGl6YWl0b25zIG9wZXJhdGlvbnNcclxuICogZ2V0VXNlckNvbmZpZ0Zyb20gLSByZXR1cm5zIGlucHV0IG9iamVjdHMnICB1c2VyX2NvbmZpZ3Mgb3IgdXNlckNvbmZpZ3MsIEpTT04gcGFyc2VkIGlmIG5lY2Vzc2FyeVxyXG4gKi9cclxuXHJcbmV4cG9ydCBjb25zdCBnZXRVc2VyQ29uZmlnRnJvbSA9IChjb250YWluZXI6IHVua25vd24pOiBvYmplY3QgPT4ge1xyXG4gIGNvbnN0IGNvbmZpZyA9IGNvbnRhaW5lcj8udXNlcl9jb25maWdzIHx8IGNvbnRhaW5lcj8udXNlckNvbmZpZ3MgfHwge307XHJcblxyXG4gIGlmIChpc0VtcHR5KGNvbmZpZykpIHJldHVybiB7fTtcclxuXHJcbiAgaWYgKGlzU3RyaW5nKGNvbmZpZykpIHJldHVybiBKU09OLnBhcnNlKGNvbmZpZyk7XHJcbiAgZWxzZSByZXR1cm4ge307XHJcbn07XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxPQUFBO0FBTEE7QUFDQTtBQUNBO0FBQ0E7O0FBSUE7QUFDQTtBQUNBOztBQUVPLE1BQU1DLGlCQUFpQixHQUFJQyxTQUFrQixJQUFhO0VBQy9ELE1BQU1DLE1BQU0sR0FBRyxDQUFBRCxTQUFTLGFBQVRBLFNBQVMsdUJBQVRBLFNBQVMsQ0FBRUUsWUFBWSxNQUFJRixTQUFTLGFBQVRBLFNBQVMsdUJBQVRBLFNBQVMsQ0FBRUcsV0FBVyxLQUFJLENBQUMsQ0FBQztFQUV0RSxJQUFJLElBQUFDLGVBQU8sRUFBQ0gsTUFBTSxDQUFDLEVBQUUsT0FBTyxDQUFDLENBQUM7RUFFOUIsSUFBSSxJQUFBSSxnQkFBUSxFQUFDSixNQUFNLENBQUMsRUFBRSxPQUFPSyxJQUFJLENBQUNDLEtBQUssQ0FBQ04sTUFBTSxDQUFDLENBQUMsS0FDM0MsT0FBTyxDQUFDLENBQUM7QUFDaEIsQ0FBQztBQUFDTyxPQUFBLENBQUFULGlCQUFBLEdBQUFBLGlCQUFBIn0=