"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addBackticksIfNeeded = addBackticksIfNeeded;
exports.basePathLink = void 0;
exports.combineSchemaAndDatarows = combineSchemaAndDatarows;
exports.dataSourceFilterFn = void 0;
exports.get = get;
var _semver = _interopRequireDefault(require("semver"));
var pluginManifest = _interopRequireWildcard(require("../../opensearch_dashboards.json"));
var _core_refs = require("../../public/framework/core_refs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * TODO making this method type-safe is nontrivial: if you just define
 * `Nested<T> = { [k: string]: Nested<T> | T }` then you can't accumulate because `T` is not `Nested<T>`
 * There might be a way to define a recursive type that accumulates cleanly but it's probably not
 * worth the effort.
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function get(obj, path, defaultValue) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return path.split('.').reduce((acc, part) => acc && acc[part], obj) || defaultValue;
}
function addBackticksIfNeeded(input) {
  if (input === undefined) {
    return '';
  }
  // Check if the string already has backticks
  if (input.startsWith('`') && input.endsWith('`')) {
    return input; // Return the string as it is
  } else {
    // Add backticks to the string
    return '`' + input + '`';
  }
}
function combineSchemaAndDatarows(schema, datarows) {
  const combinedData = [];
  datarows.forEach(row => {
    const rowData = {};
    schema.forEach((field, index) => {
      rowData[field.name] = row[index];
    });
    combinedData.push(rowData);
  });
  return combinedData;
}

/**
 * Safely prepend the `basePath` from `coreRefs` to the given link.
 * If `coreRefs.http.basePath` exists (always true in normal operation), prepend it to the link.
 * If it doesn't exist (usually during unit testing), return the link as-is.
 *
 * @param link The link to prepend with `coreRefs.http.basePath`.
 * @returns The link with the prepended `basePath` if it exists, otherwise the unmodified link.
 */
const basePathLink = link => {
  var _coreRefs$http;
  if ((_coreRefs$http = _core_refs.coreRefs.http) !== null && _coreRefs$http !== void 0 && _coreRefs$http.basePath) {
    return _core_refs.coreRefs.http.basePath.prepend(link);
  } else {
    return link;
  }
};
exports.basePathLink = basePathLink;
const dataSourceFilterFn = dataSource => {
  var _dataSource$attribute, _dataSource$attribute2;
  const dataSourceVersion = (dataSource === null || dataSource === void 0 || (_dataSource$attribute = dataSource.attributes) === null || _dataSource$attribute === void 0 ? void 0 : _dataSource$attribute.dataSourceVersion) || '';
  const installedPlugins = (dataSource === null || dataSource === void 0 || (_dataSource$attribute2 = dataSource.attributes) === null || _dataSource$attribute2 === void 0 ? void 0 : _dataSource$attribute2.installedPlugins) || [];
  return _semver.default.satisfies(dataSourceVersion, pluginManifest.supportedOSDataSourceVersions) && pluginManifest.requiredOSDataSourcePlugins.every(plugin => installedPlugins.includes(plugin));
};
exports.dataSourceFilterFn = dataSourceFilterFn;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2VtdmVyIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJwbHVnaW5NYW5pZmVzdCIsIl9pbnRlcm9wUmVxdWlyZVdpbGRjYXJkIiwiX2NvcmVfcmVmcyIsIl9nZXRSZXF1aXJlV2lsZGNhcmRDYWNoZSIsImUiLCJXZWFrTWFwIiwiciIsInQiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsImhhcyIsImdldCIsIm4iLCJfX3Byb3RvX18iLCJhIiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJnZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IiLCJ1IiwiaGFzT3duUHJvcGVydHkiLCJjYWxsIiwiaSIsInNldCIsIm9iaiIsInBhdGgiLCJkZWZhdWx0VmFsdWUiLCJzcGxpdCIsInJlZHVjZSIsImFjYyIsInBhcnQiLCJhZGRCYWNrdGlja3NJZk5lZWRlZCIsImlucHV0IiwidW5kZWZpbmVkIiwic3RhcnRzV2l0aCIsImVuZHNXaXRoIiwiY29tYmluZVNjaGVtYUFuZERhdGFyb3dzIiwic2NoZW1hIiwiZGF0YXJvd3MiLCJjb21iaW5lZERhdGEiLCJmb3JFYWNoIiwicm93Iiwicm93RGF0YSIsImZpZWxkIiwiaW5kZXgiLCJuYW1lIiwicHVzaCIsImJhc2VQYXRoTGluayIsImxpbmsiLCJfY29yZVJlZnMkaHR0cCIsImNvcmVSZWZzIiwiaHR0cCIsImJhc2VQYXRoIiwicHJlcGVuZCIsImV4cG9ydHMiLCJkYXRhU291cmNlRmlsdGVyRm4iLCJkYXRhU291cmNlIiwiX2RhdGFTb3VyY2UkYXR0cmlidXRlIiwiX2RhdGFTb3VyY2UkYXR0cmlidXRlMiIsImRhdGFTb3VyY2VWZXJzaW9uIiwiYXR0cmlidXRlcyIsImluc3RhbGxlZFBsdWdpbnMiLCJzZW12ZXIiLCJzYXRpc2ZpZXMiLCJzdXBwb3J0ZWRPU0RhdGFTb3VyY2VWZXJzaW9ucyIsInJlcXVpcmVkT1NEYXRhU291cmNlUGx1Z2lucyIsImV2ZXJ5IiwicGx1Z2luIiwiaW5jbHVkZXMiXSwic291cmNlcyI6WyJzaGFyZWQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHNlbXZlciBmcm9tICdzZW12ZXInO1xyXG5pbXBvcnQgeyBTYXZlZE9iamVjdCB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3B1YmxpYyc7XHJcbmltcG9ydCB7IERhdGFTb3VyY2VBdHRyaWJ1dGVzIH0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL3BsdWdpbnMvZGF0YV9zb3VyY2UvY29tbW9uL2RhdGFfc291cmNlcyc7XHJcbmltcG9ydCAqIGFzIHBsdWdpbk1hbmlmZXN0IGZyb20gJy4uLy4uL29wZW5zZWFyY2hfZGFzaGJvYXJkcy5qc29uJztcclxuaW1wb3J0IHsgY29yZVJlZnMgfSBmcm9tICcuLi8uLi9wdWJsaWMvZnJhbWV3b3JrL2NvcmVfcmVmcyc7XHJcblxyXG4vKipcclxuICogVE9ETyBtYWtpbmcgdGhpcyBtZXRob2QgdHlwZS1zYWZlIGlzIG5vbnRyaXZpYWw6IGlmIHlvdSBqdXN0IGRlZmluZVxyXG4gKiBgTmVzdGVkPFQ+ID0geyBbazogc3RyaW5nXTogTmVzdGVkPFQ+IHwgVCB9YCB0aGVuIHlvdSBjYW4ndCBhY2N1bXVsYXRlIGJlY2F1c2UgYFRgIGlzIG5vdCBgTmVzdGVkPFQ+YFxyXG4gKiBUaGVyZSBtaWdodCBiZSBhIHdheSB0byBkZWZpbmUgYSByZWN1cnNpdmUgdHlwZSB0aGF0IGFjY3VtdWxhdGVzIGNsZWFubHkgYnV0IGl0J3MgcHJvYmFibHkgbm90XHJcbiAqIHdvcnRoIHRoZSBlZmZvcnQuXHJcbiAqL1xyXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLWV4cGxpY2l0LWFueVxyXG5leHBvcnQgZnVuY3Rpb24gZ2V0PFQgPSB1bmtub3duPihvYmo6IFJlY29yZDxzdHJpbmcsIGFueT4sIHBhdGg6IHN0cmluZywgZGVmYXVsdFZhbHVlPzogVCk6IFQge1xyXG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBAdHlwZXNjcmlwdC1lc2xpbnQvbm8tZXhwbGljaXQtYW55XHJcbiAgcmV0dXJuIHBhdGguc3BsaXQoJy4nKS5yZWR1Y2UoKGFjYzogYW55LCBwYXJ0OiBzdHJpbmcpID0+IGFjYyAmJiBhY2NbcGFydF0sIG9iaikgfHwgZGVmYXVsdFZhbHVlO1xyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gYWRkQmFja3RpY2tzSWZOZWVkZWQoaW5wdXQ6IHN0cmluZyk6IHN0cmluZyB7XHJcbiAgaWYgKGlucHV0ID09PSB1bmRlZmluZWQpIHtcclxuICAgIHJldHVybiAnJztcclxuICB9XHJcbiAgLy8gQ2hlY2sgaWYgdGhlIHN0cmluZyBhbHJlYWR5IGhhcyBiYWNrdGlja3NcclxuICBpZiAoaW5wdXQuc3RhcnRzV2l0aCgnYCcpICYmIGlucHV0LmVuZHNXaXRoKCdgJykpIHtcclxuICAgIHJldHVybiBpbnB1dDsgLy8gUmV0dXJuIHRoZSBzdHJpbmcgYXMgaXQgaXNcclxuICB9IGVsc2Uge1xyXG4gICAgLy8gQWRkIGJhY2t0aWNrcyB0byB0aGUgc3RyaW5nXHJcbiAgICByZXR1cm4gJ2AnICsgaW5wdXQgKyAnYCc7XHJcbiAgfVxyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gY29tYmluZVNjaGVtYUFuZERhdGFyb3dzKFxyXG4gIHNjaGVtYTogQXJyYXk8eyBuYW1lOiBzdHJpbmc7IHR5cGU6IHN0cmluZyB9PixcclxuICBkYXRhcm93czogQXJyYXk8QXJyYXk8c3RyaW5nIHwgbnVtYmVyIHwgYm9vbGVhbj4+XHJcbik6IG9iamVjdFtdIHtcclxuICBjb25zdCBjb21iaW5lZERhdGE6IG9iamVjdFtdID0gW107XHJcblxyXG4gIGRhdGFyb3dzLmZvckVhY2goKHJvdykgPT4ge1xyXG4gICAgY29uc3Qgcm93RGF0YTogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfCBudW1iZXIgfCBib29sZWFuIH0gPSB7fTtcclxuICAgIHNjaGVtYS5mb3JFYWNoKChmaWVsZCwgaW5kZXgpID0+IHtcclxuICAgICAgcm93RGF0YVtmaWVsZC5uYW1lXSA9IHJvd1tpbmRleF07XHJcbiAgICB9KTtcclxuICAgIGNvbWJpbmVkRGF0YS5wdXNoKHJvd0RhdGEpO1xyXG4gIH0pO1xyXG5cclxuICByZXR1cm4gY29tYmluZWREYXRhO1xyXG59XHJcblxyXG4vKipcclxuICogU2FmZWx5IHByZXBlbmQgdGhlIGBiYXNlUGF0aGAgZnJvbSBgY29yZVJlZnNgIHRvIHRoZSBnaXZlbiBsaW5rLlxyXG4gKiBJZiBgY29yZVJlZnMuaHR0cC5iYXNlUGF0aGAgZXhpc3RzIChhbHdheXMgdHJ1ZSBpbiBub3JtYWwgb3BlcmF0aW9uKSwgcHJlcGVuZCBpdCB0byB0aGUgbGluay5cclxuICogSWYgaXQgZG9lc24ndCBleGlzdCAodXN1YWxseSBkdXJpbmcgdW5pdCB0ZXN0aW5nKSwgcmV0dXJuIHRoZSBsaW5rIGFzLWlzLlxyXG4gKlxyXG4gKiBAcGFyYW0gbGluayBUaGUgbGluayB0byBwcmVwZW5kIHdpdGggYGNvcmVSZWZzLmh0dHAuYmFzZVBhdGhgLlxyXG4gKiBAcmV0dXJucyBUaGUgbGluayB3aXRoIHRoZSBwcmVwZW5kZWQgYGJhc2VQYXRoYCBpZiBpdCBleGlzdHMsIG90aGVyd2lzZSB0aGUgdW5tb2RpZmllZCBsaW5rLlxyXG4gKi9cclxuZXhwb3J0IGNvbnN0IGJhc2VQYXRoTGluayA9IChsaW5rOiBzdHJpbmcpOiBzdHJpbmcgPT4ge1xyXG4gIGlmIChjb3JlUmVmcy5odHRwPy5iYXNlUGF0aCkge1xyXG4gICAgcmV0dXJuIGNvcmVSZWZzLmh0dHAuYmFzZVBhdGgucHJlcGVuZChsaW5rKTtcclxuICB9IGVsc2Uge1xyXG4gICAgcmV0dXJuIGxpbms7XHJcbiAgfVxyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IGRhdGFTb3VyY2VGaWx0ZXJGbiA9IChkYXRhU291cmNlOiBTYXZlZE9iamVjdDxEYXRhU291cmNlQXR0cmlidXRlcz4pID0+IHtcclxuICBjb25zdCBkYXRhU291cmNlVmVyc2lvbiA9IGRhdGFTb3VyY2U/LmF0dHJpYnV0ZXM/LmRhdGFTb3VyY2VWZXJzaW9uIHx8ICcnO1xyXG4gIGNvbnN0IGluc3RhbGxlZFBsdWdpbnMgPSBkYXRhU291cmNlPy5hdHRyaWJ1dGVzPy5pbnN0YWxsZWRQbHVnaW5zIHx8IFtdO1xyXG4gIHJldHVybiAoXHJcbiAgICBzZW12ZXIuc2F0aXNmaWVzKGRhdGFTb3VyY2VWZXJzaW9uLCBwbHVnaW5NYW5pZmVzdC5zdXBwb3J0ZWRPU0RhdGFTb3VyY2VWZXJzaW9ucykgJiZcclxuICAgIHBsdWdpbk1hbmlmZXN0LnJlcXVpcmVkT1NEYXRhU291cmNlUGx1Z2lucy5ldmVyeSgocGx1Z2luKSA9PiBpbnN0YWxsZWRQbHVnaW5zLmluY2x1ZGVzKHBsdWdpbikpXHJcbiAgKTtcclxufTtcclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBR0EsSUFBQUMsY0FBQSxHQUFBQyx1QkFBQSxDQUFBRixPQUFBO0FBQ0EsSUFBQUcsVUFBQSxHQUFBSCxPQUFBO0FBQTRELFNBQUFJLHlCQUFBQyxDQUFBLDZCQUFBQyxPQUFBLG1CQUFBQyxDQUFBLE9BQUFELE9BQUEsSUFBQUUsQ0FBQSxPQUFBRixPQUFBLFlBQUFGLHdCQUFBLFlBQUFBLENBQUFDLENBQUEsV0FBQUEsQ0FBQSxHQUFBRyxDQUFBLEdBQUFELENBQUEsS0FBQUYsQ0FBQTtBQUFBLFNBQUFILHdCQUFBRyxDQUFBLEVBQUFFLENBQUEsU0FBQUEsQ0FBQSxJQUFBRixDQUFBLElBQUFBLENBQUEsQ0FBQUksVUFBQSxTQUFBSixDQUFBLGVBQUFBLENBQUEsdUJBQUFBLENBQUEseUJBQUFBLENBQUEsV0FBQUssT0FBQSxFQUFBTCxDQUFBLFFBQUFHLENBQUEsR0FBQUosd0JBQUEsQ0FBQUcsQ0FBQSxPQUFBQyxDQUFBLElBQUFBLENBQUEsQ0FBQUcsR0FBQSxDQUFBTixDQUFBLFVBQUFHLENBQUEsQ0FBQUksR0FBQSxDQUFBUCxDQUFBLE9BQUFRLENBQUEsS0FBQUMsU0FBQSxVQUFBQyxDQUFBLEdBQUFDLE1BQUEsQ0FBQUMsY0FBQSxJQUFBRCxNQUFBLENBQUFFLHdCQUFBLFdBQUFDLENBQUEsSUFBQWQsQ0FBQSxvQkFBQWMsQ0FBQSxPQUFBQyxjQUFBLENBQUFDLElBQUEsQ0FBQWhCLENBQUEsRUFBQWMsQ0FBQSxTQUFBRyxDQUFBLEdBQUFQLENBQUEsR0FBQUMsTUFBQSxDQUFBRSx3QkFBQSxDQUFBYixDQUFBLEVBQUFjLENBQUEsVUFBQUcsQ0FBQSxLQUFBQSxDQUFBLENBQUFWLEdBQUEsSUFBQVUsQ0FBQSxDQUFBQyxHQUFBLElBQUFQLE1BQUEsQ0FBQUMsY0FBQSxDQUFBSixDQUFBLEVBQUFNLENBQUEsRUFBQUcsQ0FBQSxJQUFBVCxDQUFBLENBQUFNLENBQUEsSUFBQWQsQ0FBQSxDQUFBYyxDQUFBLFlBQUFOLENBQUEsQ0FBQUgsT0FBQSxHQUFBTCxDQUFBLEVBQUFHLENBQUEsSUFBQUEsQ0FBQSxDQUFBZSxHQUFBLENBQUFsQixDQUFBLEVBQUFRLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFkLHVCQUFBTSxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBSSxVQUFBLEdBQUFKLENBQUEsS0FBQUssT0FBQSxFQUFBTCxDQUFBO0FBVDVEO0FBQ0E7QUFDQTtBQUNBOztBQVFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sU0FBU08sR0FBR0EsQ0FBY1ksR0FBd0IsRUFBRUMsSUFBWSxFQUFFQyxZQUFnQixFQUFLO0VBQzVGO0VBQ0EsT0FBT0QsSUFBSSxDQUFDRSxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUNDLE1BQU0sQ0FBQyxDQUFDQyxHQUFRLEVBQUVDLElBQVksS0FBS0QsR0FBRyxJQUFJQSxHQUFHLENBQUNDLElBQUksQ0FBQyxFQUFFTixHQUFHLENBQUMsSUFBSUUsWUFBWTtBQUNsRztBQUVPLFNBQVNLLG9CQUFvQkEsQ0FBQ0MsS0FBYSxFQUFVO0VBQzFELElBQUlBLEtBQUssS0FBS0MsU0FBUyxFQUFFO0lBQ3ZCLE9BQU8sRUFBRTtFQUNYO0VBQ0E7RUFDQSxJQUFJRCxLQUFLLENBQUNFLFVBQVUsQ0FBQyxHQUFHLENBQUMsSUFBSUYsS0FBSyxDQUFDRyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7SUFDaEQsT0FBT0gsS0FBSyxDQUFDLENBQUM7RUFDaEIsQ0FBQyxNQUFNO0lBQ0w7SUFDQSxPQUFPLEdBQUcsR0FBR0EsS0FBSyxHQUFHLEdBQUc7RUFDMUI7QUFDRjtBQUVPLFNBQVNJLHdCQUF3QkEsQ0FDdENDLE1BQTZDLEVBQzdDQyxRQUFpRCxFQUN2QztFQUNWLE1BQU1DLFlBQXNCLEdBQUcsRUFBRTtFQUVqQ0QsUUFBUSxDQUFDRSxPQUFPLENBQUVDLEdBQUcsSUFBSztJQUN4QixNQUFNQyxPQUFxRCxHQUFHLENBQUMsQ0FBQztJQUNoRUwsTUFBTSxDQUFDRyxPQUFPLENBQUMsQ0FBQ0csS0FBSyxFQUFFQyxLQUFLLEtBQUs7TUFDL0JGLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDRSxJQUFJLENBQUMsR0FBR0osR0FBRyxDQUFDRyxLQUFLLENBQUM7SUFDbEMsQ0FBQyxDQUFDO0lBQ0ZMLFlBQVksQ0FBQ08sSUFBSSxDQUFDSixPQUFPLENBQUM7RUFDNUIsQ0FBQyxDQUFDO0VBRUYsT0FBT0gsWUFBWTtBQUNyQjs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTVEsWUFBWSxHQUFJQyxJQUFZLElBQWE7RUFBQSxJQUFBQyxjQUFBO0VBQ3BELEtBQUFBLGNBQUEsR0FBSUMsbUJBQVEsQ0FBQ0MsSUFBSSxjQUFBRixjQUFBLGVBQWJBLGNBQUEsQ0FBZUcsUUFBUSxFQUFFO0lBQzNCLE9BQU9GLG1CQUFRLENBQUNDLElBQUksQ0FBQ0MsUUFBUSxDQUFDQyxPQUFPLENBQUNMLElBQUksQ0FBQztFQUM3QyxDQUFDLE1BQU07SUFDTCxPQUFPQSxJQUFJO0VBQ2I7QUFDRixDQUFDO0FBQUNNLE9BQUEsQ0FBQVAsWUFBQSxHQUFBQSxZQUFBO0FBRUssTUFBTVEsa0JBQWtCLEdBQUlDLFVBQTZDLElBQUs7RUFBQSxJQUFBQyxxQkFBQSxFQUFBQyxzQkFBQTtFQUNuRixNQUFNQyxpQkFBaUIsR0FBRyxDQUFBSCxVQUFVLGFBQVZBLFVBQVUsZ0JBQUFDLHFCQUFBLEdBQVZELFVBQVUsQ0FBRUksVUFBVSxjQUFBSCxxQkFBQSx1QkFBdEJBLHFCQUFBLENBQXdCRSxpQkFBaUIsS0FBSSxFQUFFO0VBQ3pFLE1BQU1FLGdCQUFnQixHQUFHLENBQUFMLFVBQVUsYUFBVkEsVUFBVSxnQkFBQUUsc0JBQUEsR0FBVkYsVUFBVSxDQUFFSSxVQUFVLGNBQUFGLHNCQUFBLHVCQUF0QkEsc0JBQUEsQ0FBd0JHLGdCQUFnQixLQUFJLEVBQUU7RUFDdkUsT0FDRUMsZUFBTSxDQUFDQyxTQUFTLENBQUNKLGlCQUFpQixFQUFFMUQsY0FBYyxDQUFDK0QsNkJBQTZCLENBQUMsSUFDakYvRCxjQUFjLENBQUNnRSwyQkFBMkIsQ0FBQ0MsS0FBSyxDQUFFQyxNQUFNLElBQUtOLGdCQUFnQixDQUFDTyxRQUFRLENBQUNELE1BQU0sQ0FBQyxDQUFDO0FBRW5HLENBQUM7QUFBQ2IsT0FBQSxDQUFBQyxrQkFBQSxHQUFBQSxrQkFBQSJ9