"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setNavBreadCrumbs = void 0;
var _core_refs = require("../../public/framework/core_refs");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setNavBreadCrumbs = (parentBreadCrumb, pageBreadCrumb, counter) => {
  var _coreRefs$chrome;
  const isNavGroupEnabled = _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome === void 0 ? void 0 : _coreRefs$chrome.navGroup.getNavGroupEnabled();
  const updatedPageBreadCrumb = pageBreadCrumb.map(crumb => ({
    ...crumb,
    text: isNavGroupEnabled && counter !== undefined ? `${crumb.text} (${counter})` : crumb.text
  }));
  if (isNavGroupEnabled) {
    var _coreRefs$chrome2;
    _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome2 = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome2 === void 0 || _coreRefs$chrome2.setBreadcrumbs([...updatedPageBreadCrumb]);
  } else {
    var _coreRefs$chrome3;
    _core_refs.coreRefs === null || _core_refs.coreRefs === void 0 || (_coreRefs$chrome3 = _core_refs.coreRefs.chrome) === null || _coreRefs$chrome3 === void 0 || _coreRefs$chrome3.setBreadcrumbs([...parentBreadCrumb, ...updatedPageBreadCrumb]);
  }
};
exports.setNavBreadCrumbs = setNavBreadCrumbs;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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