"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAsyncSessionId = exports.getAsyncSessionId = void 0;
var _shared = require("../constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setAsyncSessionId = (dataSource, value) => {
  if (value !== null) {
    sessionStorage.setItem(`${_shared.ASYNC_QUERY_SESSION_ID}_${dataSource}`, value);
  }
};
exports.setAsyncSessionId = setAsyncSessionId;
const getAsyncSessionId = dataSource => {
  return sessionStorage.getItem(`${_shared.ASYNC_QUERY_SESSION_ID}_${dataSource}`);
};
exports.getAsyncSessionId = getAsyncSessionId;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2hhcmVkIiwicmVxdWlyZSIsInNldEFzeW5jU2Vzc2lvbklkIiwiZGF0YVNvdXJjZSIsInZhbHVlIiwic2Vzc2lvblN0b3JhZ2UiLCJzZXRJdGVtIiwiQVNZTkNfUVVFUllfU0VTU0lPTl9JRCIsImV4cG9ydHMiLCJnZXRBc3luY1Nlc3Npb25JZCIsImdldEl0ZW0iXSwic291cmNlcyI6WyJxdWVyeV9zZXNzaW9uX3V0aWxzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IEFTWU5DX1FVRVJZX1NFU1NJT05fSUQgfSBmcm9tICcuLi9jb25zdGFudHMvc2hhcmVkJztcclxuXHJcbmV4cG9ydCBjb25zdCBzZXRBc3luY1Nlc3Npb25JZCA9IChkYXRhU291cmNlOiBzdHJpbmcsIHZhbHVlOiBzdHJpbmcgfCBudWxsKSA9PiB7XHJcbiAgaWYgKHZhbHVlICE9PSBudWxsKSB7XHJcbiAgICBzZXNzaW9uU3RvcmFnZS5zZXRJdGVtKGAke0FTWU5DX1FVRVJZX1NFU1NJT05fSUR9XyR7ZGF0YVNvdXJjZX1gLCB2YWx1ZSk7XHJcbiAgfVxyXG59O1xyXG5cclxuZXhwb3J0IGNvbnN0IGdldEFzeW5jU2Vzc2lvbklkID0gKGRhdGFTb3VyY2U6IHN0cmluZykgPT4ge1xyXG4gIHJldHVybiBzZXNzaW9uU3RvcmFnZS5nZXRJdGVtKGAke0FTWU5DX1FVRVJZX1NFU1NJT05fSUR9XyR7ZGF0YVNvdXJjZX1gKTtcclxufTtcclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFMQTtBQUNBO0FBQ0E7QUFDQTs7QUFJTyxNQUFNQyxpQkFBaUIsR0FBR0EsQ0FBQ0MsVUFBa0IsRUFBRUMsS0FBb0IsS0FBSztFQUM3RSxJQUFJQSxLQUFLLEtBQUssSUFBSSxFQUFFO0lBQ2xCQyxjQUFjLENBQUNDLE9BQU8sQ0FBRSxHQUFFQyw4QkFBdUIsSUFBR0osVUFBVyxFQUFDLEVBQUVDLEtBQUssQ0FBQztFQUMxRTtBQUNGLENBQUM7QUFBQ0ksT0FBQSxDQUFBTixpQkFBQSxHQUFBQSxpQkFBQTtBQUVLLE1BQU1PLGlCQUFpQixHQUFJTixVQUFrQixJQUFLO0VBQ3ZELE9BQU9FLGNBQWMsQ0FBQ0ssT0FBTyxDQUFFLEdBQUVILDhCQUF1QixJQUFHSixVQUFXLEVBQUMsQ0FBQztBQUMxRSxDQUFDO0FBQUNLLE9BQUEsQ0FBQUMsaUJBQUEsR0FBQUEsaUJBQUEifQ==