"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = exports.setQueryManager = exports.setPPLService = exports.setOverviewPage = exports.setOSDSavedObjectsClient = exports.setOSDHttp = exports.getQueryManager = exports.getPPLService = exports.getOverviewPage = exports.getOSDSavedObjectsClient = exports.getOSDHttp = void 0;
var _common = require("../../../../src/plugins/opensearch_dashboards_utils/common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let uiSettings;
let notifications;
const uiSettingsService = exports.uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;
    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;
    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject('uiSettings client not initialized.');
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
const [getPPLService, setPPLService] = (0, _common.createGetterSetter)('PPLService');
exports.setPPLService = setPPLService;
exports.getPPLService = getPPLService;
const [getOSDHttp, setOSDHttp] = (0, _common.createGetterSetter)('http');
exports.setOSDHttp = setOSDHttp;
exports.getOSDHttp = getOSDHttp;
const [getOSDSavedObjectsClient, setOSDSavedObjectsClient] = (0, _common.createGetterSetter)('SavedObjectsClient');
exports.setOSDSavedObjectsClient = setOSDSavedObjectsClient;
exports.getOSDSavedObjectsClient = getOSDSavedObjectsClient;
const [getQueryManager, setQueryManager] = (0, _common.createGetterSetter)('QueryManager');
exports.setQueryManager = setQueryManager;
exports.getQueryManager = getQueryManager;
const [getOverviewPage, setOverviewPage] = (0, _common.createGetterSetter)('Page');
exports.setOverviewPage = setOverviewPage;
exports.getOverviewPage = getOverviewPage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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