"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.composeSpan = exports.composeAggregations = void 0;
var _explorer = require("../../../common/constants/explorer");
var _utils = require("../../../common/utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const composeAggregations = (aggConfig, staleStats) => {
  var _staleStats$partition, _staleStats$all_num, _staleStats$delim, _staleStats$dedup_spl;
  return {
    aggregations: aggConfig.series.map(metric => ({
      function_alias: metric[_explorer.CUSTOM_LABEL],
      function: {
        name: metric.aggregation,
        value_expression: metric.name,
        percentile_agg_function: ''
      }
    })),
    groupby: {
      group_fields: [...(aggConfig.dimensions || []), ...(aggConfig.breakdowns || [])].map(dimension => ({
        name: `\`${(0, _utils.removeBacktick)(dimension.name)}\``
      })),
      ...(aggConfig.span && JSON.stringify(aggConfig === null || aggConfig === void 0 ? void 0 : aggConfig.span) !== '{}' && {
        span: composeSpan(aggConfig.span)
      })
    },
    partitions: (_staleStats$partition = staleStats === null || staleStats === void 0 ? void 0 : staleStats.partitions) !== null && _staleStats$partition !== void 0 ? _staleStats$partition : {},
    all_num: (_staleStats$all_num = staleStats === null || staleStats === void 0 ? void 0 : staleStats.all_num) !== null && _staleStats$all_num !== void 0 ? _staleStats$all_num : {},
    delim: (_staleStats$delim = staleStats === null || staleStats === void 0 ? void 0 : staleStats.delim) !== null && _staleStats$delim !== void 0 ? _staleStats$delim : {},
    dedup_split_value: (_staleStats$dedup_spl = staleStats === null || staleStats === void 0 ? void 0 : staleStats.dedup_split_value) !== null && _staleStats$dedup_spl !== void 0 ? _staleStats$dedup_spl : {}
  };
};
exports.composeAggregations = composeAggregations;
const composeSpan = spanConfig => {
  var _spanConfig$CUSTOM_LA, _spanConfig$time_fiel, _spanConfig$time_fiel2, _spanConfig$time_fiel3, _spanConfig$time_fiel4, _spanConfig$unit$0$va, _spanConfig$unit$, _spanConfig$interval;
  return {
    [_explorer.CUSTOM_LABEL]: (_spanConfig$CUSTOM_LA = spanConfig[_explorer.CUSTOM_LABEL]) !== null && _spanConfig$CUSTOM_LA !== void 0 ? _spanConfig$CUSTOM_LA : '',
    span_expression: {
      type: (_spanConfig$time_fiel = (_spanConfig$time_fiel2 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel2 === void 0 ? void 0 : _spanConfig$time_fiel2.type) !== null && _spanConfig$time_fiel !== void 0 ? _spanConfig$time_fiel : 'timestamp',
      field: (_spanConfig$time_fiel3 = (_spanConfig$time_fiel4 = spanConfig.time_field[0]) === null || _spanConfig$time_fiel4 === void 0 ? void 0 : _spanConfig$time_fiel4.name) !== null && _spanConfig$time_fiel3 !== void 0 ? _spanConfig$time_fiel3 : 'timestamp',
      time_unit: (_spanConfig$unit$0$va = (_spanConfig$unit$ = spanConfig.unit[0]) === null || _spanConfig$unit$ === void 0 ? void 0 : _spanConfig$unit$.value) !== null && _spanConfig$unit$0$va !== void 0 ? _spanConfig$unit$0$va : 'd',
      literal_value: (_spanConfig$interval = spanConfig.interval) !== null && _spanConfig$interval !== void 0 ? _spanConfig$interval : 1
    }
  };
};
exports.composeSpan = composeSpan;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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