"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryParser = void 0;
var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");
var _stats_ast_builder = require("../ast/builder/stats_ast_builder");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class PPLQueryParser {
  constructor() {
    _defineProperty(this, "parser", null);
    _defineProperty(this, "visitor", null);
    _defineProperty(this, "rawQuery", '');
  }
  parse(pplQuery) {
    this.rawQuery = pplQuery;
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(this.rawQuery);
    return this;
  }
  getStats() {
    this.visitor = new _stats_ast_builder.StatsAstBuilder();
    let inter = null;
    try {
      inter = this.visitor.visitRoot(this.parser.root()).getTokens();
    } catch (e) {
      console.error(e);
    }
    return inter;
  }
}
exports.PPLQueryParser = PPLQueryParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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