"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggregations = void 0;
var _lodash = require("lodash");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class Aggregations extends _node.PPLNode {
  constructor(name, children, partitions, allNum, delim, aggExprList, groupExprList, dedupSplitValue, indices) {
    super(name, children);
    this.partitions = partitions;
    this.allNum = allNum;
    this.delim = delim;
    this.aggExprList = aggExprList;
    this.groupExprList = groupExprList;
    this.dedupSplitValue = dedupSplitValue;
    this.indices = indices;
  }
  getStartEndIndicesOfOriginQuery() {
    if (this.indices === undefined) {
      return {
        start: -1,
        end: -1
      };
    }
    return {
      start: this.indices.start,
      end: this.indices.end
    };
  }
  getTokens() {
    return {
      partitions: this.partitions,
      all_num: this.allNum,
      delim: this.delim,
      aggregations: this.aggExprList.map(aggTerm => aggTerm.getTokens()),
      groupby: !(0, _lodash.isEmpty)(this.groupExprList) ? this.groupExprList.getTokens() : '',
      dedup_split_value: this.dedupSplitValue
    };
  }
  toString() {
    return `stats ${!(0, _lodash.isEmpty)(this.partitions) ? `${this.partitions} ` : ''}${!(0, _lodash.isEmpty)(this.allNum) ? `${this.allNum} ` : ''}${!(0, _lodash.isEmpty)(this.delim) ? `${this.delim} ` : ''}${this.aggExprList.map(aggTerm => aggTerm.toString()).join(', ')}${!(0, _lodash.isEmpty)(this.groupExprList) ? ` ${this.groupExprList.toString()}` : ''}${!(0, _lodash.isEmpty)(this.dedupSplitValue) ? ` ${this.dedupSplitValue}` : ''}`;
  }
}
exports.Aggregations = Aggregations;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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