"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanExpression = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class SpanExpression extends _node.PPLNode {
  constructor(name, children, fieldExpression, literalValue, timeUnit) {
    super(name, children);
    this.fieldExpression = fieldExpression;
    this.literalValue = literalValue;
    this.timeUnit = timeUnit;
  }
  getTokens() {
    return {
      field: this.fieldExpression,
      literal_value: this.literalValue,
      time_unit: this.timeUnit
    };
  }
  toString() {
    return `span(${this.fieldExpression}, ${this.literalValue}${this.timeUnit})`;
  }
}
exports.SpanExpression = SpanExpression;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbm9kZSIsInJlcXVpcmUiLCJTcGFuRXhwcmVzc2lvbiIsIlBQTE5vZGUiLCJjb25zdHJ1Y3RvciIsIm5hbWUiLCJjaGlsZHJlbiIsImZpZWxkRXhwcmVzc2lvbiIsImxpdGVyYWxWYWx1ZSIsInRpbWVVbml0IiwiZ2V0VG9rZW5zIiwiZmllbGQiLCJsaXRlcmFsX3ZhbHVlIiwidGltZV91bml0IiwidG9TdHJpbmciLCJleHBvcnRzIl0sInNvdXJjZXMiOlsic3BhbkV4cHJlc3Npb24udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgUFBMTm9kZSB9IGZyb20gJy4uL25vZGUnO1xyXG5cclxuZXhwb3J0IGNsYXNzIFNwYW5FeHByZXNzaW9uIGV4dGVuZHMgUFBMTm9kZSB7XHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBuYW1lOiBzdHJpbmcsXHJcbiAgICBjaGlsZHJlbjogQXJyYXk8UFBMTm9kZT4sXHJcbiAgICBwcml2YXRlIGZpZWxkRXhwcmVzc2lvbjogc3RyaW5nLFxyXG4gICAgcHJpdmF0ZSBsaXRlcmFsVmFsdWU6IHN0cmluZyxcclxuICAgIHByaXZhdGUgdGltZVVuaXQ6IHN0cmluZ1xyXG4gICkge1xyXG4gICAgc3VwZXIobmFtZSwgY2hpbGRyZW4pO1xyXG4gIH1cclxuXHJcbiAgZ2V0VG9rZW5zKCkge1xyXG4gICAgcmV0dXJuIHtcclxuICAgICAgZmllbGQ6IHRoaXMuZmllbGRFeHByZXNzaW9uLFxyXG4gICAgICBsaXRlcmFsX3ZhbHVlOiB0aGlzLmxpdGVyYWxWYWx1ZSxcclxuICAgICAgdGltZV91bml0OiB0aGlzLnRpbWVVbml0LFxyXG4gICAgfTtcclxuICB9XHJcblxyXG4gIHRvU3RyaW5nKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gYHNwYW4oJHt0aGlzLmZpZWxkRXhwcmVzc2lvbn0sICR7dGhpcy5saXRlcmFsVmFsdWV9JHt0aGlzLnRpbWVVbml0fSlgO1xyXG4gIH1cclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLEtBQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1DLGNBQWMsU0FBU0MsYUFBTyxDQUFDO0VBQzFDQyxXQUFXQSxDQUNUQyxJQUFZLEVBQ1pDLFFBQXdCLEVBQ2hCQyxlQUF1QixFQUN2QkMsWUFBb0IsRUFDcEJDLFFBQWdCLEVBQ3hCO0lBQ0EsS0FBSyxDQUFDSixJQUFJLEVBQUVDLFFBQVEsQ0FBQztJQUFDLEtBSmRDLGVBQXVCLEdBQXZCQSxlQUF1QjtJQUFBLEtBQ3ZCQyxZQUFvQixHQUFwQkEsWUFBb0I7SUFBQSxLQUNwQkMsUUFBZ0IsR0FBaEJBLFFBQWdCO0VBRzFCO0VBRUFDLFNBQVNBLENBQUEsRUFBRztJQUNWLE9BQU87TUFDTEMsS0FBSyxFQUFFLElBQUksQ0FBQ0osZUFBZTtNQUMzQkssYUFBYSxFQUFFLElBQUksQ0FBQ0osWUFBWTtNQUNoQ0ssU0FBUyxFQUFFLElBQUksQ0FBQ0o7SUFDbEIsQ0FBQztFQUNIO0VBRUFLLFFBQVFBLENBQUEsRUFBVztJQUNqQixPQUFRLFFBQU8sSUFBSSxDQUFDUCxlQUFnQixLQUFJLElBQUksQ0FBQ0MsWUFBYSxHQUFFLElBQUksQ0FBQ0MsUUFBUyxHQUFFO0VBQzlFO0FBQ0Y7QUFBQ00sT0FBQSxDQUFBYixjQUFBLEdBQUFBLGNBQUEifQ==