"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Span = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class Span extends _node.PPLNode {
  constructor(name, children, spanExpression, customLabel) {
    super(name, children);
    this.spanExpression = spanExpression;
    this.customLabel = customLabel;
  }
  getTokens() {
    return {
      span_expression: this.spanExpression.getTokens(),
      customLabel: this.customLabel
    };
  }
  toString() {
    return `${this.spanExpression.toString()}${this.customLabel ? ` as ${this.customLabel}` : ''}`;
  }
}
exports.Span = Span;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbm9kZSIsInJlcXVpcmUiLCJTcGFuIiwiUFBMTm9kZSIsImNvbnN0cnVjdG9yIiwibmFtZSIsImNoaWxkcmVuIiwic3BhbkV4cHJlc3Npb24iLCJjdXN0b21MYWJlbCIsImdldFRva2VucyIsInNwYW5fZXhwcmVzc2lvbiIsInRvU3RyaW5nIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbInNwYW4udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgUFBMTm9kZSB9IGZyb20gJy4uL25vZGUnO1xyXG5cclxuZXhwb3J0IGNsYXNzIFNwYW4gZXh0ZW5kcyBQUExOb2RlIHtcclxuICBjb25zdHJ1Y3RvcihcclxuICAgIG5hbWU6IHN0cmluZyxcclxuICAgIGNoaWxkcmVuOiBQUExOb2RlW10sXHJcbiAgICBwcml2YXRlIHNwYW5FeHByZXNzaW9uOiBQUExOb2RlLFxyXG4gICAgcHJpdmF0ZSBjdXN0b21MYWJlbDogc3RyaW5nXHJcbiAgKSB7XHJcbiAgICBzdXBlcihuYW1lLCBjaGlsZHJlbik7XHJcbiAgfVxyXG5cclxuICBnZXRUb2tlbnMoKSB7XHJcbiAgICByZXR1cm4ge1xyXG4gICAgICBzcGFuX2V4cHJlc3Npb246IHRoaXMuc3BhbkV4cHJlc3Npb24uZ2V0VG9rZW5zKCksXHJcbiAgICAgIGN1c3RvbUxhYmVsOiB0aGlzLmN1c3RvbUxhYmVsLFxyXG4gICAgfTtcclxuICB9XHJcblxyXG4gIHRvU3RyaW5nKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gYCR7dGhpcy5zcGFuRXhwcmVzc2lvbi50b1N0cmluZygpfSR7dGhpcy5jdXN0b21MYWJlbCA/IGAgYXMgJHt0aGlzLmN1c3RvbUxhYmVsfWAgOiAnJ31gO1xyXG4gIH1cclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLEtBQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1DLElBQUksU0FBU0MsYUFBTyxDQUFDO0VBQ2hDQyxXQUFXQSxDQUNUQyxJQUFZLEVBQ1pDLFFBQW1CLEVBQ1hDLGNBQXVCLEVBQ3ZCQyxXQUFtQixFQUMzQjtJQUNBLEtBQUssQ0FBQ0gsSUFBSSxFQUFFQyxRQUFRLENBQUM7SUFBQyxLQUhkQyxjQUF1QixHQUF2QkEsY0FBdUI7SUFBQSxLQUN2QkMsV0FBbUIsR0FBbkJBLFdBQW1CO0VBRzdCO0VBRUFDLFNBQVNBLENBQUEsRUFBRztJQUNWLE9BQU87TUFDTEMsZUFBZSxFQUFFLElBQUksQ0FBQ0gsY0FBYyxDQUFDRSxTQUFTLENBQUMsQ0FBQztNQUNoREQsV0FBVyxFQUFFLElBQUksQ0FBQ0E7SUFDcEIsQ0FBQztFQUNIO0VBRUFHLFFBQVFBLENBQUEsRUFBVztJQUNqQixPQUFRLEdBQUUsSUFBSSxDQUFDSixjQUFjLENBQUNJLFFBQVEsQ0FBQyxDQUFFLEdBQUUsSUFBSSxDQUFDSCxXQUFXLEdBQUksT0FBTSxJQUFJLENBQUNBLFdBQVksRUFBQyxHQUFHLEVBQUcsRUFBQztFQUNoRztBQUNGO0FBQUNJLE9BQUEsQ0FBQVYsSUFBQSxHQUFBQSxJQUFBIn0=