"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBy = void 0;
var _lodash = require("lodash");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class GroupBy extends _node.PPLNode {
  constructor(name, children, fields, span) {
    super(name, children);
    this.fields = fields;
    this.span = span;
  }
  getTokens() {
    var _this$span;
    return {
      group_fields: this.fields.map(field => field.getTokens()),
      span: (_this$span = this.span) === null || _this$span === void 0 ? void 0 : _this$span.getTokens()
    };
  }
  toString() {
    return `${!(0, _lodash.isEmpty)(this.fields) || !(0, _lodash.isEmpty)(this.span) ? 'by ' : ''}` + `${!(0, _lodash.isEmpty)(this.span) ? `${this.span.toString()}${this.fields.length > 0 ? ', ' : ''}` : ''}${this.fields.map(field => field.toString()).join(', ')}`;
  }
}
exports.GroupBy = GroupBy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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