"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateTerm = void 0;
var _explorer = require("../../../../common/constants/explorer");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AggregateTerm extends _node.PPLNode {
  constructor(name, children, statsFunction, customLabel) {
    super(name, children);
    this.statsFunction = statsFunction;
    this.customLabel = customLabel;
  }
  getTokens() {
    return {
      function: this.statsFunction.getTokens(),
      [_explorer.CUSTOM_LABEL]: this[_explorer.CUSTOM_LABEL]
    };
  }
  toString() {
    if (this[_explorer.CUSTOM_LABEL]) {
      return `${this.statsFunction.toString()}${this[_explorer.CUSTOM_LABEL] ? ` as ${this[_explorer.CUSTOM_LABEL]}` : ''}`;
    }
    return `${this.statsFunction.toString()}`;
  }
}
exports.AggregateTerm = AggregateTerm;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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