"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateFunction = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AggregateFunction extends _node.PPLNode {
  constructor(name, children, statsFunctionName, valueExpression, percentileAggFunction) {
    super(name, children);
    this.statsFunctionName = statsFunctionName;
    this.valueExpression = valueExpression;
    this.percentileAggFunction = percentileAggFunction;
  }
  getTokens() {
    return {
      name: this.statsFunctionName,
      value_expression: this.valueExpression,
      percentile_agg_function: this.percentileAggFunction
    };
  }
  toString() {
    if (this.statsFunctionName && this.valueExpression) {
      return `${this.statsFunctionName}(${this.valueExpression})`;
    } else if (this.statsFunctionName) {
      return `${this.statsFunctionName}()`;
    } else if (this.percentileAggFunction) {
      return `${this.percentileAggFunction}`;
    }
    return '';
  }
}
exports.AggregateFunction = AggregateFunction;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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