"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBuilder = void 0;
var _lodash = require("lodash");
var _aggragations = require("../tree/aggragations");
var _expression = require("../expression");
var _explorer = require("../../../../common/constants/explorer");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class StatsBuilder {
  constructor(statsChunk) {
    this.statsChunk = statsChunk;
  }
  build() {
    // return a new stats subtree
    return new _aggragations.Aggregations('stats_command', [], !(0, _lodash.isEmpty)(this.statsChunk.partitions) ? this.buildParttions(this.statsChunk.partitions) : '', !(0, _lodash.isEmpty)(this.statsChunk.all_num) ? this.buildAllNum(this.statsChunk.all_num) : '', !(0, _lodash.isEmpty)(this.statsChunk.delim) ? this.buildDelim(this.statsChunk.delim) : '', !(0, _lodash.isEmpty)(this.statsChunk.aggregations) ? this.buildAggList(this.statsChunk.aggregations) : [], !(0, _lodash.isEmpty)(this.statsChunk.groupby) ? this.buildGroupList(this.statsChunk.groupby) : new _expression.GroupBy('stats_by_clause', [], [], null), !(0, _lodash.isEmpty)(this.statsChunk.dedup_split_value) ? this.buildDedupSplitValue(this.statsChunk.dedup_split_value) : '');
  }

  /**
   * Flags
   */
  buildParttions(partitions) {
    return `${partitions.keyword} ${partitions.sign} ${partitions.value}`;
  }
  buildAllNum(allNum) {
    return `${allNum.keyword} ${allNum.sign} ${allNum.value}`;
  }
  buildDelim(delim) {
    return `${delim.keyword} ${delim.sign} ${delim.value}`;
  }
  buildDedupSplitValue(dedupSplitvalue) {
    return `${dedupSplitvalue.keyword} ${dedupSplitvalue.sign} ${dedupSplitvalue.value}`;
  }

  /**
   * Aggregations
   */
  buildAggList(aggregations) {
    return aggregations.map(aggregation => {
      return this.buildAggTerm(aggregation);
    });
  }
  buildAggTerm(aggTerm) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.buildAggregateFunction(aggTerm.function), aggTerm.function_alias);
  }
  buildAggregateFunction(aggFunction) {
    return new _expression.AggregateFunction('stats_function', [], aggFunction.name, aggFunction.value_expression, aggFunction.percentile_agg_function);
  }

  /**
   * Groups
   */
  buildGroupList(groupby) {
    return new _expression.GroupBy('stats_by_clause', [], this.buildFieldList(groupby.group_fields), groupby.span ? this.buildSpan(groupby.span) : null);
  }
  buildFieldList(group_fields) {
    return group_fields.map(gf => {
      return new _expression.Field('field_expression', [], gf.name);
    });
  }
  buildSpan(span) {
    return new _expression.Span('span_clause', [], this.buildeSpanExpression(span.span_expression), span[_explorer.CUSTOM_LABEL]);
  }
  buildeSpanExpression(spanExpression) {
    return new _expression.SpanExpression('span_expression', [], spanExpression.field, spanExpression.literal_value, spanExpression.time_unit);
  }
}
exports.StatsBuilder = StatsBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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