"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsAstBuilder = void 0;
var _lodash = require("lodash");
var _AbstractParseTreeVisitor = require("antlr4ts/tree/AbstractParseTreeVisitor");
var _node = require("../node");
var _aggragations = require("../tree/aggragations");
var _expression = require("../expression");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class StatsAstBuilder extends _AbstractParseTreeVisitor.AbstractParseTreeVisitor {
  defaultResult() {
    return new _node.PPLNode('default', []);
  }
  visitRoot(ctx) {
    if (!ctx.pplStatement()) return this.defaultResult();
    return this.visitPplStatement(ctx.pplStatement());
  }
  visitPplStatement(ctx) {
    let statsTree = this.defaultResult();
    ctx.commands().map(pplCommandContext => {
      if ((0, _lodash.isFunction)(this.visitChildren(pplCommandContext).getName) && (0, _lodash.isEqual)(this.visitChildren(pplCommandContext).getName(), 'stats_command')) statsTree = this.visitChildren(pplCommandContext);
    });
    return statsTree;
  }
  visitCommands(ctx) {
    if (ctx.statsCommand()) {
      return this.visitStatsCommand(ctx.statsCommand());
    }
    return this.defaultResult();
  }

  /**
   * Stats command
   */
  visitStatsCommand(ctx) {
    var _ctx$PARTITIONS, _ctx$integerLiteral, _ctx$ALLNUM, _ctx$DELIM, _ctx$DEDUP_SPLITVALUE, _ctx$stop;
    return new _aggragations.Aggregations('stats_command', [], ctx.PARTITIONS() && ctx.integerLiteral() ? {
      keyword: (_ctx$PARTITIONS = ctx.PARTITIONS()) === null || _ctx$PARTITIONS === void 0 ? void 0 : _ctx$PARTITIONS.text,
      sign: '=',
      value: (_ctx$integerLiteral = ctx.integerLiteral()) === null || _ctx$integerLiteral === void 0 ? void 0 : _ctx$integerLiteral.text
    } : {},
    // visit partitions partial
    ctx.ALLNUM() && ctx.booleanLiteral() ? {
      keyword: (_ctx$ALLNUM = ctx.ALLNUM()) === null || _ctx$ALLNUM === void 0 ? void 0 : _ctx$ALLNUM.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[0])
    } : {},
    // visit allnum partial
    ctx.DELIM() && ctx.stringLiteral() ? {
      keyword: (_ctx$DELIM = ctx.DELIM()) === null || _ctx$DELIM === void 0 ? void 0 : _ctx$DELIM.text,
      sign: '=',
      value: this.visitStringLiteral(ctx.stringLiteral())
    } : '',
    // visit delim partial
    ctx.statsAggTerm().map(aggTermAlternative => this.visitStatsAggTerm(aggTermAlternative)),
    // visit statsAggTerm
    ctx.statsByClause() ? this.visitStatsByClause(ctx.statsByClause()) : {},
    // visit group list
    ctx.DEDUP_SPLITVALUES() && ctx.booleanLiteral() ? {
      keyword: (_ctx$DEDUP_SPLITVALUE = ctx.DEDUP_SPLITVALUES()) === null || _ctx$DEDUP_SPLITVALUE === void 0 ? void 0 : _ctx$DEDUP_SPLITVALUE.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[1])
    } : '',
    // visit dedup split value
    {
      start: ctx.start.startIndex,
      end: (_ctx$stop = ctx.stop) === null || _ctx$stop === void 0 ? void 0 : _ctx$stop.stopIndex
    } // stats start/end indices in query for later query concatenation
    );
  }

  visitIntegerLiteral(ctx) {
    return ctx.text;
  }
  visitBooleanLiteral(ctx) {
    return ctx.text;
  }
  visitStringLiteral(ctx) {
    return ctx.text;
  }
  visitStatsAggTerm(ctx) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.visitStatsFunction(ctx.statsFunction()), ctx.wcFieldExpression() ? this.visitWcFieldExpression(ctx.wcFieldExpression()) : '');
  }
  visitWcFieldExpression(ctx) {
    // return only text from here to all its chilren for now
    return ctx.wcQualifiedName().text;
  }
  visitStatsByClause(ctx) {
    return new _expression.GroupBy('stats_by_clause', [], ctx.fieldList() ? this.visitFieldList(ctx.fieldList()) : [], ctx.bySpanClause() ? this.visitBySpanClause(ctx.bySpanClause()) : this.defaultResult());
  }
  visitBySpanClause(ctx) {
    return new _expression.Span('span_clause', [], this.visitSpanClause(ctx.spanClause()), ctx.qualifiedName() ? this.visitQualifiedName(ctx.qualifiedName()) : '');
  }
  visitSpanClause(ctx) {
    return new _expression.SpanExpression('span_expression', [], this.visitFieldExpression(ctx.fieldExpression()), this.visitLiteralValue(ctx.literalValue()), ctx.timespanUnit() ? this.visitTimespanUnit(ctx.timespanUnit()) : '');
  }
  visitLiteralValue(ctx) {
    return ctx.text;
  }
  visitTimespanUnit(ctx) {
    return ctx.text;
  }
  visitStatsFunction(ctx) {
    let funcName = '';
    let valueExpr = '';
    if ((0, _lodash.isFunction)(ctx.valueExpression)) {
      valueExpr = this.visitValueExpression(ctx.valueExpression());
      if ((0, _lodash.isFunction)(ctx.statsFunctionName)) {
        funcName = this.visitStatsFunctionName(ctx.statsFunctionName());
      } else {
        funcName = ctx.DISTINCT_COUNT() ? ctx.DISTINCT_COUNT().text : ctx.DC().text;
      }
    } else if ((0, _lodash.isFunction)(ctx.percentileAggFunction)) {
      // for now just return plain text
    } else if ((0, _lodash.isFunction)(ctx.COUNT)) {
      funcName = ctx.COUNT().text;
    }
    return new _expression.AggregateFunction('stats_function', [], funcName, valueExpr, (0, _lodash.isFunction)(ctx.percentileAggFunction) ? ctx.text : '');
  }
  visitValueExpression(ctx) {
    return ctx.text;
  }
  visitStatsFunctionName(ctx) {
    return ctx.text;
  }
  visitFieldList(ctx) {
    return ctx.fieldExpression().map(fieldExprAlternative => {
      return new _expression.Field('field_expression', [], this.visitFieldExpression(fieldExprAlternative));
    });
  }
  visitFieldExpression(ctx) {
    return this.visitQualifiedName(ctx.qualifiedName());
  }
  visitQualifiedName(ctx) {
    return ctx.text;
  }
}
exports.StatsAstBuilder = StatsAstBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwicmVxdWlyZSIsIl9BYnN0cmFjdFBhcnNlVHJlZVZpc2l0b3IiLCJfbm9kZSIsIl9hZ2dyYWdhdGlvbnMiLCJfZXhwcmVzc2lvbiIsIlN0YXRzQXN0QnVpbGRlciIsIkFic3RyYWN0UGFyc2VUcmVlVmlzaXRvciIsImRlZmF1bHRSZXN1bHQiLCJQUExOb2RlIiwidmlzaXRSb290IiwiY3R4IiwicHBsU3RhdGVtZW50IiwidmlzaXRQcGxTdGF0ZW1lbnQiLCJzdGF0c1RyZWUiLCJjb21tYW5kcyIsIm1hcCIsInBwbENvbW1hbmRDb250ZXh0IiwiaXNGdW5jdGlvbiIsInZpc2l0Q2hpbGRyZW4iLCJnZXROYW1lIiwiaXNFcXVhbCIsInZpc2l0Q29tbWFuZHMiLCJzdGF0c0NvbW1hbmQiLCJ2aXNpdFN0YXRzQ29tbWFuZCIsIl9jdHgkUEFSVElUSU9OUyIsIl9jdHgkaW50ZWdlckxpdGVyYWwiLCJfY3R4JEFMTE5VTSIsIl9jdHgkREVMSU0iLCJfY3R4JERFRFVQX1NQTElUVkFMVUUiLCJfY3R4JHN0b3AiLCJBZ2dyZWdhdGlvbnMiLCJQQVJUSVRJT05TIiwiaW50ZWdlckxpdGVyYWwiLCJrZXl3b3JkIiwidGV4dCIsInNpZ24iLCJ2YWx1ZSIsIkFMTE5VTSIsImJvb2xlYW5MaXRlcmFsIiwidmlzaXRCb29sZWFuTGl0ZXJhbCIsIkRFTElNIiwic3RyaW5nTGl0ZXJhbCIsInZpc2l0U3RyaW5nTGl0ZXJhbCIsInN0YXRzQWdnVGVybSIsImFnZ1Rlcm1BbHRlcm5hdGl2ZSIsInZpc2l0U3RhdHNBZ2dUZXJtIiwic3RhdHNCeUNsYXVzZSIsInZpc2l0U3RhdHNCeUNsYXVzZSIsIkRFRFVQX1NQTElUVkFMVUVTIiwic3RhcnQiLCJzdGFydEluZGV4IiwiZW5kIiwic3RvcCIsInN0b3BJbmRleCIsInZpc2l0SW50ZWdlckxpdGVyYWwiLCJBZ2dyZWdhdGVUZXJtIiwidmlzaXRTdGF0c0Z1bmN0aW9uIiwic3RhdHNGdW5jdGlvbiIsIndjRmllbGRFeHByZXNzaW9uIiwidmlzaXRXY0ZpZWxkRXhwcmVzc2lvbiIsIndjUXVhbGlmaWVkTmFtZSIsIkdyb3VwQnkiLCJmaWVsZExpc3QiLCJ2aXNpdEZpZWxkTGlzdCIsImJ5U3BhbkNsYXVzZSIsInZpc2l0QnlTcGFuQ2xhdXNlIiwiU3BhbiIsInZpc2l0U3BhbkNsYXVzZSIsInNwYW5DbGF1c2UiLCJxdWFsaWZpZWROYW1lIiwidmlzaXRRdWFsaWZpZWROYW1lIiwiU3BhbkV4cHJlc3Npb24iLCJ2aXNpdEZpZWxkRXhwcmVzc2lvbiIsImZpZWxkRXhwcmVzc2lvbiIsInZpc2l0TGl0ZXJhbFZhbHVlIiwibGl0ZXJhbFZhbHVlIiwidGltZXNwYW5Vbml0IiwidmlzaXRUaW1lc3BhblVuaXQiLCJmdW5jTmFtZSIsInZhbHVlRXhwciIsInZhbHVlRXhwcmVzc2lvbiIsInZpc2l0VmFsdWVFeHByZXNzaW9uIiwic3RhdHNGdW5jdGlvbk5hbWUiLCJ2aXNpdFN0YXRzRnVuY3Rpb25OYW1lIiwiRElTVElOQ1RfQ09VTlQiLCJEQyIsInBlcmNlbnRpbGVBZ2dGdW5jdGlvbiIsIkNPVU5UIiwiQWdncmVnYXRlRnVuY3Rpb24iLCJmaWVsZEV4cHJBbHRlcm5hdGl2ZSIsIkZpZWxkIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbInN0YXRzX2FzdF9idWlsZGVyLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IGlzRnVuY3Rpb24sIGlzRXF1YWwgfSBmcm9tICdsb2Rhc2gnO1xyXG5pbXBvcnQgeyBBYnN0cmFjdFBhcnNlVHJlZVZpc2l0b3IgfSBmcm9tICdhbnRscjR0cy90cmVlL0Fic3RyYWN0UGFyc2VUcmVlVmlzaXRvcic7XHJcbmltcG9ydCB7XHJcbiAgUm9vdENvbnRleHQsXHJcbiAgUHBsU3RhdGVtZW50Q29udGV4dCxcclxuICBDb21tYW5kc0NvbnRleHQsXHJcbiAgU3RhdHNDb21tYW5kQ29udGV4dCxcclxuICBCb29sZWFuTGl0ZXJhbENvbnRleHQsXHJcbiAgQnlTcGFuQ2xhdXNlQ29udGV4dCxcclxuICBGaWVsZEV4cHJlc3Npb25Db250ZXh0LFxyXG4gIEZpZWxkTGlzdENvbnRleHQsXHJcbiAgSW50ZWdlckxpdGVyYWxDb250ZXh0LFxyXG4gIExpdGVyYWxWYWx1ZUNvbnRleHQsXHJcbiAgUXVhbGlmaWVkTmFtZUNvbnRleHQsXHJcbiAgU3BhbkNsYXVzZUNvbnRleHQsXHJcbiAgU3RhdHNBZ2dUZXJtQ29udGV4dCxcclxuICBTdGF0c0J5Q2xhdXNlQ29udGV4dCxcclxuICBTdGF0c0Z1bmN0aW9uQ29udGV4dCxcclxuICBTdGF0c0Z1bmN0aW9uTmFtZUNvbnRleHQsXHJcbiAgU3RyaW5nTGl0ZXJhbENvbnRleHQsXHJcbiAgVGltZXNwYW5Vbml0Q29udGV4dCxcclxuICBWYWx1ZUV4cHJlc3Npb25Db250ZXh0LFxyXG4gIFdjRmllbGRFeHByZXNzaW9uQ29udGV4dCxcclxufSBmcm9tICcuLi8uLi9hbnRsci9vdXRwdXQvT3BlblNlYXJjaFBQTFBhcnNlcic7XHJcbmltcG9ydCB7IE9wZW5TZWFyY2hQUExQYXJzZXJWaXNpdG9yIH0gZnJvbSAnLi4vLi4vYW50bHIvb3V0cHV0L09wZW5TZWFyY2hQUExQYXJzZXJWaXNpdG9yJztcclxuaW1wb3J0IHsgUFBMTm9kZSB9IGZyb20gJy4uL25vZGUnO1xyXG5pbXBvcnQgeyBBZ2dyZWdhdGlvbnMgfSBmcm9tICcuLi90cmVlL2FnZ3JhZ2F0aW9ucyc7XHJcbmltcG9ydCB7XHJcbiAgQWdncmVnYXRlRnVuY3Rpb24sXHJcbiAgQWdncmVnYXRlVGVybSxcclxuICBHcm91cEJ5LFxyXG4gIEZpZWxkLFxyXG4gIFNwYW4sXHJcbiAgU3BhbkV4cHJlc3Npb24sXHJcbn0gZnJvbSAnLi4vZXhwcmVzc2lvbic7XHJcblxyXG50eXBlIFZpc2l0UmVzdWx0ID0gUFBMTm9kZSB8IEFycmF5PFBQTE5vZGU+IHwgc3RyaW5nO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0YXRzQXN0QnVpbGRlclxyXG4gIGV4dGVuZHMgQWJzdHJhY3RQYXJzZVRyZWVWaXNpdG9yPFZpc2l0UmVzdWx0PlxyXG4gIGltcGxlbWVudHMgT3BlblNlYXJjaFBQTFBhcnNlclZpc2l0b3I8VmlzaXRSZXN1bHQ+IHtcclxuICBwcm90ZWN0ZWQgZGVmYXVsdFJlc3VsdCgpOiBQUExOb2RlIHtcclxuICAgIHJldHVybiBuZXcgUFBMTm9kZSgnZGVmYXVsdCcsIFtdIGFzIEFycmF5PFBQTE5vZGU+KTtcclxuICB9XHJcblxyXG4gIHZpc2l0Um9vdChjdHg6IFJvb3RDb250ZXh0KSB7XHJcbiAgICBpZiAoIWN0eC5wcGxTdGF0ZW1lbnQoKSkgcmV0dXJuIHRoaXMuZGVmYXVsdFJlc3VsdCgpO1xyXG4gICAgcmV0dXJuIHRoaXMudmlzaXRQcGxTdGF0ZW1lbnQoY3R4LnBwbFN0YXRlbWVudCgpISk7XHJcbiAgfVxyXG5cclxuICB2aXNpdFBwbFN0YXRlbWVudChjdHg6IFBwbFN0YXRlbWVudENvbnRleHQpOiBQUExOb2RlIHtcclxuICAgIGxldCBzdGF0c1RyZWU6IFZpc2l0UmVzdWx0ID0gdGhpcy5kZWZhdWx0UmVzdWx0KCk7XHJcbiAgICBjdHguY29tbWFuZHMoKS5tYXAoKHBwbENvbW1hbmRDb250ZXh0KSA9PiB7XHJcbiAgICAgIGlmIChcclxuICAgICAgICBpc0Z1bmN0aW9uKHRoaXMudmlzaXRDaGlsZHJlbihwcGxDb21tYW5kQ29udGV4dCkuZ2V0TmFtZSkgJiZcclxuICAgICAgICBpc0VxdWFsKHRoaXMudmlzaXRDaGlsZHJlbihwcGxDb21tYW5kQ29udGV4dCkuZ2V0TmFtZSgpLCAnc3RhdHNfY29tbWFuZCcpXHJcbiAgICAgIClcclxuICAgICAgICBzdGF0c1RyZWUgPSB0aGlzLnZpc2l0Q2hpbGRyZW4ocHBsQ29tbWFuZENvbnRleHQpO1xyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gc3RhdHNUcmVlO1xyXG4gIH1cclxuXHJcbiAgdmlzaXRDb21tYW5kcyhjdHg6IENvbW1hbmRzQ29udGV4dCkge1xyXG4gICAgaWYgKGN0eC5zdGF0c0NvbW1hbmQoKSkge1xyXG4gICAgICByZXR1cm4gdGhpcy52aXNpdFN0YXRzQ29tbWFuZChjdHguc3RhdHNDb21tYW5kKCkhKTtcclxuICAgIH1cclxuICAgIHJldHVybiB0aGlzLmRlZmF1bHRSZXN1bHQoKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFN0YXRzIGNvbW1hbmRcclxuICAgKi9cclxuICB2aXNpdFN0YXRzQ29tbWFuZChjdHg6IFN0YXRzQ29tbWFuZENvbnRleHQpOiBQUExOb2RlIHtcclxuICAgIHJldHVybiBuZXcgQWdncmVnYXRpb25zKFxyXG4gICAgICAnc3RhdHNfY29tbWFuZCcsXHJcbiAgICAgIFtdIGFzIEFycmF5PFBQTE5vZGU+LFxyXG4gICAgICBjdHguUEFSVElUSU9OUygpICYmIGN0eC5pbnRlZ2VyTGl0ZXJhbCgpXHJcbiAgICAgICAgPyB7XHJcbiAgICAgICAgICAgIGtleXdvcmQ6IGN0eC5QQVJUSVRJT05TKCk/LnRleHQsXHJcbiAgICAgICAgICAgIHNpZ246ICc9JyxcclxuICAgICAgICAgICAgdmFsdWU6IGN0eC5pbnRlZ2VyTGl0ZXJhbCgpPy50ZXh0LFxyXG4gICAgICAgICAgfVxyXG4gICAgICAgIDoge30sIC8vIHZpc2l0IHBhcnRpdGlvbnMgcGFydGlhbFxyXG4gICAgICBjdHguQUxMTlVNKCkgJiYgY3R4LmJvb2xlYW5MaXRlcmFsKClcclxuICAgICAgICA/IHtcclxuICAgICAgICAgICAga2V5d29yZDogY3R4LkFMTE5VTSgpPy50ZXh0LFxyXG4gICAgICAgICAgICBzaWduOiAnPScsXHJcbiAgICAgICAgICAgIHZhbHVlOiB0aGlzLnZpc2l0Qm9vbGVhbkxpdGVyYWwoY3R4LmJvb2xlYW5MaXRlcmFsKClbMF0pLFxyXG4gICAgICAgICAgfVxyXG4gICAgICAgIDoge30sIC8vIHZpc2l0IGFsbG51bSBwYXJ0aWFsXHJcbiAgICAgIGN0eC5ERUxJTSgpICYmIGN0eC5zdHJpbmdMaXRlcmFsKClcclxuICAgICAgICA/IHtcclxuICAgICAgICAgICAga2V5d29yZDogY3R4LkRFTElNKCk/LnRleHQsXHJcbiAgICAgICAgICAgIHNpZ246ICc9JyxcclxuICAgICAgICAgICAgdmFsdWU6IHRoaXMudmlzaXRTdHJpbmdMaXRlcmFsKGN0eC5zdHJpbmdMaXRlcmFsKCkhKSxcclxuICAgICAgICAgIH1cclxuICAgICAgICA6ICcnLCAvLyB2aXNpdCBkZWxpbSBwYXJ0aWFsXHJcbiAgICAgIGN0eC5zdGF0c0FnZ1Rlcm0oKS5tYXAoKGFnZ1Rlcm1BbHRlcm5hdGl2ZSkgPT4gdGhpcy52aXNpdFN0YXRzQWdnVGVybShhZ2dUZXJtQWx0ZXJuYXRpdmUpKSwgLy8gdmlzaXQgc3RhdHNBZ2dUZXJtXHJcbiAgICAgIGN0eC5zdGF0c0J5Q2xhdXNlKCkgPyB0aGlzLnZpc2l0U3RhdHNCeUNsYXVzZShjdHguc3RhdHNCeUNsYXVzZSgpISkgOiAoe30gYXMgR3JvdXBCeSksIC8vIHZpc2l0IGdyb3VwIGxpc3RcclxuICAgICAgY3R4LkRFRFVQX1NQTElUVkFMVUVTKCkgJiYgY3R4LmJvb2xlYW5MaXRlcmFsKClcclxuICAgICAgICA/IHtcclxuICAgICAgICAgICAga2V5d29yZDogY3R4LkRFRFVQX1NQTElUVkFMVUVTKCk/LnRleHQsXHJcbiAgICAgICAgICAgIHNpZ246ICc9JyxcclxuICAgICAgICAgICAgdmFsdWU6IHRoaXMudmlzaXRCb29sZWFuTGl0ZXJhbChjdHguYm9vbGVhbkxpdGVyYWwoKVsxXSksXHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgOiAnJywgLy8gdmlzaXQgZGVkdXAgc3BsaXQgdmFsdWVcclxuICAgICAge1xyXG4gICAgICAgIHN0YXJ0OiBjdHguc3RhcnQuc3RhcnRJbmRleCxcclxuICAgICAgICBlbmQ6IGN0eC5zdG9wPy5zdG9wSW5kZXgsXHJcbiAgICAgIH0gLy8gc3RhdHMgc3RhcnQvZW5kIGluZGljZXMgaW4gcXVlcnkgZm9yIGxhdGVyIHF1ZXJ5IGNvbmNhdGVuYXRpb25cclxuICAgICk7XHJcbiAgfVxyXG5cclxuICB2aXNpdEludGVnZXJMaXRlcmFsKGN0eDogSW50ZWdlckxpdGVyYWxDb250ZXh0KTogc3RyaW5nIHtcclxuICAgIHJldHVybiBjdHgudGV4dDtcclxuICB9XHJcblxyXG4gIHZpc2l0Qm9vbGVhbkxpdGVyYWwoY3R4OiBCb29sZWFuTGl0ZXJhbENvbnRleHQpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGN0eC50ZXh0O1xyXG4gIH1cclxuXHJcbiAgdmlzaXRTdHJpbmdMaXRlcmFsKGN0eDogU3RyaW5nTGl0ZXJhbENvbnRleHQpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGN0eC50ZXh0O1xyXG4gIH1cclxuXHJcbiAgdmlzaXRTdGF0c0FnZ1Rlcm0oY3R4OiBTdGF0c0FnZ1Rlcm1Db250ZXh0KTogUFBMTm9kZSB7XHJcbiAgICByZXR1cm4gbmV3IEFnZ3JlZ2F0ZVRlcm0oXHJcbiAgICAgICdzdGF0c19hZ2dfdGVybScsXHJcbiAgICAgIFtdIGFzIEFycmF5PFBQTE5vZGU+LFxyXG4gICAgICB0aGlzLnZpc2l0U3RhdHNGdW5jdGlvbihjdHguc3RhdHNGdW5jdGlvbigpKSxcclxuICAgICAgY3R4LndjRmllbGRFeHByZXNzaW9uKCkgPyB0aGlzLnZpc2l0V2NGaWVsZEV4cHJlc3Npb24oY3R4LndjRmllbGRFeHByZXNzaW9uKCkhKSA6ICcnXHJcbiAgICApO1xyXG4gIH1cclxuXHJcbiAgdmlzaXRXY0ZpZWxkRXhwcmVzc2lvbihjdHg6IFdjRmllbGRFeHByZXNzaW9uQ29udGV4dCk6IHN0cmluZyB7XHJcbiAgICAvLyByZXR1cm4gb25seSB0ZXh0IGZyb20gaGVyZSB0byBhbGwgaXRzIGNoaWxyZW4gZm9yIG5vd1xyXG4gICAgcmV0dXJuIGN0eC53Y1F1YWxpZmllZE5hbWUoKS50ZXh0O1xyXG4gIH1cclxuXHJcbiAgdmlzaXRTdGF0c0J5Q2xhdXNlKGN0eDogU3RhdHNCeUNsYXVzZUNvbnRleHQpOiBQUExOb2RlIHtcclxuICAgIHJldHVybiBuZXcgR3JvdXBCeShcclxuICAgICAgJ3N0YXRzX2J5X2NsYXVzZScsXHJcbiAgICAgIFtdIGFzIEFycmF5PFBQTE5vZGU+LFxyXG4gICAgICBjdHguZmllbGRMaXN0KCkgPyB0aGlzLnZpc2l0RmllbGRMaXN0KGN0eC5maWVsZExpc3QoKSEpIDogW10sXHJcbiAgICAgIGN0eC5ieVNwYW5DbGF1c2UoKSA/IHRoaXMudmlzaXRCeVNwYW5DbGF1c2UoY3R4LmJ5U3BhbkNsYXVzZSgpISkgOiB0aGlzLmRlZmF1bHRSZXN1bHQoKVxyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIHZpc2l0QnlTcGFuQ2xhdXNlKGN0eDogQnlTcGFuQ2xhdXNlQ29udGV4dCk6IFBQTE5vZGUge1xyXG4gICAgcmV0dXJuIG5ldyBTcGFuKFxyXG4gICAgICAnc3Bhbl9jbGF1c2UnLFxyXG4gICAgICBbXSBhcyBBcnJheTxQUExOb2RlPixcclxuICAgICAgdGhpcy52aXNpdFNwYW5DbGF1c2UoY3R4LnNwYW5DbGF1c2UoKSksXHJcbiAgICAgIGN0eC5xdWFsaWZpZWROYW1lKCkgPyB0aGlzLnZpc2l0UXVhbGlmaWVkTmFtZShjdHgucXVhbGlmaWVkTmFtZSgpISkgOiAnJ1xyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIHZpc2l0U3BhbkNsYXVzZShjdHg6IFNwYW5DbGF1c2VDb250ZXh0KTogUFBMTm9kZSB7XHJcbiAgICByZXR1cm4gbmV3IFNwYW5FeHByZXNzaW9uKFxyXG4gICAgICAnc3Bhbl9leHByZXNzaW9uJyxcclxuICAgICAgW10gYXMgQXJyYXk8UFBMTm9kZT4sXHJcbiAgICAgIHRoaXMudmlzaXRGaWVsZEV4cHJlc3Npb24oY3R4LmZpZWxkRXhwcmVzc2lvbigpKSxcclxuICAgICAgdGhpcy52aXNpdExpdGVyYWxWYWx1ZShjdHgubGl0ZXJhbFZhbHVlKCkpLFxyXG4gICAgICBjdHgudGltZXNwYW5Vbml0KCkgPyB0aGlzLnZpc2l0VGltZXNwYW5Vbml0KGN0eC50aW1lc3BhblVuaXQoKSEpIDogJydcclxuICAgICk7XHJcbiAgfVxyXG5cclxuICB2aXNpdExpdGVyYWxWYWx1ZShjdHg6IExpdGVyYWxWYWx1ZUNvbnRleHQpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGN0eC50ZXh0O1xyXG4gIH1cclxuXHJcbiAgdmlzaXRUaW1lc3BhblVuaXQoY3R4OiBUaW1lc3BhblVuaXRDb250ZXh0KTogc3RyaW5nIHtcclxuICAgIHJldHVybiBjdHgudGV4dDtcclxuICB9XHJcblxyXG4gIHZpc2l0U3RhdHNGdW5jdGlvbihjdHg6IFN0YXRzRnVuY3Rpb25Db250ZXh0KTogUFBMTm9kZSB7XHJcbiAgICBsZXQgZnVuY05hbWUgPSAnJztcclxuICAgIGxldCB2YWx1ZUV4cHIgPSAnJztcclxuICAgIFxyXG4gICAgaWYgKGlzRnVuY3Rpb24oY3R4LnZhbHVlRXhwcmVzc2lvbikpIHtcclxuICAgICAgdmFsdWVFeHByID0gdGhpcy52aXNpdFZhbHVlRXhwcmVzc2lvbihjdHgudmFsdWVFeHByZXNzaW9uKCkpO1xyXG4gICAgICBpZiAoaXNGdW5jdGlvbihjdHguc3RhdHNGdW5jdGlvbk5hbWUpKSB7XHJcbiAgICAgICAgZnVuY05hbWUgPSB0aGlzLnZpc2l0U3RhdHNGdW5jdGlvbk5hbWUoY3R4LnN0YXRzRnVuY3Rpb25OYW1lKCkpO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIGZ1bmNOYW1lID0gY3R4LkRJU1RJTkNUX0NPVU5UKCkgPyBjdHguRElTVElOQ1RfQ09VTlQoKS50ZXh0IDogY3R4LkRDKCkudGV4dDtcclxuICAgICAgfVxyXG4gICAgfSBlbHNlIGlmIChpc0Z1bmN0aW9uKGN0eC5wZXJjZW50aWxlQWdnRnVuY3Rpb24pKSB7XHJcbiAgICAgIC8vIGZvciBub3cganVzdCByZXR1cm4gcGxhaW4gdGV4dFxyXG4gICAgfSBlbHNlIGlmIChpc0Z1bmN0aW9uKGN0eC5DT1VOVCkpIHtcclxuICAgICAgZnVuY05hbWUgPSBjdHguQ09VTlQoKS50ZXh0O1xyXG4gICAgfVxyXG5cclxuICAgIHJldHVybiBuZXcgQWdncmVnYXRlRnVuY3Rpb24oXHJcbiAgICAgICdzdGF0c19mdW5jdGlvbicsXHJcbiAgICAgIFtdIGFzIEFycmF5PFBQTE5vZGU+LFxyXG4gICAgICBmdW5jTmFtZSxcclxuICAgICAgdmFsdWVFeHByLFxyXG4gICAgICBpc0Z1bmN0aW9uKGN0eC5wZXJjZW50aWxlQWdnRnVuY3Rpb24pID8gY3R4LnRleHQgOiAnJ1xyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIHZpc2l0VmFsdWVFeHByZXNzaW9uKGN0eDogVmFsdWVFeHByZXNzaW9uQ29udGV4dCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gY3R4LnRleHQ7XHJcbiAgfVxyXG5cclxuICB2aXNpdFN0YXRzRnVuY3Rpb25OYW1lKGN0eDogU3RhdHNGdW5jdGlvbk5hbWVDb250ZXh0KTogc3RyaW5nIHtcclxuICAgIHJldHVybiBjdHgudGV4dDtcclxuICB9XHJcblxyXG4gIHZpc2l0RmllbGRMaXN0KGN0eDogRmllbGRMaXN0Q29udGV4dCk6IEFycmF5PFBQTE5vZGU+IHtcclxuICAgIHJldHVybiBjdHguZmllbGRFeHByZXNzaW9uKCkubWFwKChmaWVsZEV4cHJBbHRlcm5hdGl2ZSkgPT4ge1xyXG4gICAgICByZXR1cm4gbmV3IEZpZWxkKFxyXG4gICAgICAgICdmaWVsZF9leHByZXNzaW9uJyxcclxuICAgICAgICBbXSBhcyBBcnJheTxQUExOb2RlPixcclxuICAgICAgICB0aGlzLnZpc2l0RmllbGRFeHByZXNzaW9uKGZpZWxkRXhwckFsdGVybmF0aXZlKVxyXG4gICAgICApO1xyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICB2aXNpdEZpZWxkRXhwcmVzc2lvbihjdHg6IEZpZWxkRXhwcmVzc2lvbkNvbnRleHQpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIHRoaXMudmlzaXRRdWFsaWZpZWROYW1lKGN0eC5xdWFsaWZpZWROYW1lKCkpO1xyXG4gIH1cclxuXHJcbiAgdmlzaXRRdWFsaWZpZWROYW1lKGN0eDogUXVhbGlmaWVkTmFtZUNvbnRleHQpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGN0eC50ZXh0O1xyXG4gIH1cclxufVxyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLHlCQUFBLEdBQUFELE9BQUE7QUF3QkEsSUFBQUUsS0FBQSxHQUFBRixPQUFBO0FBQ0EsSUFBQUcsYUFBQSxHQUFBSCxPQUFBO0FBQ0EsSUFBQUksV0FBQSxHQUFBSixPQUFBO0FBaENBO0FBQ0E7QUFDQTtBQUNBOztBQXdDTyxNQUFNSyxlQUFlLFNBQ2xCQyxrREFBd0IsQ0FDbUI7RUFDekNDLGFBQWFBLENBQUEsRUFBWTtJQUNqQyxPQUFPLElBQUlDLGFBQU8sQ0FBQyxTQUFTLEVBQUUsRUFBb0IsQ0FBQztFQUNyRDtFQUVBQyxTQUFTQSxDQUFDQyxHQUFnQixFQUFFO0lBQzFCLElBQUksQ0FBQ0EsR0FBRyxDQUFDQyxZQUFZLENBQUMsQ0FBQyxFQUFFLE9BQU8sSUFBSSxDQUFDSixhQUFhLENBQUMsQ0FBQztJQUNwRCxPQUFPLElBQUksQ0FBQ0ssaUJBQWlCLENBQUNGLEdBQUcsQ0FBQ0MsWUFBWSxDQUFDLENBQUUsQ0FBQztFQUNwRDtFQUVBQyxpQkFBaUJBLENBQUNGLEdBQXdCLEVBQVc7SUFDbkQsSUFBSUcsU0FBc0IsR0FBRyxJQUFJLENBQUNOLGFBQWEsQ0FBQyxDQUFDO0lBQ2pERyxHQUFHLENBQUNJLFFBQVEsQ0FBQyxDQUFDLENBQUNDLEdBQUcsQ0FBRUMsaUJBQWlCLElBQUs7TUFDeEMsSUFDRSxJQUFBQyxrQkFBVSxFQUFDLElBQUksQ0FBQ0MsYUFBYSxDQUFDRixpQkFBaUIsQ0FBQyxDQUFDRyxPQUFPLENBQUMsSUFDekQsSUFBQUMsZUFBTyxFQUFDLElBQUksQ0FBQ0YsYUFBYSxDQUFDRixpQkFBaUIsQ0FBQyxDQUFDRyxPQUFPLENBQUMsQ0FBQyxFQUFFLGVBQWUsQ0FBQyxFQUV6RU4sU0FBUyxHQUFHLElBQUksQ0FBQ0ssYUFBYSxDQUFDRixpQkFBaUIsQ0FBQztJQUNyRCxDQUFDLENBQUM7SUFDRixPQUFPSCxTQUFTO0VBQ2xCO0VBRUFRLGFBQWFBLENBQUNYLEdBQW9CLEVBQUU7SUFDbEMsSUFBSUEsR0FBRyxDQUFDWSxZQUFZLENBQUMsQ0FBQyxFQUFFO01BQ3RCLE9BQU8sSUFBSSxDQUFDQyxpQkFBaUIsQ0FBQ2IsR0FBRyxDQUFDWSxZQUFZLENBQUMsQ0FBRSxDQUFDO0lBQ3BEO0lBQ0EsT0FBTyxJQUFJLENBQUNmLGFBQWEsQ0FBQyxDQUFDO0VBQzdCOztFQUVBO0FBQ0Y7QUFDQTtFQUNFZ0IsaUJBQWlCQSxDQUFDYixHQUF3QixFQUFXO0lBQUEsSUFBQWMsZUFBQSxFQUFBQyxtQkFBQSxFQUFBQyxXQUFBLEVBQUFDLFVBQUEsRUFBQUMscUJBQUEsRUFBQUMsU0FBQTtJQUNuRCxPQUFPLElBQUlDLDBCQUFZLENBQ3JCLGVBQWUsRUFDZixFQUFFLEVBQ0ZwQixHQUFHLENBQUNxQixVQUFVLENBQUMsQ0FBQyxJQUFJckIsR0FBRyxDQUFDc0IsY0FBYyxDQUFDLENBQUMsR0FDcEM7TUFDRUMsT0FBTyxHQUFBVCxlQUFBLEdBQUVkLEdBQUcsQ0FBQ3FCLFVBQVUsQ0FBQyxDQUFDLGNBQUFQLGVBQUEsdUJBQWhCQSxlQUFBLENBQWtCVSxJQUFJO01BQy9CQyxJQUFJLEVBQUUsR0FBRztNQUNUQyxLQUFLLEdBQUFYLG1CQUFBLEdBQUVmLEdBQUcsQ0FBQ3NCLGNBQWMsQ0FBQyxDQUFDLGNBQUFQLG1CQUFBLHVCQUFwQkEsbUJBQUEsQ0FBc0JTO0lBQy9CLENBQUMsR0FDRCxDQUFDLENBQUM7SUFBRTtJQUNSeEIsR0FBRyxDQUFDMkIsTUFBTSxDQUFDLENBQUMsSUFBSTNCLEdBQUcsQ0FBQzRCLGNBQWMsQ0FBQyxDQUFDLEdBQ2hDO01BQ0VMLE9BQU8sR0FBQVAsV0FBQSxHQUFFaEIsR0FBRyxDQUFDMkIsTUFBTSxDQUFDLENBQUMsY0FBQVgsV0FBQSx1QkFBWkEsV0FBQSxDQUFjUSxJQUFJO01BQzNCQyxJQUFJLEVBQUUsR0FBRztNQUNUQyxLQUFLLEVBQUUsSUFBSSxDQUFDRyxtQkFBbUIsQ0FBQzdCLEdBQUcsQ0FBQzRCLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3pELENBQUMsR0FDRCxDQUFDLENBQUM7SUFBRTtJQUNSNUIsR0FBRyxDQUFDOEIsS0FBSyxDQUFDLENBQUMsSUFBSTlCLEdBQUcsQ0FBQytCLGFBQWEsQ0FBQyxDQUFDLEdBQzlCO01BQ0VSLE9BQU8sR0FBQU4sVUFBQSxHQUFFakIsR0FBRyxDQUFDOEIsS0FBSyxDQUFDLENBQUMsY0FBQWIsVUFBQSx1QkFBWEEsVUFBQSxDQUFhTyxJQUFJO01BQzFCQyxJQUFJLEVBQUUsR0FBRztNQUNUQyxLQUFLLEVBQUUsSUFBSSxDQUFDTSxrQkFBa0IsQ0FBQ2hDLEdBQUcsQ0FBQytCLGFBQWEsQ0FBQyxDQUFFO0lBQ3JELENBQUMsR0FDRCxFQUFFO0lBQUU7SUFDUi9CLEdBQUcsQ0FBQ2lDLFlBQVksQ0FBQyxDQUFDLENBQUM1QixHQUFHLENBQUU2QixrQkFBa0IsSUFBSyxJQUFJLENBQUNDLGlCQUFpQixDQUFDRCxrQkFBa0IsQ0FBQyxDQUFDO0lBQUU7SUFDNUZsQyxHQUFHLENBQUNvQyxhQUFhLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQ0Msa0JBQWtCLENBQUNyQyxHQUFHLENBQUNvQyxhQUFhLENBQUMsQ0FBRSxDQUFDLEdBQUksQ0FBQyxDQUFhO0lBQUU7SUFDdkZwQyxHQUFHLENBQUNzQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUl0QyxHQUFHLENBQUM0QixjQUFjLENBQUMsQ0FBQyxHQUMzQztNQUNFTCxPQUFPLEdBQUFMLHFCQUFBLEdBQUVsQixHQUFHLENBQUNzQyxpQkFBaUIsQ0FBQyxDQUFDLGNBQUFwQixxQkFBQSx1QkFBdkJBLHFCQUFBLENBQXlCTSxJQUFJO01BQ3RDQyxJQUFJLEVBQUUsR0FBRztNQUNUQyxLQUFLLEVBQUUsSUFBSSxDQUFDRyxtQkFBbUIsQ0FBQzdCLEdBQUcsQ0FBQzRCLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3pELENBQUMsR0FDRCxFQUFFO0lBQUU7SUFDUjtNQUNFVyxLQUFLLEVBQUV2QyxHQUFHLENBQUN1QyxLQUFLLENBQUNDLFVBQVU7TUFDM0JDLEdBQUcsR0FBQXRCLFNBQUEsR0FBRW5CLEdBQUcsQ0FBQzBDLElBQUksY0FBQXZCLFNBQUEsdUJBQVJBLFNBQUEsQ0FBVXdCO0lBQ2pCLENBQUMsQ0FBQztJQUNKLENBQUM7RUFDSDs7RUFFQUMsbUJBQW1CQSxDQUFDNUMsR0FBMEIsRUFBVTtJQUN0RCxPQUFPQSxHQUFHLENBQUN3QixJQUFJO0VBQ2pCO0VBRUFLLG1CQUFtQkEsQ0FBQzdCLEdBQTBCLEVBQVU7SUFDdEQsT0FBT0EsR0FBRyxDQUFDd0IsSUFBSTtFQUNqQjtFQUVBUSxrQkFBa0JBLENBQUNoQyxHQUF5QixFQUFVO0lBQ3BELE9BQU9BLEdBQUcsQ0FBQ3dCLElBQUk7RUFDakI7RUFFQVcsaUJBQWlCQSxDQUFDbkMsR0FBd0IsRUFBVztJQUNuRCxPQUFPLElBQUk2Qyx5QkFBYSxDQUN0QixnQkFBZ0IsRUFDaEIsRUFBRSxFQUNGLElBQUksQ0FBQ0Msa0JBQWtCLENBQUM5QyxHQUFHLENBQUMrQyxhQUFhLENBQUMsQ0FBQyxDQUFDLEVBQzVDL0MsR0FBRyxDQUFDZ0QsaUJBQWlCLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQ0Msc0JBQXNCLENBQUNqRCxHQUFHLENBQUNnRCxpQkFBaUIsQ0FBQyxDQUFFLENBQUMsR0FBRyxFQUNwRixDQUFDO0VBQ0g7RUFFQUMsc0JBQXNCQSxDQUFDakQsR0FBNkIsRUFBVTtJQUM1RDtJQUNBLE9BQU9BLEdBQUcsQ0FBQ2tELGVBQWUsQ0FBQyxDQUFDLENBQUMxQixJQUFJO0VBQ25DO0VBRUFhLGtCQUFrQkEsQ0FBQ3JDLEdBQXlCLEVBQVc7SUFDckQsT0FBTyxJQUFJbUQsbUJBQU8sQ0FDaEIsaUJBQWlCLEVBQ2pCLEVBQUUsRUFDRm5ELEdBQUcsQ0FBQ29ELFNBQVMsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDQyxjQUFjLENBQUNyRCxHQUFHLENBQUNvRCxTQUFTLENBQUMsQ0FBRSxDQUFDLEdBQUcsRUFBRSxFQUM1RHBELEdBQUcsQ0FBQ3NELFlBQVksQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDQyxpQkFBaUIsQ0FBQ3ZELEdBQUcsQ0FBQ3NELFlBQVksQ0FBQyxDQUFFLENBQUMsR0FBRyxJQUFJLENBQUN6RCxhQUFhLENBQUMsQ0FDeEYsQ0FBQztFQUNIO0VBRUEwRCxpQkFBaUJBLENBQUN2RCxHQUF3QixFQUFXO0lBQ25ELE9BQU8sSUFBSXdELGdCQUFJLENBQ2IsYUFBYSxFQUNiLEVBQUUsRUFDRixJQUFJLENBQUNDLGVBQWUsQ0FBQ3pELEdBQUcsQ0FBQzBELFVBQVUsQ0FBQyxDQUFDLENBQUMsRUFDdEMxRCxHQUFHLENBQUMyRCxhQUFhLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQ0Msa0JBQWtCLENBQUM1RCxHQUFHLENBQUMyRCxhQUFhLENBQUMsQ0FBRSxDQUFDLEdBQUcsRUFDeEUsQ0FBQztFQUNIO0VBRUFGLGVBQWVBLENBQUN6RCxHQUFzQixFQUFXO0lBQy9DLE9BQU8sSUFBSTZELDBCQUFjLENBQ3ZCLGlCQUFpQixFQUNqQixFQUFFLEVBQ0YsSUFBSSxDQUFDQyxvQkFBb0IsQ0FBQzlELEdBQUcsQ0FBQytELGVBQWUsQ0FBQyxDQUFDLENBQUMsRUFDaEQsSUFBSSxDQUFDQyxpQkFBaUIsQ0FBQ2hFLEdBQUcsQ0FBQ2lFLFlBQVksQ0FBQyxDQUFDLENBQUMsRUFDMUNqRSxHQUFHLENBQUNrRSxZQUFZLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQ0MsaUJBQWlCLENBQUNuRSxHQUFHLENBQUNrRSxZQUFZLENBQUMsQ0FBRSxDQUFDLEdBQUcsRUFDckUsQ0FBQztFQUNIO0VBRUFGLGlCQUFpQkEsQ0FBQ2hFLEdBQXdCLEVBQVU7SUFDbEQsT0FBT0EsR0FBRyxDQUFDd0IsSUFBSTtFQUNqQjtFQUVBMkMsaUJBQWlCQSxDQUFDbkUsR0FBd0IsRUFBVTtJQUNsRCxPQUFPQSxHQUFHLENBQUN3QixJQUFJO0VBQ2pCO0VBRUFzQixrQkFBa0JBLENBQUM5QyxHQUF5QixFQUFXO0lBQ3JELElBQUlvRSxRQUFRLEdBQUcsRUFBRTtJQUNqQixJQUFJQyxTQUFTLEdBQUcsRUFBRTtJQUVsQixJQUFJLElBQUE5RCxrQkFBVSxFQUFDUCxHQUFHLENBQUNzRSxlQUFlLENBQUMsRUFBRTtNQUNuQ0QsU0FBUyxHQUFHLElBQUksQ0FBQ0Usb0JBQW9CLENBQUN2RSxHQUFHLENBQUNzRSxlQUFlLENBQUMsQ0FBQyxDQUFDO01BQzVELElBQUksSUFBQS9ELGtCQUFVLEVBQUNQLEdBQUcsQ0FBQ3dFLGlCQUFpQixDQUFDLEVBQUU7UUFDckNKLFFBQVEsR0FBRyxJQUFJLENBQUNLLHNCQUFzQixDQUFDekUsR0FBRyxDQUFDd0UsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO01BQ2pFLENBQUMsTUFBTTtRQUNMSixRQUFRLEdBQUdwRSxHQUFHLENBQUMwRSxjQUFjLENBQUMsQ0FBQyxHQUFHMUUsR0FBRyxDQUFDMEUsY0FBYyxDQUFDLENBQUMsQ0FBQ2xELElBQUksR0FBR3hCLEdBQUcsQ0FBQzJFLEVBQUUsQ0FBQyxDQUFDLENBQUNuRCxJQUFJO01BQzdFO0lBQ0YsQ0FBQyxNQUFNLElBQUksSUFBQWpCLGtCQUFVLEVBQUNQLEdBQUcsQ0FBQzRFLHFCQUFxQixDQUFDLEVBQUU7TUFDaEQ7SUFBQSxDQUNELE1BQU0sSUFBSSxJQUFBckUsa0JBQVUsRUFBQ1AsR0FBRyxDQUFDNkUsS0FBSyxDQUFDLEVBQUU7TUFDaENULFFBQVEsR0FBR3BFLEdBQUcsQ0FBQzZFLEtBQUssQ0FBQyxDQUFDLENBQUNyRCxJQUFJO0lBQzdCO0lBRUEsT0FBTyxJQUFJc0QsNkJBQWlCLENBQzFCLGdCQUFnQixFQUNoQixFQUFFLEVBQ0ZWLFFBQVEsRUFDUkMsU0FBUyxFQUNULElBQUE5RCxrQkFBVSxFQUFDUCxHQUFHLENBQUM0RSxxQkFBcUIsQ0FBQyxHQUFHNUUsR0FBRyxDQUFDd0IsSUFBSSxHQUFHLEVBQ3JELENBQUM7RUFDSDtFQUVBK0Msb0JBQW9CQSxDQUFDdkUsR0FBMkIsRUFBVTtJQUN4RCxPQUFPQSxHQUFHLENBQUN3QixJQUFJO0VBQ2pCO0VBRUFpRCxzQkFBc0JBLENBQUN6RSxHQUE2QixFQUFVO0lBQzVELE9BQU9BLEdBQUcsQ0FBQ3dCLElBQUk7RUFDakI7RUFFQTZCLGNBQWNBLENBQUNyRCxHQUFxQixFQUFrQjtJQUNwRCxPQUFPQSxHQUFHLENBQUMrRCxlQUFlLENBQUMsQ0FBQyxDQUFDMUQsR0FBRyxDQUFFMEUsb0JBQW9CLElBQUs7TUFDekQsT0FBTyxJQUFJQyxpQkFBSyxDQUNkLGtCQUFrQixFQUNsQixFQUFFLEVBQ0YsSUFBSSxDQUFDbEIsb0JBQW9CLENBQUNpQixvQkFBb0IsQ0FDaEQsQ0FBQztJQUNILENBQUMsQ0FBQztFQUNKO0VBRUFqQixvQkFBb0JBLENBQUM5RCxHQUEyQixFQUFVO0lBQ3hELE9BQU8sSUFBSSxDQUFDNEQsa0JBQWtCLENBQUM1RCxHQUFHLENBQUMyRCxhQUFhLENBQUMsQ0FBQyxDQUFDO0VBQ3JEO0VBRUFDLGtCQUFrQkEsQ0FBQzVELEdBQXlCLEVBQVU7SUFDcEQsT0FBT0EsR0FBRyxDQUFDd0IsSUFBSTtFQUNqQjtBQUNGO0FBQUN5RCxPQUFBLENBQUF0RixlQUFBLEdBQUFBLGVBQUEifQ==