"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLSyntaxParser = void 0;
var _antlr4ts = require("antlr4ts");
var _case_insensitive_char_stream = require("./adaptors/case_insensitive_char_stream");
var _OpenSearchPPLLexer = require("./output/OpenSearchPPLLexer");
var _OpenSearchPPLParser = require("./output/OpenSearchPPLParser");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * PPL Syntax Parser.
 */
class PPLSyntaxParser {
  /**
   * Analyze the query syntax.
   */

  parse(query) {
    return this.createParser(this.createLexer(query));
  }
  createLexer(query = '') {
    return new _OpenSearchPPLLexer.OpenSearchPPLLexer(new _case_insensitive_char_stream.CaseInsensitiveCharStream(_antlr4ts.CharStreams.fromString(query)));
  }
  createParser(lexer) {
    return new _OpenSearchPPLParser.OpenSearchPPLParser(new _antlr4ts.CommonTokenStream(lexer));
  }
}
exports.PPLSyntaxParser = PPLSyntaxParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfYW50bHI0dHMiLCJyZXF1aXJlIiwiX2Nhc2VfaW5zZW5zaXRpdmVfY2hhcl9zdHJlYW0iLCJfT3BlblNlYXJjaFBQTExleGVyIiwiX09wZW5TZWFyY2hQUExQYXJzZXIiLCJQUExTeW50YXhQYXJzZXIiLCJwYXJzZSIsInF1ZXJ5IiwiY3JlYXRlUGFyc2VyIiwiY3JlYXRlTGV4ZXIiLCJPcGVuU2VhcmNoUFBMTGV4ZXIiLCJDYXNlSW5zZW5zaXRpdmVDaGFyU3RyZWFtIiwiQ2hhclN0cmVhbXMiLCJmcm9tU3RyaW5nIiwibGV4ZXIiLCJPcGVuU2VhcmNoUFBMUGFyc2VyIiwiQ29tbW9uVG9rZW5TdHJlYW0iLCJleHBvcnRzIl0sInNvdXJjZXMiOlsicHBsX3N5bnRheF9wYXJzZXIudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgQ2hhclN0cmVhbXMsIENvbW1vblRva2VuU3RyZWFtIH0gZnJvbSAnYW50bHI0dHMnO1xyXG5pbXBvcnQgeyBDYXNlSW5zZW5zaXRpdmVDaGFyU3RyZWFtIH0gZnJvbSAnLi9hZGFwdG9ycy9jYXNlX2luc2Vuc2l0aXZlX2NoYXJfc3RyZWFtJztcclxuaW1wb3J0IHsgT3BlblNlYXJjaFBQTExleGVyIH0gZnJvbSAnLi9vdXRwdXQvT3BlblNlYXJjaFBQTExleGVyJztcclxuaW1wb3J0IHsgT3BlblNlYXJjaFBQTFBhcnNlciB9IGZyb20gJy4vb3V0cHV0L09wZW5TZWFyY2hQUExQYXJzZXInO1xyXG5cclxuLyoqXHJcbiAqIFBQTCBTeW50YXggUGFyc2VyLlxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFBQTFN5bnRheFBhcnNlciB7XHJcbiAgLyoqXHJcbiAgICogQW5hbHl6ZSB0aGUgcXVlcnkgc3ludGF4LlxyXG4gICAqL1xyXG5cclxuICBwYXJzZShxdWVyeTogc3RyaW5nKSB7XHJcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVQYXJzZXIodGhpcy5jcmVhdGVMZXhlcihxdWVyeSkpO1xyXG4gIH1cclxuXHJcbiAgY3JlYXRlTGV4ZXIocXVlcnk6IHN0cmluZyA9ICcnKSB7XHJcbiAgICByZXR1cm4gbmV3IE9wZW5TZWFyY2hQUExMZXhlcihuZXcgQ2FzZUluc2Vuc2l0aXZlQ2hhclN0cmVhbShDaGFyU3RyZWFtcy5mcm9tU3RyaW5nKHF1ZXJ5KSkpO1xyXG4gIH1cclxuXHJcbiAgY3JlYXRlUGFyc2VyKGxleGVyOiBPcGVuU2VhcmNoUFBMTGV4ZXIpIHtcclxuICAgIHJldHVybiBuZXcgT3BlblNlYXJjaFBQTFBhcnNlcihuZXcgQ29tbW9uVG9rZW5TdHJlYW0obGV4ZXIpKTtcclxuICB9XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFLQSxJQUFBQSxTQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyw2QkFBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsbUJBQUEsR0FBQUYsT0FBQTtBQUNBLElBQUFHLG9CQUFBLEdBQUFILE9BQUE7QUFSQTtBQUNBO0FBQ0E7QUFDQTs7QUFPQTtBQUNBO0FBQ0E7QUFDTyxNQUFNSSxlQUFlLENBQUM7RUFDM0I7QUFDRjtBQUNBOztFQUVFQyxLQUFLQSxDQUFDQyxLQUFhLEVBQUU7SUFDbkIsT0FBTyxJQUFJLENBQUNDLFlBQVksQ0FBQyxJQUFJLENBQUNDLFdBQVcsQ0FBQ0YsS0FBSyxDQUFDLENBQUM7RUFDbkQ7RUFFQUUsV0FBV0EsQ0FBQ0YsS0FBYSxHQUFHLEVBQUUsRUFBRTtJQUM5QixPQUFPLElBQUlHLHNDQUFrQixDQUFDLElBQUlDLHVEQUF5QixDQUFDQyxxQkFBVyxDQUFDQyxVQUFVLENBQUNOLEtBQUssQ0FBQyxDQUFDLENBQUM7RUFDN0Y7RUFFQUMsWUFBWUEsQ0FBQ00sS0FBeUIsRUFBRTtJQUN0QyxPQUFPLElBQUlDLHdDQUFtQixDQUFDLElBQUlDLDJCQUFpQixDQUFDRixLQUFLLENBQUMsQ0FBQztFQUM5RDtBQUNGO0FBQUNHLE9BQUEsQ0FBQVosZUFBQSxHQUFBQSxlQUFBIn0=