"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseInsensitiveCharStream = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class CaseInsensitiveCharStream {
  get index() {
    return this.stream.index;
  }
  get size() {
    return this.stream.size;
  }
  get sourceName() {
    return 'pplquery';
  }
  constructor(stream) {
    _defineProperty(this, "stream", void 0);
    this.stream = stream;
  }
  LA(offset) {
    const c = this.stream.LA(offset);
    if (c <= 0) {
      return c;
    }

    // case insensitivity support for PPL
    return String.fromCodePoint(c).toUpperCase().codePointAt(0);
  }
  consume() {
    this.stream.consume();
  }
  mark() {
    return this.stream.mark();
  }
  release(marker) {
    this.stream.release(marker);
  }
  seek(index) {
    this.stream.seek(index);
  }
  getText(interval) {
    return this.stream.getText(interval);
  }
  toString() {
    return this.stream.toString();
  }
}
exports.CaseInsensitiveCharStream = CaseInsensitiveCharStream;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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