"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TITLES = exports.TRACE_TABLE_OPTIONS = exports.TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACES_MAX_NUM = exports.JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_INDEX_NAME = exports.DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const JAEGER_INDEX_NAME = exports.JAEGER_INDEX_NAME = '*jaeger-span-*';
const JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_SERVICE_INDEX_NAME = '*jaeger-service*';
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'otel-v1-apm-span-*,opensearch_dashboards_sample_data_otel_spans*';
const DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = 'otel-v1-apm-service-map*,opensearch_dashboards_sample_data_otel_service_map*';
const TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATE_FORMAT = 'MM/DD/YYYY HH:mm:ss.SSS';
const TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = 'MMM D, YYYY HH:mm:ss.SSS';
const TRACES_MAX_NUM = exports.TRACES_MAX_NUM = 500;
const TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = 'https://opensearch.org/docs/latest/observability-plugin/trace/index/';
const TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = '/api/observability/trace_analytics/jaeger_indices';
const TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/trace_analytics/data_prepper_indices';
const TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = '/api/observability/trace_analytics/query';
const TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = 'observability:traceAnalyticsSpanIndices';
const TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = 'observability:traceAnalyticsServiceIndices';
const TRACE_CUSTOM_MODE_DEFAULT_SETTING = exports.TRACE_CUSTOM_MODE_DEFAULT_SETTING = 'observability:traceAnalyticsCustomModeDefault';
const TRACE_CORRELATED_LOGS_INDEX_SETTING = exports.TRACE_CORRELATED_LOGS_INDEX_SETTING = 'observability:traceAnalyticsCorrelatedLogsIndices';
const TRACE_LOGS_FIELD_MAPPNIGS_SETTING = exports.TRACE_LOGS_FIELD_MAPPNIGS_SETTING = 'observability:traceAnalyticsCorrelatedLogsFieldMappings';
const TRACE_SERVICE_MAP_MAX_NODES = exports.TRACE_SERVICE_MAP_MAX_NODES = 'observability:traceAnalyticsServiceMapMaxNodes';
const TRACE_SERVICE_MAP_MAX_EDGES = exports.TRACE_SERVICE_MAP_MAX_EDGES = 'observability:traceAnalyticsServiceMapMaxEdges';
const DEFAULT_SS4O_LOGS_INDEX = exports.DEFAULT_SS4O_LOGS_INDEX = 'ss4o_logs-*,opensearch_dashboards_sample_data_otel_logs*';
const DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = exports.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS = `
{
  "serviceName": "serviceName",
  "spanId": "spanId",
  "timestamp": "time",
  "traceId": "traceId"
}`;
const DEFAULT_SERVICE_MAP_MAX_NODES = exports.DEFAULT_SERVICE_MAP_MAX_NODES = 500;
const DEFAULT_SERVICE_MAP_MAX_EDGES = exports.DEFAULT_SERVICE_MAP_MAX_EDGES = 1000;
let TRACE_TABLE_TITLES = exports.TRACE_TABLE_TITLES = /*#__PURE__*/function (TRACE_TABLE_TITLES) {
  TRACE_TABLE_TITLES["all_spans"] = "All Spans";
  TRACE_TABLE_TITLES["root_spans"] = "Root Spans";
  TRACE_TABLE_TITLES["entry_spans"] = "Service Entry Spans";
  TRACE_TABLE_TITLES["traces"] = "Traces";
  return TRACE_TABLE_TITLES;
}({});
const getDescription = key => {
  const descriptions = {
    all_spans: 'Spans representing all activities in all traces across the system',
    root_spans: 'Spans marking the root or starting point of each trace',
    entry_spans: 'Spans that indicate the entry point of service-side processing',
    traces: 'Spans grouped by traceId to show a complete trace lifecycle'
  };
  return descriptions[key];
};
const TRACE_TABLE_OPTIONS = exports.TRACE_TABLE_OPTIONS = Object.entries(TRACE_TABLE_TITLES).map(([key, label]) => ({
  label,
  key,
  'aria-describedby': getDescription(key)
}));
const TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TYPE_KEY = 'TraceAnalyticsTraceTableType';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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