"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityGettingStartedTitle = exports.observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.discoverPluginID = exports.dataSourceManagementPluginId = exports.anomalyDetectionPluginID = exports.alertingPluginID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATA_SOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OTEL_METRIC_SUBTYPE = exports.OTEL_DATE_FORMAT = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_FIELD_CAPS = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.tutorialSampleDataPluginId = exports.queryWorkbenchPluginID = exports.queryWorkbenchPluginCheck = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesNewNavURL = exports.observabilityTracesNewNavID = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityServicesTitle = exports.observabilityServicesPluginOrder = exports.observabilityServicesNewNavURL = exports.observabilityServicesNewNavID = exports.observabilityServicesID = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityOverviewTitleWithUseCase = exports.observabilityOverviewTitle = exports.observabilityOverviewPluginOrder = exports.observabilityOverviewID = exports.observabilityNotebookTitle = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const DSL_FIELD_CAPS = exports.DSL_FIELD_CAPS = '/fieldCaps';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const tutorialSampleDataPluginId = exports.tutorialSampleDataPluginId = 'import_sample_data';
const dataSourceManagementPluginId = exports.dataSourceManagementPluginId = 'dataSources';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityOverviewID = exports.observabilityOverviewID = 'observability-overview';
const observabilityOverviewTitle = exports.observabilityOverviewTitle = 'Overview';
const observabilityOverviewTitleWithUseCase = exports.observabilityOverviewTitleWithUseCase = 'Observability overview';
const observabilityOverviewPluginOrder = exports.observabilityOverviewPluginOrder = 5088;
const observabilityGettingStartedID = exports.observabilityGettingStartedID = 'observability-gettingStarted';
const observabilityGettingStartedTitle = exports.observabilityGettingStartedTitle = 'Get started';
const observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedPluginOrder = 5089;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesNewNavID = exports.observabilityTracesNewNavID = 'observability-traces-nav';
const observabilityTracesNewNavURL = exports.observabilityTracesNewNavURL = observabilityTracesNewNavID;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityServicesNewNavID = exports.observabilityServicesNewNavID = 'observability-services-nav';
const observabilityServicesNewNavURL = exports.observabilityServicesNewNavURL = observabilityServicesNewNavID;
const observabilityServicesID = exports.observabilityServicesID = 'observability-services';
const observabilityServicesTitle = exports.observabilityServicesTitle = 'Services';
const observabilityServicesPluginOrder = exports.observabilityServicesPluginOrder = 5092;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';
const alertingPluginID = exports.alertingPluginID = 'alerting';
const anomalyDetectionPluginID = exports.anomalyDetectionPluginID = 'anomaly-detection-dashboards';
const discoverPluginID = exports.discoverPluginID = 'data-explorer/discover';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const OTEL_DATE_FORMAT = exports.OTEL_DATE_FORMAT = 'YYYY-MM-DDTHH:mm:ss';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const OTEL_METRIC_SUBTYPE = exports.OTEL_METRIC_SUBTYPE = 'openTelemetryMetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;
const PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DESCRIBE_INDEX_REGEX = /(describe)\s+([^|\s]+)/i;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  VIS_CHART_TYPES["Histogram"] = "histogram";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines+markers',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 25,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: -45,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATA_SOURCE_TYPE = exports.S3_DATA_SOURCE_TYPE = 's3glue';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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