"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeppelinURL = exports.wreckOptions = exports.OPENSEARCH_NOTEBOOKS_API = exports.NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_API_PREFIX = exports.CREATE_NOTE_MESSAGE = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const NOTEBOOKS_API_PREFIX = exports.NOTEBOOKS_API_PREFIX = '/api/observability/notebooks';
const NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_FETCH_SIZE = 1000;
const CREATE_NOTE_MESSAGE = exports.CREATE_NOTE_MESSAGE = 'Enter a name to describe the purpose of this notebook.';
const NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/notebooks/';
const zeppelinURL = exports.zeppelinURL = 'http://localhost:8080';
const wreckOptions = exports.wreckOptions = {
  baseUrl: zeppelinURL,
  headers: {
    'Content-Type': 'application/json'
  }
};
const BASE_NOTEBOOKS_URI = '/_plugins/_notebooks';
const OPENSEARCH_NOTEBOOKS_API = exports.OPENSEARCH_NOTEBOOKS_API = {
  GET_NOTEBOOKS: `${BASE_NOTEBOOKS_URI}/notebooks`,
  NOTEBOOK: `${BASE_NOTEBOOKS_URI}/notebook`
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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