"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolutionOptions = exports.VISUALIZATION = exports.SPAN_RESOLUTION_REGEX = exports.SAVED_VISUALIZATION = exports.REDUX_SLICE_METRICS = exports.PPL_DATASOURCES_REQUEST = exports.OPEN_TELEMETRY = exports.OBSERVABILITY_CUSTOM_METRIC = exports.METRIC_EXPLORER_BASE_PATH = exports.METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.INDEX_DOCUMENT_NAME_PATTERN = exports.DATA_PREPPER_INDEX_NAME = exports.DATASOURCE_OPTIONS = exports.AGGREGATION_OPTIONS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const METRIC_EXPLORER_BASE_PATH = exports.METRIC_EXPLORER_BASE_PATH = 'observability-metrics#/';

// requests constants
const VISUALIZATION = exports.VISUALIZATION = 'viz';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = 'savedVisualization';
const PPL_DATASOURCES_REQUEST = exports.PPL_DATASOURCES_REQUEST = 'show datasources | where CONNECTOR_TYPE="PROMETHEUS" | fields DATASOURCE_NAME';

// redux

const OBSERVABILITY_CUSTOM_METRIC = exports.OBSERVABILITY_CUSTOM_METRIC = 'CUSTOM_METRICS';
const OPEN_TELEMETRY = exports.OPEN_TELEMETRY = 'OpenTelemetry';
const REDUX_SLICE_METRICS = exports.REDUX_SLICE_METRICS = 'metrics';
const resolutionOptions = exports.resolutionOptions = [{
  value: 's',
  text: 'seconds'
}, {
  value: 'm',
  text: 'minutes'
}, {
  value: 'h',
  text: 'hours'
}, {
  value: 'd',
  text: 'days'
},
// { value: 'M', text: 'Months' }, // commenting it here as prometheus doesn't have support
// { value: 'q', text: 'quarters' },
{
  value: 'y',
  text: 'years'
}];
const AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = [{
  value: 'avg',
  text: 'avg()'
}, {
  value: 'sum',
  text: 'sum()'
}, {
  value: 'count',
  text: 'count()'
}, {
  value: 'min',
  text: 'min()'
}, {
  value: 'max',
  text: 'max()'
}];
const DATASOURCE_OPTIONS = exports.DATASOURCE_OPTIONS = [{
  label: 'Prometheus',
  'data-test-subj': 'prometheusOption'
}, {
  label: 'OpenTelemetry',
  'data-test-subj': 'openTelemetryOption'
}];
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'ss4o_metrics-*-*';
const METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/metrics_analytics/data_prepper_indices';

// Regex pattens
const INDEX_DOCUMENT_NAME_PATTERN = exports.INDEX_DOCUMENT_NAME_PATTERN = /\[Otel Metric\]\s(\S+?-\S+?)\.(\S+)/;
const SPAN_RESOLUTION_REGEX = exports.SPAN_RESOLUTION_REGEX = /'(\d+)([smhdwMy])'/;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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