"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.OLLY_QUERY_ASSISTANT = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.LOG_EXPLORER_BASE_PATH = exports.JAEGER_TRACE_ID = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_TIMESTAMP_COLUMN = exports.DEFAULT_SOURCE_COLUMN = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_EMPTY_EXPLORER_FIELDS = exports.DEFAULT_DATETIME_STRING = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATE_DISPLAY_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;
exports.sampleLogPatternData = exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = exports.TYPE_TAB_MAPPING = void 0;
var _eui = require("@elastic/eui");
var _shared = require("./shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// URLs
const EVENT_ANALYTICS_DOCUMENTATION_URL = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observing-your-data/event-analytics/';
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
const LOG_EXPLORER_BASE_PATH = exports.LOG_EXPLORER_BASE_PATH = 'observability-logs#/explorer/';
const RAW_QUERY = exports.RAW_QUERY = 'rawQuery';
const FINAL_QUERY = exports.FINAL_QUERY = 'finalQuery';
const SELECTED_DATE_RANGE = exports.SELECTED_DATE_RANGE = 'selectedDateRange';
const INDEX = exports.INDEX = 'index';
const OLLY_QUERY_ASSISTANT = exports.OLLY_QUERY_ASSISTANT = 'ollyQueryAssistant';
const SELECTED_PATTERN_FIELD = exports.SELECTED_PATTERN_FIELD = 'selectedPatternField';
const PATTERN_REGEX = exports.PATTERN_REGEX = 'patternRegex';
const FILTERED_PATTERN = exports.FILTERED_PATTERN = 'filteredPattern';
const SELECTED_TIMESTAMP = exports.SELECTED_TIMESTAMP = 'selectedTimestamp';
const SELECTED_FIELDS = exports.SELECTED_FIELDS = 'selectedFields';
const UNSELECTED_FIELDS = exports.UNSELECTED_FIELDS = 'unselectedFields';
const AVAILABLE_FIELDS = exports.AVAILABLE_FIELDS = 'availableFields';
const QUERIED_FIELDS = exports.QUERIED_FIELDS = 'queriedFields';
const TAB_ID_TXT_PFX = exports.TAB_ID_TXT_PFX = 'explorer-tab-';
const TAB_TITLE = exports.TAB_TITLE = 'New query';
const TAB_CHART_TITLE = exports.TAB_CHART_TITLE = 'Visualizations';
const TAB_EVENT_TITLE = exports.TAB_EVENT_TITLE = 'Events';
const TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
const TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
const TAB_EVENT_ID = exports.TAB_EVENT_ID = 'main-content-events';
const TAB_CHART_ID = exports.TAB_CHART_ID = 'main-content-vis';
const CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM_KEY = 'create';
const CREATE_TAB_PARAM = exports.CREATE_TAB_PARAM = {
  [TAB_EVENT_ID]: 'events',
  [TAB_CHART_ID]: 'visualizations'
};
const HAS_SAVED_TIMESTAMP = exports.HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
const FILTER_OPTIONS = exports.FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
const SAVED_QUERY = exports.SAVED_QUERY = 'savedQuery';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = 'savedVisualization';
const SAVED_OBJECT_ID = exports.SAVED_OBJECT_ID = 'savedObjectId';
const SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_TYPE = 'objectType';
const TAB_CREATED_TYPE = exports.TAB_CREATED_TYPE = 'tabCreatedType';
const NEW_TAB = exports.NEW_TAB = 'newTab';
const REDIRECT_TAB = exports.REDIRECT_TAB = 'redirect_tab';
const PAGE_SIZE = exports.PAGE_SIZE = 50;
const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = ['', 'Time', '_source'];
const OTEL_TRACE_ID = exports.OTEL_TRACE_ID = 'traceId';
const JAEGER_TRACE_ID = exports.JAEGER_TRACE_ID = 'traceID';
const DATE_PICKER_FORMAT = exports.DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
const DATE_DISPLAY_FORMAT = exports.DATE_DISPLAY_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
const DEFAULT_DATETIME_STRING = exports.DEFAULT_DATETIME_STRING = 'now';
const TIME_INTERVAL_OPTIONS = exports.TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}];

// redux
const SELECTED_QUERY_TAB = exports.SELECTED_QUERY_TAB = 'selectedQueryTab';
const QUERY_TAB_IDS = exports.QUERY_TAB_IDS = 'queryTabIds';
const NEW_SELECTED_QUERY_TAB = exports.NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
const REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_QUERIES = 'queries';
const REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
const REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_FIELDS = 'fields';
const REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
const REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
const REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_PATTERNS = 'patterns';
const REDUX_EXPL_SLICE_SEARCH_META_DATA = exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = 'searchMetaData';
const PLOTLY_GAUGE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = 4;
const APP_ANALYTICS_TAB_ID_REGEX = exports.APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
const DEFAULT_AVAILABILITY_QUERY = exports.DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
const PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]';
// Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table
const PATTERNS_REGEX = exports.PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/;
// Used to extract the initial pattern applied
const PATTERNS_EXTRACTOR_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
const ADD_BUTTON_TEXT = exports.ADD_BUTTON_TEXT = '+ Add color theme';
const NUMBER_INPUT_MIN_LIMIT = exports.NUMBER_INPUT_MIN_LIMIT = 1;
const VIZ_CONTAIN_XY_AXIS = exports.VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar];

// default ppl aggregation method options
const AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}];

// numeric fields type for metrics
const NUMERICAL_TYPES = exports.NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer'];
// Data table constants
const GRID_HEADER_COLUMN_MAX_WIDTH = exports.GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
const GRID_PAGE_RANGE_DISPLAY = exports.GRID_PAGE_RANGE_DISPLAY = 5;
const COLUMN_DEFAULT_MIN_WIDTH = exports.COLUMN_DEFAULT_MIN_WIDTH = 100;
const GRID_PAGE_SIZES = exports.GRID_PAGE_SIZES = [10, 50, 100];
const ROW_DENSITIES = exports.ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
const HEADER_HEIGHT = exports.HEADER_HEIGHT = 35;

// gauge chart default parameters

const DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
};

// pie chart default parameters
const PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_PIE_COLUMN_NUMBER = 2;
const PIE_XAXIS_GAP = exports.PIE_XAXIS_GAP = 0.2;
const PIE_YAXIS_GAP = exports.PIE_YAXIS_GAP = 0.1;
const DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
const GROUPBY = exports.GROUPBY = 'dimensions';
const AGGREGATIONS = exports.AGGREGATIONS = 'series';
const PARENTFIELDS = exports.PARENTFIELDS = 'parentFields';
const VALUEFIELD = exports.VALUEFIELD = 'valueField';
const CHILDFIELD = exports.CHILDFIELD = 'childField';
const TIMESTAMP = exports.TIMESTAMP = 'timestamp';

// metrics constants
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
const METRICS_AXIS_MARGIN = exports.METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
const METRICS_ANNOTATION = exports.METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
const DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
const DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
const SIMILAR_VIZ_TYPES = exports.SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
let ConfigChartOptionsEnum = exports.ConfigChartOptionsEnum = /*#__PURE__*/function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
  return ConfigChartOptionsEnum;
}({});
const CUSTOM_LABEL = exports.CUSTOM_LABEL = 'customLabel';
const BREAKDOWNS = exports.BREAKDOWNS = 'breakdowns';
const SPAN = exports.SPAN = 'span';
const TIME_FIELD = exports.TIME_FIELD = 'time_field';
const DISABLED_COLOUR = exports.DISABLED_COLOUR = '#fafbfd';
const DATA_CONFIG_HINTS_INFO = exports.DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
};

// Metrics constants
const UNITS_OF_MEASURE = exports.UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
const sampleLogPatternData = exports.sampleLogPatternData = {
  count: 5,
  pattern: '[a-zA-Zd]',
  sampleLog: '218.148.135.12 - - [2018-07-22T04:18:12.345Z] "GET /beats/filebeat/filebeat-6.3.2-linux-x86_64.tar.gz_1 HTTP/1.1" 200 4531 "-" \
           "Mozilla/5.0 (X11; Linux x86_64; rv:6.0a1) Gecko/20110421 Firefox/6.0a1"',
  anomalyCount: 0
};
const TYPE_TAB_MAPPING = exports.TYPE_TAB_MAPPING = {
  [SAVED_QUERY]: TAB_EVENT_ID,
  [SAVED_VISUALIZATION]: TAB_CHART_ID
};
const DEFAULT_EMPTY_EXPLORER_FIELDS = exports.DEFAULT_EMPTY_EXPLORER_FIELDS = [
// timestamp field will be a default but is added after finding what it is
{
  name: '_source',
  type: 'string'
}];
const DEFAULT_TIMESTAMP_COLUMN = exports.DEFAULT_TIMESTAMP_COLUMN = {
  id: 'timestamp',
  isSortable: true,
  display: 'Time',
  schema: 'datetime',
  initialWidth: 200
};
const DEFAULT_SOURCE_COLUMN = exports.DEFAULT_SOURCE_COLUMN = {
  id: '_source',
  isSortable: false,
  display: 'Source',
  schema: '_source'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfZXVpIiwicmVxdWlyZSIsIl9zaGFyZWQiLCJFVkVOVF9BTkFMWVRJQ1NfRE9DVU1FTlRBVElPTl9VUkwiLCJleHBvcnRzIiwiT1BFTl9URUxFTUVUUllfTE9HX0NPUlJFTEFUSU9OX0xJTksiLCJMT0dfRVhQTE9SRVJfQkFTRV9QQVRIIiwiUkFXX1FVRVJZIiwiRklOQUxfUVVFUlkiLCJTRUxFQ1RFRF9EQVRFX1JBTkdFIiwiSU5ERVgiLCJPTExZX1FVRVJZX0FTU0lTVEFOVCIsIlNFTEVDVEVEX1BBVFRFUk5fRklFTEQiLCJQQVRURVJOX1JFR0VYIiwiRklMVEVSRURfUEFUVEVSTiIsIlNFTEVDVEVEX1RJTUVTVEFNUCIsIlNFTEVDVEVEX0ZJRUxEUyIsIlVOU0VMRUNURURfRklFTERTIiwiQVZBSUxBQkxFX0ZJRUxEUyIsIlFVRVJJRURfRklFTERTIiwiVEFCX0lEX1RYVF9QRlgiLCJUQUJfVElUTEUiLCJUQUJfQ0hBUlRfVElUTEUiLCJUQUJfRVZFTlRfVElUTEUiLCJUQUJfRVZFTlRfSURfVFhUX1BGWCIsIlRBQl9DSEFSVF9JRF9UWFRfUEZYIiwiVEFCX0VWRU5UX0lEIiwiVEFCX0NIQVJUX0lEIiwiQ1JFQVRFX1RBQl9QQVJBTV9LRVkiLCJDUkVBVEVfVEFCX1BBUkFNIiwiSEFTX1NBVkVEX1RJTUVTVEFNUCIsIkZJTFRFUl9PUFRJT05TIiwiU0FWRURfUVVFUlkiLCJTQVZFRF9WSVNVQUxJWkFUSU9OIiwiU0FWRURfT0JKRUNUX0lEIiwiU0FWRURfT0JKRUNUX1RZUEUiLCJUQUJfQ1JFQVRFRF9UWVBFIiwiTkVXX1RBQiIsIlJFRElSRUNUX1RBQiIsIlBBR0VfU0laRSIsIkRFRkFVTFRfQ09MVU1OUyIsIk9URUxfVFJBQ0VfSUQiLCJKQUVHRVJfVFJBQ0VfSUQiLCJEQVRFX1BJQ0tFUl9GT1JNQVQiLCJEQVRFX0RJU1BMQVlfRk9STUFUIiwiREVGQVVMVF9EQVRFVElNRV9TVFJJTkciLCJUSU1FX0lOVEVSVkFMX09QVElPTlMiLCJ0ZXh0IiwidmFsdWUiLCJTRUxFQ1RFRF9RVUVSWV9UQUIiLCJRVUVSWV9UQUJfSURTIiwiTkVXX1NFTEVDVEVEX1FVRVJZX1RBQiIsIlJFRFVYX0VYUExfU0xJQ0VfUVVFUklFUyIsIlJFRFVYX0VYUExfU0xJQ0VfUVVFUllfUkVTVUxUIiwiUkVEVVhfRVhQTF9TTElDRV9GSUVMRFMiLCJSRURVWF9FWFBMX1NMSUNFX1FVRVJZX1RBQlMiLCJSRURVWF9FWFBMX1NMSUNFX1ZJU1VBTElaQVRJT04iLCJSRURVWF9FWFBMX1NMSUNFX0NPVU5UX0RJU1RSSUJVVElPTiIsIlJFRFVYX0VYUExfU0xJQ0VfUEFUVEVSTlMiLCJSRURVWF9FWFBMX1NMSUNFX1NFQVJDSF9NRVRBX0RBVEEiLCJQTE9UTFlfR0FVR0VfQ09MVU1OX05VTUJFUiIsIkFQUF9BTkFMWVRJQ1NfVEFCX0lEX1JFR0VYIiwiREVGQVVMVF9BVkFJTEFCSUxJVFlfUVVFUlkiLCJQUExfREVGQVVMVF9QQVRURVJOX1JFR0VYX0ZJTEVURVIiLCJQQVRURVJOU19SRUdFWCIsIlBBVFRFUk5TX0VYVFJBQ1RPUl9SRUdFWCIsIkFERF9CVVRUT05fVEVYVCIsIk5VTUJFUl9JTlBVVF9NSU5fTElNSVQiLCJWSVpfQ09OVEFJTl9YWV9BWElTIiwiVklTX0NIQVJUX1RZUEVTIiwiQmFyIiwiSGlzdG9ncmFtIiwiTGluZSIsIlBpZSIsIlNjYXR0ZXIiLCJIb3Jpem9udGFsQmFyIiwiQUdHUkVHQVRJT05fT1BUSU9OUyIsImxhYmVsIiwiTlVNRVJJQ0FMX1RZUEVTIiwiR1JJRF9IRUFERVJfQ09MVU1OX01BWF9XSURUSCIsIkdSSURfUEFHRV9SQU5HRV9ESVNQTEFZIiwiQ09MVU1OX0RFRkFVTFRfTUlOX1dJRFRIIiwiR1JJRF9QQUdFX1NJWkVTIiwiUk9XX0RFTlNJVElFUyIsImljb24iLCJoZWlnaHQiLCJzZWxlY3RlZCIsIkhFQURFUl9IRUlHSFQiLCJERUZBVUxUX0dBVUdFX0NIQVJUX1BBUkFNRVRFUlMiLCJHYXVnZVRpdGxlU2l6ZSIsIkRpc3BsYXlEZWZhdWx0R2F1Z2VzIiwiT3JpZW50YXRpb25EZWZhdWx0IiwiVGlja0xlbmd0aCIsIkxlZ2VuZFBsYWNlbWVudCIsIlRocmVzaG9sZHNNYXhMaW1pdCIsIlBMT1RMWV9QSUVfQ09MVU1OX05VTUJFUiIsIlBJRV9YQVhJU19HQVAiLCJQSUVfWUFYSVNfR0FQIiwiREVGQVVMVF9QSUVfQ0hBUlRfUEFSQU1FVEVSUyIsIkRlZmF1bHRNb2RlIiwiR1JPVVBCWSIsIkFHR1JFR0FUSU9OUyIsIlBBUkVOVEZJRUxEUyIsIlZBTFVFRklFTEQiLCJDSElMREZJRUxEIiwiVElNRVNUQU1QIiwiTUVUUklDU19HUklEX1NQQUNFX0JFVFdFRU5fWF9BWElTIiwiTUVUUklDU19HUklEX1NQQUNFX0JFVFdFRU5fWV9BWElTIiwiTUVUUklDU19SRURVQ0VfVkFMVUVfU0laRV9QRVJDRU5UQUdFIiwiTUVUUklDU19SRURVQ0VfVElUTEVfU0laRV9QRVJDRU5UQUdFIiwiTUVUUklDU19SRURVQ0VfU0VSSUVTX1VOSVRfU0laRV9QRVJDRU5UQUdFIiwiTUVUUklDU19TRVJJRVNfVU5JVF9TVUJTVFJJTkdfTEVOR1RIIiwiTUVUUklDU19BWElTX01BUkdJTiIsImwiLCJyIiwiYiIsInQiLCJNRVRSSUNTX0FOTk9UQVRJT04iLCJ4cmVmIiwieXJlZiIsInNob3dhcnJvdyIsIkRFRkFVTFRfTUVUUklDU19DSEFSVF9QQVJBTUVURVJTIiwiRGVmYXVsdFRleHRNb2RlIiwiRGVmYXVsdE9yaWVudGF0aW9uIiwiRGVmYXVsdFRpdGxlU2l6ZSIsIkRlZmF1bHRWYWx1ZVNpemUiLCJEZWZhdWx0Q2hhcnRUeXBlIiwiVGV4dEFsaWdubWVudCIsIkRlZmF1bHRQcmVjaXNpb24iLCJCYXNlVGhyZXNob2xkIiwidGhpZCIsImh0bWxJZEdlbmVyYXRvciIsIm5hbWUiLCJjb2xvciIsImlzUmVhZE9ubHkiLCJEZWZhdWx0VGV4dENvbG9yIiwiREVGQVVMVF9CQVJfQ0hBUlRfU1RZTEVTIiwiQmFyTW9kZSIsIkdyb3VwV2lkdGgiLCJCYXJXaWR0aCIsIkxhYmVsU2l6ZSIsIlNJTUlMQVJfVklaX1RZUEVTIiwiQ29uZmlnQ2hhcnRPcHRpb25zRW51bSIsIkNVU1RPTV9MQUJFTCIsIkJSRUFLRE9XTlMiLCJTUEFOIiwiVElNRV9GSUVMRCIsIkRJU0FCTEVEX0NPTE9VUiIsIkRBVEFfQ09ORklHX0hJTlRTX0lORk8iLCJVTklUU19PRl9NRUFTVVJFIiwic2FtcGxlTG9nUGF0dGVybkRhdGEiLCJjb3VudCIsInBhdHRlcm4iLCJzYW1wbGVMb2ciLCJhbm9tYWx5Q291bnQiLCJUWVBFX1RBQl9NQVBQSU5HIiwiREVGQVVMVF9FTVBUWV9FWFBMT1JFUl9GSUVMRFMiLCJ0eXBlIiwiREVGQVVMVF9USU1FU1RBTVBfQ09MVU1OIiwiaWQiLCJpc1NvcnRhYmxlIiwiZGlzcGxheSIsInNjaGVtYSIsImluaXRpYWxXaWR0aCIsIkRFRkFVTFRfU09VUkNFX0NPTFVNTiJdLCJzb3VyY2VzIjpbImV4cGxvcmVyLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXHJcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xyXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxyXG4gKi9cclxuXHJcbmltcG9ydCB7IGh0bWxJZEdlbmVyYXRvciB9IGZyb20gJ0BlbGFzdGljL2V1aSc7XHJcbmltcG9ydCB7IFRocmVzaG9sZFVuaXRUeXBlIH0gZnJvbSAnLi4vLi4vcHVibGljL2NvbXBvbmVudHMvZXZlbnRfYW5hbHl0aWNzL2V4cGxvcmVyL3Zpc3VhbGl6YXRpb25zL2NvbmZpZ19wYW5lbC9jb25maWdfcGFuZXMvY29uZmlnX2NvbnRyb2xzL2NvbmZpZ190aHJlc2hvbGRzJztcclxuaW1wb3J0IHsgVklTX0NIQVJUX1RZUEVTIH0gZnJvbSAnLi9zaGFyZWQnO1xyXG5cclxuLy8gVVJMc1xyXG5leHBvcnQgY29uc3QgRVZFTlRfQU5BTFlUSUNTX0RPQ1VNRU5UQVRJT05fVVJMID1cclxuICAnaHR0cHM6Ly9vcGVuc2VhcmNoLm9yZy9kb2NzL2xhdGVzdC9vYnNlcnZpbmcteW91ci1kYXRhL2V2ZW50LWFuYWx5dGljcy8nO1xyXG5leHBvcnQgY29uc3QgT1BFTl9URUxFTUVUUllfTE9HX0NPUlJFTEFUSU9OX0xJTksgPVxyXG4gICdodHRwczovL29wZW50ZWxlbWV0cnkuaW8vZG9jcy9yZWZlcmVuY2Uvc3BlY2lmaWNhdGlvbi9sb2dzL292ZXJ2aWV3LyNsb2ctY29ycmVsYXRpb24nO1xyXG5leHBvcnQgY29uc3QgTE9HX0VYUExPUkVSX0JBU0VfUEFUSCA9ICdvYnNlcnZhYmlsaXR5LWxvZ3MjL2V4cGxvcmVyLyc7XHJcblxyXG5leHBvcnQgY29uc3QgUkFXX1FVRVJZID0gJ3Jhd1F1ZXJ5JztcclxuZXhwb3J0IGNvbnN0IEZJTkFMX1FVRVJZID0gJ2ZpbmFsUXVlcnknO1xyXG5leHBvcnQgY29uc3QgU0VMRUNURURfREFURV9SQU5HRSA9ICdzZWxlY3RlZERhdGVSYW5nZSc7XHJcbmV4cG9ydCBjb25zdCBJTkRFWCA9ICdpbmRleCc7XHJcbmV4cG9ydCBjb25zdCBPTExZX1FVRVJZX0FTU0lTVEFOVCA9ICdvbGx5UXVlcnlBc3Npc3RhbnQnO1xyXG5leHBvcnQgY29uc3QgU0VMRUNURURfUEFUVEVSTl9GSUVMRCA9ICdzZWxlY3RlZFBhdHRlcm5GaWVsZCc7XHJcbmV4cG9ydCBjb25zdCBQQVRURVJOX1JFR0VYID0gJ3BhdHRlcm5SZWdleCc7XHJcbmV4cG9ydCBjb25zdCBGSUxURVJFRF9QQVRURVJOID0gJ2ZpbHRlcmVkUGF0dGVybic7XHJcbmV4cG9ydCBjb25zdCBTRUxFQ1RFRF9USU1FU1RBTVAgPSAnc2VsZWN0ZWRUaW1lc3RhbXAnO1xyXG5leHBvcnQgY29uc3QgU0VMRUNURURfRklFTERTID0gJ3NlbGVjdGVkRmllbGRzJztcclxuZXhwb3J0IGNvbnN0IFVOU0VMRUNURURfRklFTERTID0gJ3Vuc2VsZWN0ZWRGaWVsZHMnO1xyXG5leHBvcnQgY29uc3QgQVZBSUxBQkxFX0ZJRUxEUyA9ICdhdmFpbGFibGVGaWVsZHMnO1xyXG5leHBvcnQgY29uc3QgUVVFUklFRF9GSUVMRFMgPSAncXVlcmllZEZpZWxkcyc7XHJcbmV4cG9ydCBjb25zdCBUQUJfSURfVFhUX1BGWCA9ICdleHBsb3Jlci10YWItJztcclxuZXhwb3J0IGNvbnN0IFRBQl9USVRMRSA9ICdOZXcgcXVlcnknO1xyXG5leHBvcnQgY29uc3QgVEFCX0NIQVJUX1RJVExFID0gJ1Zpc3VhbGl6YXRpb25zJztcclxuZXhwb3J0IGNvbnN0IFRBQl9FVkVOVF9USVRMRSA9ICdFdmVudHMnO1xyXG5leHBvcnQgY29uc3QgVEFCX0VWRU5UX0lEX1RYVF9QRlggPSAnbWFpbi1jb250ZW50LWV2ZW50cy0nO1xyXG5leHBvcnQgY29uc3QgVEFCX0NIQVJUX0lEX1RYVF9QRlggPSAnbWFpbi1jb250ZW50LXZpcy0nO1xyXG5leHBvcnQgY29uc3QgVEFCX0VWRU5UX0lEID0gJ21haW4tY29udGVudC1ldmVudHMnO1xyXG5leHBvcnQgY29uc3QgVEFCX0NIQVJUX0lEID0gJ21haW4tY29udGVudC12aXMnO1xyXG5leHBvcnQgY29uc3QgQ1JFQVRFX1RBQl9QQVJBTV9LRVkgPSAnY3JlYXRlJztcclxuZXhwb3J0IGNvbnN0IENSRUFURV9UQUJfUEFSQU0gPSB7XHJcbiAgW1RBQl9FVkVOVF9JRF06ICdldmVudHMnLFxyXG4gIFtUQUJfQ0hBUlRfSURdOiAndmlzdWFsaXphdGlvbnMnLFxyXG59IGFzIGNvbnN0O1xyXG5leHBvcnQgY29uc3QgSEFTX1NBVkVEX1RJTUVTVEFNUCA9ICdoYXNTYXZlZFRpbWVzdGFtcCc7XHJcbmV4cG9ydCBjb25zdCBGSUxURVJfT1BUSU9OUyA9IFsnVmlzdWFsaXphdGlvbicsICdRdWVyeScsICdNZXRyaWMnXTtcclxuZXhwb3J0IGNvbnN0IFNBVkVEX1FVRVJZID0gJ3NhdmVkUXVlcnknO1xyXG5leHBvcnQgY29uc3QgU0FWRURfVklTVUFMSVpBVElPTiA9ICdzYXZlZFZpc3VhbGl6YXRpb24nO1xyXG5leHBvcnQgY29uc3QgU0FWRURfT0JKRUNUX0lEID0gJ3NhdmVkT2JqZWN0SWQnO1xyXG5leHBvcnQgY29uc3QgU0FWRURfT0JKRUNUX1RZUEUgPSAnb2JqZWN0VHlwZSc7XHJcbmV4cG9ydCBjb25zdCBUQUJfQ1JFQVRFRF9UWVBFID0gJ3RhYkNyZWF0ZWRUeXBlJztcclxuZXhwb3J0IGNvbnN0IE5FV19UQUIgPSAnbmV3VGFiJztcclxuZXhwb3J0IGNvbnN0IFJFRElSRUNUX1RBQiA9ICdyZWRpcmVjdF90YWInO1xyXG5leHBvcnQgY29uc3QgUEFHRV9TSVpFID0gNTA7XHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX0NPTFVNTlMgPSBbJycsICdUaW1lJywgJ19zb3VyY2UnXTtcclxuZXhwb3J0IGNvbnN0IE9URUxfVFJBQ0VfSUQgPSAndHJhY2VJZCc7XHJcbmV4cG9ydCBjb25zdCBKQUVHRVJfVFJBQ0VfSUQgPSAndHJhY2VJRCc7XHJcbmV4cG9ydCBjb25zdCBEQVRFX1BJQ0tFUl9GT1JNQVQgPSAnWVlZWS1NTS1ERCBISDptbTpzcyc7XHJcbmV4cG9ydCBjb25zdCBEQVRFX0RJU1BMQVlfRk9STUFUID0gJ01NTSBELCBZWVlZIEAgSEg6bW06c3MuU1NTJztcclxuZXhwb3J0IGNvbnN0IERFRkFVTFRfREFURVRJTUVfU1RSSU5HID0gJ25vdyc7XHJcbmV4cG9ydCBjb25zdCBUSU1FX0lOVEVSVkFMX09QVElPTlMgPSBbXHJcbiAge1xyXG4gICAgdGV4dDogJ01pbnV0ZScsXHJcbiAgICB2YWx1ZTogJ20nLFxyXG4gIH0sXHJcbiAge1xyXG4gICAgdGV4dDogJ0hvdXInLFxyXG4gICAgdmFsdWU6ICdoJyxcclxuICB9LFxyXG4gIHtcclxuICAgIHRleHQ6ICdEYXknLFxyXG4gICAgdmFsdWU6ICdkJyxcclxuICB9LFxyXG4gIHtcclxuICAgIHRleHQ6ICdXZWVrJyxcclxuICAgIHZhbHVlOiAndycsXHJcbiAgfSxcclxuICB7XHJcbiAgICB0ZXh0OiAnTW9udGgnLFxyXG4gICAgdmFsdWU6ICdNJyxcclxuICB9LFxyXG4gIHtcclxuICAgIHRleHQ6ICdZZWFyJyxcclxuICAgIHZhbHVlOiAneScsXHJcbiAgfSxcclxuXTtcclxuXHJcbi8vIHJlZHV4XHJcbmV4cG9ydCBjb25zdCBTRUxFQ1RFRF9RVUVSWV9UQUIgPSAnc2VsZWN0ZWRRdWVyeVRhYic7XHJcbmV4cG9ydCBjb25zdCBRVUVSWV9UQUJfSURTID0gJ3F1ZXJ5VGFiSWRzJztcclxuZXhwb3J0IGNvbnN0IE5FV19TRUxFQ1RFRF9RVUVSWV9UQUIgPSAnbmV3U2VsZWN0ZWRRdWVyeVRhYic7XHJcbmV4cG9ydCBjb25zdCBSRURVWF9FWFBMX1NMSUNFX1FVRVJJRVMgPSAncXVlcmllcyc7XHJcbmV4cG9ydCBjb25zdCBSRURVWF9FWFBMX1NMSUNFX1FVRVJZX1JFU1VMVCA9ICdxdWVyeVJlc3VsdHMnO1xyXG5leHBvcnQgY29uc3QgUkVEVVhfRVhQTF9TTElDRV9GSUVMRFMgPSAnZmllbGRzJztcclxuZXhwb3J0IGNvbnN0IFJFRFVYX0VYUExfU0xJQ0VfUVVFUllfVEFCUyA9ICdxdWVyeVRhYnMnO1xyXG5leHBvcnQgY29uc3QgUkVEVVhfRVhQTF9TTElDRV9WSVNVQUxJWkFUSU9OID0gJ2V4cGxvcmVyVmlzdWFsaXphdGlvbic7XHJcbmV4cG9ydCBjb25zdCBSRURVWF9FWFBMX1NMSUNFX0NPVU5UX0RJU1RSSUJVVElPTiA9ICdjb3VudERpc3RyaWJ1dGlvblZpc3VhbGl6YXRpb24nO1xyXG5leHBvcnQgY29uc3QgUkVEVVhfRVhQTF9TTElDRV9QQVRURVJOUyA9ICdwYXR0ZXJucyc7XHJcbmV4cG9ydCBjb25zdCBSRURVWF9FWFBMX1NMSUNFX1NFQVJDSF9NRVRBX0RBVEEgPSAnc2VhcmNoTWV0YURhdGEnO1xyXG5leHBvcnQgY29uc3QgUExPVExZX0dBVUdFX0NPTFVNTl9OVU1CRVIgPSA0O1xyXG5leHBvcnQgY29uc3QgQVBQX0FOQUxZVElDU19UQUJfSURfUkVHRVggPSAvYXBwbGljYXRpb24tYW5hbHl0aWNzLXRhYi4rLztcclxuZXhwb3J0IGNvbnN0IERFRkFVTFRfQVZBSUxBQklMSVRZX1FVRVJZID0gJ3N0YXRzIGNvdW50KCkgYnkgc3BhbiggdGltZXN0YW1wLCAxaCApJztcclxuZXhwb3J0IGNvbnN0IFBQTF9ERUZBVUxUX1BBVFRFUk5fUkVHRVhfRklMRVRFUiA9ICdbYS16QS1aXFxcXGRdJztcclxuLy8gR3JlZWRpbHkgbWF0Y2hlcyB0aGUgbG9uZ2VzdCBzdWJzdHJpbmcgZm9yIGV4YW1wbGUgKHBhdHRlcm5zIHJlZmVyZXIgfCBwYXR0ZXJucyBwYXR0ZXJuPSdbMC05XScgbWVzc2FnZSB8IHdoZXJlIC4uLikgdXNlZCB0byBtb2RpZnkgdGhlIHF1ZXJ5IGZvciBwYXR0ZXJucyB0YWJsZVxyXG5leHBvcnQgY29uc3QgUEFUVEVSTlNfUkVHRVggPSAvXFx8XFxzKnBhdHRlcm5zLis/XFx8LipcXHMqd2hlcmVcXHMrcGF0dGVybnNfZmllbGRcXHMqXFw9XFxzKidbXmEtekEtWjAtOV0rJy87XHJcbi8vIFVzZWQgdG8gZXh0cmFjdCB0aGUgaW5pdGlhbCBwYXR0ZXJuIGFwcGxpZWRcclxuZXhwb3J0IGNvbnN0IFBBVFRFUk5TX0VYVFJBQ1RPUl9SRUdFWCA9IC9wYXR0ZXJuc1xccysoPzxwYXR0ZXJuPlxcUyspLztcclxuZXhwb3J0IGNvbnN0IEFERF9CVVRUT05fVEVYVCA9ICcrIEFkZCBjb2xvciB0aGVtZSc7XHJcbmV4cG9ydCBjb25zdCBOVU1CRVJfSU5QVVRfTUlOX0xJTUlUID0gMTtcclxuXHJcbmV4cG9ydCBjb25zdCBWSVpfQ09OVEFJTl9YWV9BWElTID0gW1xyXG4gIFZJU19DSEFSVF9UWVBFUy5CYXIsXHJcbiAgVklTX0NIQVJUX1RZUEVTLkhpc3RvZ3JhbSxcclxuICBWSVNfQ0hBUlRfVFlQRVMuTGluZSxcclxuICBWSVNfQ0hBUlRfVFlQRVMuUGllLFxyXG4gIFZJU19DSEFSVF9UWVBFUy5TY2F0dGVyLFxyXG4gIFZJU19DSEFSVF9UWVBFUy5Ib3Jpem9udGFsQmFyLFxyXG5dO1xyXG5cclxuLy8gZGVmYXVsdCBwcGwgYWdncmVnYXRpb24gbWV0aG9kIG9wdGlvbnNcclxuZXhwb3J0IGNvbnN0IEFHR1JFR0FUSU9OX09QVElPTlMgPSBbXHJcbiAge1xyXG4gICAgbGFiZWw6ICdjb3VudCcsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ3N1bScsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ2F2ZycsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ21heCcsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ21pbicsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ3Zhcl9zYW1wJyxcclxuICB9LFxyXG4gIHtcclxuICAgIGxhYmVsOiAndmFyX3BvcCcsXHJcbiAgfSxcclxuICB7XHJcbiAgICBsYWJlbDogJ3N0ZGRldl9zYW1wJyxcclxuICB9LFxyXG4gIHtcclxuICAgIGxhYmVsOiAnc3RkZGV2X3BvcCcsXHJcbiAgfSxcclxuXTtcclxuXHJcbi8vIG51bWVyaWMgZmllbGRzIHR5cGUgZm9yIG1ldHJpY3NcclxuZXhwb3J0IGNvbnN0IE5VTUVSSUNBTF9UWVBFUyA9IFtcclxuICAnZmxvYXQnLFxyXG4gICdkb3VibGUnLFxyXG4gICdiaWdpbnQnLFxyXG4gICdsb25nJyxcclxuICAnb2N0ZXQnLFxyXG4gICdzaG9ydCcsXHJcbiAgJ2J5dGUnLFxyXG4gICdpbnRlZ2VyJyxcclxuXTtcclxuLy8gRGF0YSB0YWJsZSBjb25zdGFudHNcclxuZXhwb3J0IGNvbnN0IEdSSURfSEVBREVSX0NPTFVNTl9NQVhfV0lEVEggPSAnMTUwcHgnO1xyXG5leHBvcnQgY29uc3QgR1JJRF9QQUdFX1JBTkdFX0RJU1BMQVkgPSA1O1xyXG5leHBvcnQgY29uc3QgQ09MVU1OX0RFRkFVTFRfTUlOX1dJRFRIID0gMTAwO1xyXG5leHBvcnQgY29uc3QgR1JJRF9QQUdFX1NJWkVTID0gWzEwLCA1MCwgMTAwXTtcclxuZXhwb3J0IGNvbnN0IFJPV19ERU5TSVRJRVMgPSBbXHJcbiAgeyBpY29uOiAndGFibGVEZW5zaXR5RXhwYW5kZWQnLCBoZWlnaHQ6IDU1LCBzZWxlY3RlZDogZmFsc2UgfSxcclxuICB7IGljb246ICd0YWJsZURlbnNpdHlOb3JtYWwnLCBoZWlnaHQ6IDQ1LCBzZWxlY3RlZDogZmFsc2UgfSxcclxuICB7IGljb246ICd0YWJsZURlbnNpdHlDb21wYWN0JywgaGVpZ2h0OiAzNSwgc2VsZWN0ZWQ6IHRydWUgfSxcclxuXTtcclxuXHJcbmV4cG9ydCBjb25zdCBIRUFERVJfSEVJR0hUID0gMzU7XHJcblxyXG4vLyBnYXVnZSBjaGFydCBkZWZhdWx0IHBhcmFtZXRlcnNcclxuZXhwb3J0IGludGVyZmFjZSBEZWZhdWx0R2F1Z2VDaGFydFBhcmFtZXRlcnNQcm9wcyB7XHJcbiAgR2F1Z2VUaXRsZVNpemU6IG51bWJlcjtcclxuICBEaXNwbGF5RGVmYXVsdEdhdWdlczogbnVtYmVyO1xyXG4gIE9yaWVudGF0aW9uRGVmYXVsdDogc3RyaW5nO1xyXG4gIFRpY2tMZW5ndGg6IG51bWJlcjtcclxuICBMZWdlbmRQbGFjZW1lbnQ6IHN0cmluZztcclxuICBUaHJlc2hvbGRzTWF4TGltaXQ6IG51bWJlcjtcclxufVxyXG5cclxuZXhwb3J0IGNvbnN0IERFRkFVTFRfR0FVR0VfQ0hBUlRfUEFSQU1FVEVSUzogRGVmYXVsdEdhdWdlQ2hhcnRQYXJhbWV0ZXJzUHJvcHMgPSB7XHJcbiAgR2F1Z2VUaXRsZVNpemU6IDE0LFxyXG4gIERpc3BsYXlEZWZhdWx0R2F1Z2VzOiAxLFxyXG4gIE9yaWVudGF0aW9uRGVmYXVsdDogJ2gnLFxyXG4gIFRpY2tMZW5ndGg6IDUsXHJcbiAgTGVnZW5kUGxhY2VtZW50OiAnY2VudGVyJyxcclxuICBUaHJlc2hvbGRzTWF4TGltaXQ6IDEsXHJcbn07XHJcblxyXG4vLyBwaWUgY2hhcnQgZGVmYXVsdCBwYXJhbWV0ZXJzXHJcbmV4cG9ydCBjb25zdCBQTE9UTFlfUElFX0NPTFVNTl9OVU1CRVIgPSAyO1xyXG5leHBvcnQgY29uc3QgUElFX1hBWElTX0dBUCA9IDAuMjtcclxuZXhwb3J0IGNvbnN0IFBJRV9ZQVhJU19HQVAgPSAwLjE7XHJcbmV4cG9ydCBpbnRlcmZhY2UgRGVmYXVsdFBpZUNoYXJ0UGFyYW1ldGVyUHJvcHMge1xyXG4gIERlZmF1bHRNb2RlOiBzdHJpbmc7XHJcbn1cclxuXHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX1BJRV9DSEFSVF9QQVJBTUVURVJTOiBEZWZhdWx0UGllQ2hhcnRQYXJhbWV0ZXJQcm9wcyA9IHtcclxuICBEZWZhdWx0TW9kZTogJ3BpZScsXHJcbn07XHJcbmV4cG9ydCBjb25zdCBHUk9VUEJZID0gJ2RpbWVuc2lvbnMnO1xyXG5leHBvcnQgY29uc3QgQUdHUkVHQVRJT05TID0gJ3Nlcmllcyc7XHJcbmV4cG9ydCBjb25zdCBQQVJFTlRGSUVMRFMgPSAncGFyZW50RmllbGRzJztcclxuZXhwb3J0IGNvbnN0IFZBTFVFRklFTEQgPSAndmFsdWVGaWVsZCc7XHJcbmV4cG9ydCBjb25zdCBDSElMREZJRUxEID0gJ2NoaWxkRmllbGQnO1xyXG5leHBvcnQgY29uc3QgVElNRVNUQU1QID0gJ3RpbWVzdGFtcCc7XHJcblxyXG4vLyBtZXRyaWNzIGNvbnN0YW50c1xyXG5leHBvcnQgY29uc3QgTUVUUklDU19HUklEX1NQQUNFX0JFVFdFRU5fWF9BWElTID0gMC4wMTtcclxuZXhwb3J0IGNvbnN0IE1FVFJJQ1NfR1JJRF9TUEFDRV9CRVRXRUVOX1lfQVhJUyA9IDEwMDtcclxuZXhwb3J0IGNvbnN0IE1FVFJJQ1NfUkVEVUNFX1ZBTFVFX1NJWkVfUEVSQ0VOVEFHRSA9IDAuMDg7XHJcbmV4cG9ydCBjb25zdCBNRVRSSUNTX1JFRFVDRV9USVRMRV9TSVpFX1BFUkNFTlRBR0UgPSAwLjA1O1xyXG5leHBvcnQgY29uc3QgTUVUUklDU19SRURVQ0VfU0VSSUVTX1VOSVRfU0laRV9QRVJDRU5UQUdFID0gMC4yO1xyXG5leHBvcnQgY29uc3QgTUVUUklDU19TRVJJRVNfVU5JVF9TVUJTVFJJTkdfTEVOR1RIID0gMztcclxuZXhwb3J0IGNvbnN0IE1FVFJJQ1NfQVhJU19NQVJHSU4gPSB7XHJcbiAgbDogMCxcclxuICByOiAwLFxyXG4gIGI6IDAsXHJcbiAgdDogODAsXHJcbn07XHJcblxyXG5leHBvcnQgY29uc3QgTUVUUklDU19BTk5PVEFUSU9OID0ge1xyXG4gIHhyZWY6ICdwYXBlcicsXHJcbiAgeXJlZjogJ3BhcGVyJyxcclxuICBzaG93YXJyb3c6IGZhbHNlLFxyXG59O1xyXG5cclxuZXhwb3J0IGludGVyZmFjZSBEZWZhdWx0TWV0cmljc0NoYXJ0UGFyYW1ldGVyc1Byb3BzIHtcclxuICBEZWZhdWx0VGV4dE1vZGU6IHN0cmluZztcclxuICBEZWZhdWx0T3JpZW50YXRpb246IHN0cmluZztcclxuICBEZWZhdWx0VGl0bGVTaXplOiBudW1iZXI7XHJcbiAgRGVmYXVsdENoYXJ0VHlwZTogc3RyaW5nO1xyXG4gIFRleHRBbGlnbm1lbnQ6IHN0cmluZztcclxuICBEZWZhdWx0UHJlY2lzaW9uOiBudW1iZXI7XHJcbiAgRGVmYXVsdFZhbHVlU2l6ZTogbnVtYmVyO1xyXG4gIEJhc2VUaHJlc2hvbGQ6IFRocmVzaG9sZFVuaXRUeXBlO1xyXG4gIERlZmF1bHRUZXh0Q29sb3I6IHN0cmluZztcclxufVxyXG5cclxuZXhwb3J0IGNvbnN0IERFRkFVTFRfTUVUUklDU19DSEFSVF9QQVJBTUVURVJTOiBEZWZhdWx0TWV0cmljc0NoYXJ0UGFyYW1ldGVyc1Byb3BzID0ge1xyXG4gIERlZmF1bHRUZXh0TW9kZTogJ2F1dG8nLFxyXG4gIERlZmF1bHRPcmllbnRhdGlvbjogJ2F1dG8nLFxyXG4gIERlZmF1bHRUaXRsZVNpemU6IDMwLFxyXG4gIERlZmF1bHRWYWx1ZVNpemU6IDgwLFxyXG4gIERlZmF1bHRDaGFydFR5cGU6ICdhdXRvJyxcclxuICBUZXh0QWxpZ25tZW50OiAnYXV0bycsXHJcbiAgRGVmYXVsdFByZWNpc2lvbjogMSxcclxuICBCYXNlVGhyZXNob2xkOiB7XHJcbiAgICB0aGlkOiBodG1sSWRHZW5lcmF0b3IoJ3RocicpKCksXHJcbiAgICBuYW1lOiAnQmFzZScsXHJcbiAgICBjb2xvcjogJyMzQ0ExQzcnLFxyXG4gICAgdmFsdWU6IDAsXHJcbiAgICBpc1JlYWRPbmx5OiB0cnVlLFxyXG4gIH0sXHJcbiAgRGVmYXVsdFRleHRDb2xvcjogJyNGRkZGRkYnLFxyXG59O1xyXG5leHBvcnQgaW50ZXJmYWNlIERlZmF1bHRCYXJDaGFydFN0eWxlc1Byb3BzIHtcclxuICBCYXJNb2RlOiBzdHJpbmc7XHJcbiAgR3JvdXBXaWR0aDogbnVtYmVyO1xyXG4gIEJhcldpZHRoOiBudW1iZXI7XHJcbiAgTGFiZWxTaXplOiBudW1iZXI7XHJcbn1cclxuXHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX0JBUl9DSEFSVF9TVFlMRVM6IERlZmF1bHRCYXJDaGFydFN0eWxlc1Byb3BzID0ge1xyXG4gIEJhck1vZGU6ICdncm91cCcsXHJcbiAgR3JvdXBXaWR0aDogMC43LFxyXG4gIEJhcldpZHRoOiAwLjk3LFxyXG4gIExhYmVsU2l6ZTogMTIsXHJcbn07XHJcblxyXG5leHBvcnQgY29uc3QgU0lNSUxBUl9WSVpfVFlQRVMgPSBbXHJcbiAgVklTX0NIQVJUX1RZUEVTLkxpbmUsXHJcbiAgVklTX0NIQVJUX1RZUEVTLlNjYXR0ZXIsXHJcbiAgVklTX0NIQVJUX1RZUEVTLkhvcml6b250YWxCYXIsXHJcbiAgVklTX0NIQVJUX1RZUEVTLkJhcixcclxuXTtcclxuXHJcbmV4cG9ydCBlbnVtIENvbmZpZ0NoYXJ0T3B0aW9uc0VudW0ge1xyXG4gIHBhbGV0dGVQaWNrZXIgPSAncGFsZXR0ZVBpY2tlcicsXHJcbiAgc2luZ2xlQ29sb3JQaWNrZXIgPSAnc2luZ2xlQ29sb3JQaWNrZXInLFxyXG4gIGNvbG9ycGlja2VyID0gJ2NvbG9ycGlja2VyJyxcclxuICB0cmVlbWFwQ29sb3JQaWNrZXIgPSAndHJlZW1hcENvbG9yUGlja2VyJyxcclxuICBpbnB1dCA9ICdpbnB1dCcsXHJcbiAgdGV4dElucHV0ID0gJ3RleHRJbnB1dCcsXHJcbiAgc2xpZGVyID0gJ3NsaWRlcicsXHJcbiAgc3dpdGNoQnV0dG9uID0gJ3N3aXRjaEJ1dHRvbicsXHJcbiAgYnV0dG9ucyA9ICdidXR0b25zJyxcclxufVxyXG5cclxuZXhwb3J0IGNvbnN0IENVU1RPTV9MQUJFTCA9ICdjdXN0b21MYWJlbCc7XHJcbmV4cG9ydCBjb25zdCBCUkVBS0RPV05TID0gJ2JyZWFrZG93bnMnO1xyXG5leHBvcnQgY29uc3QgU1BBTiA9ICdzcGFuJztcclxuZXhwb3J0IGNvbnN0IFRJTUVfRklFTEQgPSAndGltZV9maWVsZCc7XHJcbmV4cG9ydCBjb25zdCBESVNBQkxFRF9DT0xPVVIgPSAnI2ZhZmJmZCc7XHJcbmV4cG9ydCBjb25zdCBEQVRBX0NPTkZJR19ISU5UU19JTkZPID0ge1xyXG4gIFtBR0dSRUdBVElPTlNdOlxyXG4gICAgJ1NlcmllcyBpcyBhbiBhZ2dyZWdhdGlvbiBmdW5jdGlvbiAobWFuZGF0b3J5KS4gVGhlIGFyZ3VtZW50IG9mIGFuIGFnZ3JlZ2F0aW9uIG11c3QgYmUgYSBmaWVsZC4nLFxyXG4gIFtHUk9VUEJZXTpcclxuICAgIFwiRGltZW5zaW9ucyBhcmUgJ2J5JyBjbGF1c2VzLiBUaGV5IGFyZSBmaWVsZHMgb3IgZXhwcmVzc2lvbnMgbGlrZSBzY2FsYXIgYW5kIGFnZ3JlZ2F0aW9uIGZ1bmN0aW9ucy4gQmVzaWRlcywgdGhlIHNwYW4gY2xhdXNlIGZvciBhIGRpbWVuc2lvbiBjYW4gYmUgdXNlZCB0byBzcGxpdCBhIHNwZWNpZmljIGZpZWxkIGludG8gYnVja2V0cyBpbiB0aGUgc2FtZSBpbnRlcnZhbCwgdGhlIHN0YXRzIHRoZW4gZG9lcyB0aGUgYWdncmVnYXRpb24gYnkgdGhlc2Ugc3BhbiBidWNrZXRzLlwiLFxyXG4gIFtCUkVBS0RPV05TXTpcclxuICAgIFwiRGVmaW5lcyBob3cgZWFjaCBzZXJpZXMgaXMgYnJva2VuIGRvd24uIEJyZWFrZG93bnMgYXJlICdieScgY2xhdXNlcyB0aGF0IHN1YmRpdmlkZSB0aGUgZXhpc3Rpbmcgc2VyaWVzLlwiLFxyXG59O1xyXG5cclxuLy8gTWV0cmljcyBjb25zdGFudHNcclxuZXhwb3J0IGNvbnN0IFVOSVRTX09GX01FQVNVUkUgPSBbXHJcbiAgJ3NlY29uZHMgKHMpJyxcclxuICAnaG91cnMgKGgpJyxcclxuICAnY2Vsc2l1cyAoQyknLFxyXG4gICdmYXJlbmhlaXQgKEYpJyxcclxuICAnbWV0ZXJzIChtKScsXHJcbiAgJ2tpbG9tZXRlcnMgKGspJyxcclxuXTtcclxuXHJcbmV4cG9ydCBjb25zdCBzYW1wbGVMb2dQYXR0ZXJuRGF0YSA9IHtcclxuICBjb3VudDogNSxcclxuICBwYXR0ZXJuOiAnW2EtekEtWmRdJyxcclxuICBzYW1wbGVMb2c6XHJcbiAgICAnMjE4LjE0OC4xMzUuMTIgLSAtIFsyMDE4LTA3LTIyVDA0OjE4OjEyLjM0NVpdIFwiR0VUIC9iZWF0cy9maWxlYmVhdC9maWxlYmVhdC02LjMuMi1saW51eC14ODZfNjQudGFyLmd6XzEgSFRUUC8xLjFcIiAyMDAgNDUzMSBcIi1cIiBcXFxyXG4gICAgICAgICAgIFwiTW96aWxsYS81LjAgKFgxMTsgTGludXggeDg2XzY0OyBydjo2LjBhMSkgR2Vja28vMjAxMTA0MjEgRmlyZWZveC82LjBhMVwiJyxcclxuICBhbm9tYWx5Q291bnQ6IDAsXHJcbn07XHJcblxyXG5leHBvcnQgY29uc3QgVFlQRV9UQUJfTUFQUElORyA9IHtcclxuICBbU0FWRURfUVVFUlldOiBUQUJfRVZFTlRfSUQsXHJcbiAgW1NBVkVEX1ZJU1VBTElaQVRJT05dOiBUQUJfQ0hBUlRfSUQsXHJcbn07XHJcblxyXG5leHBvcnQgY29uc3QgREVGQVVMVF9FTVBUWV9FWFBMT1JFUl9GSUVMRFMgPSBbXHJcbiAgLy8gdGltZXN0YW1wIGZpZWxkIHdpbGwgYmUgYSBkZWZhdWx0IGJ1dCBpcyBhZGRlZCBhZnRlciBmaW5kaW5nIHdoYXQgaXQgaXNcclxuICB7IG5hbWU6ICdfc291cmNlJywgdHlwZTogJ3N0cmluZycgfSxcclxuXTtcclxuXHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX1RJTUVTVEFNUF9DT0xVTU4gPSB7XHJcbiAgaWQ6ICd0aW1lc3RhbXAnLFxyXG4gIGlzU29ydGFibGU6IHRydWUsXHJcbiAgZGlzcGxheTogJ1RpbWUnLFxyXG4gIHNjaGVtYTogJ2RhdGV0aW1lJyxcclxuICBpbml0aWFsV2lkdGg6IDIwMCxcclxufTtcclxuXHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX1NPVVJDRV9DT0xVTU4gPSB7XHJcbiAgaWQ6ICdfc291cmNlJyxcclxuICBpc1NvcnRhYmxlOiBmYWxzZSxcclxuICBkaXNwbGF5OiAnU291cmNlJyxcclxuICBzY2hlbWE6ICdfc291cmNlJyxcclxufTtcclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0EsSUFBQUEsSUFBQSxHQUFBQyxPQUFBO0FBRUEsSUFBQUMsT0FBQSxHQUFBRCxPQUFBO0FBUEE7QUFDQTtBQUNBO0FBQ0E7O0FBTUE7QUFDTyxNQUFNRSxpQ0FBaUMsR0FBQUMsT0FBQSxDQUFBRCxpQ0FBQSxHQUM1Qyx5RUFBeUU7QUFDcEUsTUFBTUUsbUNBQW1DLEdBQUFELE9BQUEsQ0FBQUMsbUNBQUEsR0FDOUMsc0ZBQXNGO0FBQ2pGLE1BQU1DLHNCQUFzQixHQUFBRixPQUFBLENBQUFFLHNCQUFBLEdBQUcsK0JBQStCO0FBRTlELE1BQU1DLFNBQVMsR0FBQUgsT0FBQSxDQUFBRyxTQUFBLEdBQUcsVUFBVTtBQUM1QixNQUFNQyxXQUFXLEdBQUFKLE9BQUEsQ0FBQUksV0FBQSxHQUFHLFlBQVk7QUFDaEMsTUFBTUMsbUJBQW1CLEdBQUFMLE9BQUEsQ0FBQUssbUJBQUEsR0FBRyxtQkFBbUI7QUFDL0MsTUFBTUMsS0FBSyxHQUFBTixPQUFBLENBQUFNLEtBQUEsR0FBRyxPQUFPO0FBQ3JCLE1BQU1DLG9CQUFvQixHQUFBUCxPQUFBLENBQUFPLG9CQUFBLEdBQUcsb0JBQW9CO0FBQ2pELE1BQU1DLHNCQUFzQixHQUFBUixPQUFBLENBQUFRLHNCQUFBLEdBQUcsc0JBQXNCO0FBQ3JELE1BQU1DLGFBQWEsR0FBQVQsT0FBQSxDQUFBUyxhQUFBLEdBQUcsY0FBYztBQUNwQyxNQUFNQyxnQkFBZ0IsR0FBQVYsT0FBQSxDQUFBVSxnQkFBQSxHQUFHLGlCQUFpQjtBQUMxQyxNQUFNQyxrQkFBa0IsR0FBQVgsT0FBQSxDQUFBVyxrQkFBQSxHQUFHLG1CQUFtQjtBQUM5QyxNQUFNQyxlQUFlLEdBQUFaLE9BQUEsQ0FBQVksZUFBQSxHQUFHLGdCQUFnQjtBQUN4QyxNQUFNQyxpQkFBaUIsR0FBQWIsT0FBQSxDQUFBYSxpQkFBQSxHQUFHLGtCQUFrQjtBQUM1QyxNQUFNQyxnQkFBZ0IsR0FBQWQsT0FBQSxDQUFBYyxnQkFBQSxHQUFHLGlCQUFpQjtBQUMxQyxNQUFNQyxjQUFjLEdBQUFmLE9BQUEsQ0FBQWUsY0FBQSxHQUFHLGVBQWU7QUFDdEMsTUFBTUMsY0FBYyxHQUFBaEIsT0FBQSxDQUFBZ0IsY0FBQSxHQUFHLGVBQWU7QUFDdEMsTUFBTUMsU0FBUyxHQUFBakIsT0FBQSxDQUFBaUIsU0FBQSxHQUFHLFdBQVc7QUFDN0IsTUFBTUMsZUFBZSxHQUFBbEIsT0FBQSxDQUFBa0IsZUFBQSxHQUFHLGdCQUFnQjtBQUN4QyxNQUFNQyxlQUFlLEdBQUFuQixPQUFBLENBQUFtQixlQUFBLEdBQUcsUUFBUTtBQUNoQyxNQUFNQyxvQkFBb0IsR0FBQXBCLE9BQUEsQ0FBQW9CLG9CQUFBLEdBQUcsc0JBQXNCO0FBQ25ELE1BQU1DLG9CQUFvQixHQUFBckIsT0FBQSxDQUFBcUIsb0JBQUEsR0FBRyxtQkFBbUI7QUFDaEQsTUFBTUMsWUFBWSxHQUFBdEIsT0FBQSxDQUFBc0IsWUFBQSxHQUFHLHFCQUFxQjtBQUMxQyxNQUFNQyxZQUFZLEdBQUF2QixPQUFBLENBQUF1QixZQUFBLEdBQUcsa0JBQWtCO0FBQ3ZDLE1BQU1DLG9CQUFvQixHQUFBeEIsT0FBQSxDQUFBd0Isb0JBQUEsR0FBRyxRQUFRO0FBQ3JDLE1BQU1DLGdCQUFnQixHQUFBekIsT0FBQSxDQUFBeUIsZ0JBQUEsR0FBRztFQUM5QixDQUFDSCxZQUFZLEdBQUcsUUFBUTtFQUN4QixDQUFDQyxZQUFZLEdBQUc7QUFDbEIsQ0FBVTtBQUNILE1BQU1HLG1CQUFtQixHQUFBMUIsT0FBQSxDQUFBMEIsbUJBQUEsR0FBRyxtQkFBbUI7QUFDL0MsTUFBTUMsY0FBYyxHQUFBM0IsT0FBQSxDQUFBMkIsY0FBQSxHQUFHLENBQUMsZUFBZSxFQUFFLE9BQU8sRUFBRSxRQUFRLENBQUM7QUFDM0QsTUFBTUMsV0FBVyxHQUFBNUIsT0FBQSxDQUFBNEIsV0FBQSxHQUFHLFlBQVk7QUFDaEMsTUFBTUMsbUJBQW1CLEdBQUE3QixPQUFBLENBQUE2QixtQkFBQSxHQUFHLG9CQUFvQjtBQUNoRCxNQUFNQyxlQUFlLEdBQUE5QixPQUFBLENBQUE4QixlQUFBLEdBQUcsZUFBZTtBQUN2QyxNQUFNQyxpQkFBaUIsR0FBQS9CLE9BQUEsQ0FBQStCLGlCQUFBLEdBQUcsWUFBWTtBQUN0QyxNQUFNQyxnQkFBZ0IsR0FBQWhDLE9BQUEsQ0FBQWdDLGdCQUFBLEdBQUcsZ0JBQWdCO0FBQ3pDLE1BQU1DLE9BQU8sR0FBQWpDLE9BQUEsQ0FBQWlDLE9BQUEsR0FBRyxRQUFRO0FBQ3hCLE1BQU1DLFlBQVksR0FBQWxDLE9BQUEsQ0FBQWtDLFlBQUEsR0FBRyxjQUFjO0FBQ25DLE1BQU1DLFNBQVMsR0FBQW5DLE9BQUEsQ0FBQW1DLFNBQUEsR0FBRyxFQUFFO0FBQ3BCLE1BQU1DLGVBQWUsR0FBQXBDLE9BQUEsQ0FBQW9DLGVBQUEsR0FBRyxDQUFDLEVBQUUsRUFBRSxNQUFNLEVBQUUsU0FBUyxDQUFDO0FBQy9DLE1BQU1DLGFBQWEsR0FBQXJDLE9BQUEsQ0FBQXFDLGFBQUEsR0FBRyxTQUFTO0FBQy9CLE1BQU1DLGVBQWUsR0FBQXRDLE9BQUEsQ0FBQXNDLGVBQUEsR0FBRyxTQUFTO0FBQ2pDLE1BQU1DLGtCQUFrQixHQUFBdkMsT0FBQSxDQUFBdUMsa0JBQUEsR0FBRyxxQkFBcUI7QUFDaEQsTUFBTUMsbUJBQW1CLEdBQUF4QyxPQUFBLENBQUF3QyxtQkFBQSxHQUFHLDRCQUE0QjtBQUN4RCxNQUFNQyx1QkFBdUIsR0FBQXpDLE9BQUEsQ0FBQXlDLHVCQUFBLEdBQUcsS0FBSztBQUNyQyxNQUFNQyxxQkFBcUIsR0FBQTFDLE9BQUEsQ0FBQTBDLHFCQUFBLEdBQUcsQ0FDbkM7RUFDRUMsSUFBSSxFQUFFLFFBQVE7RUFDZEMsS0FBSyxFQUFFO0FBQ1QsQ0FBQyxFQUNEO0VBQ0VELElBQUksRUFBRSxNQUFNO0VBQ1pDLEtBQUssRUFBRTtBQUNULENBQUMsRUFDRDtFQUNFRCxJQUFJLEVBQUUsS0FBSztFQUNYQyxLQUFLLEVBQUU7QUFDVCxDQUFDLEVBQ0Q7RUFDRUQsSUFBSSxFQUFFLE1BQU07RUFDWkMsS0FBSyxFQUFFO0FBQ1QsQ0FBQyxFQUNEO0VBQ0VELElBQUksRUFBRSxPQUFPO0VBQ2JDLEtBQUssRUFBRTtBQUNULENBQUMsRUFDRDtFQUNFRCxJQUFJLEVBQUUsTUFBTTtFQUNaQyxLQUFLLEVBQUU7QUFDVCxDQUFDLENBQ0Y7O0FBRUQ7QUFDTyxNQUFNQyxrQkFBa0IsR0FBQTdDLE9BQUEsQ0FBQTZDLGtCQUFBLEdBQUcsa0JBQWtCO0FBQzdDLE1BQU1DLGFBQWEsR0FBQTlDLE9BQUEsQ0FBQThDLGFBQUEsR0FBRyxhQUFhO0FBQ25DLE1BQU1DLHNCQUFzQixHQUFBL0MsT0FBQSxDQUFBK0Msc0JBQUEsR0FBRyxxQkFBcUI7QUFDcEQsTUFBTUMsd0JBQXdCLEdBQUFoRCxPQUFBLENBQUFnRCx3QkFBQSxHQUFHLFNBQVM7QUFDMUMsTUFBTUMsNkJBQTZCLEdBQUFqRCxPQUFBLENBQUFpRCw2QkFBQSxHQUFHLGNBQWM7QUFDcEQsTUFBTUMsdUJBQXVCLEdBQUFsRCxPQUFBLENBQUFrRCx1QkFBQSxHQUFHLFFBQVE7QUFDeEMsTUFBTUMsMkJBQTJCLEdBQUFuRCxPQUFBLENBQUFtRCwyQkFBQSxHQUFHLFdBQVc7QUFDL0MsTUFBTUMsOEJBQThCLEdBQUFwRCxPQUFBLENBQUFvRCw4QkFBQSxHQUFHLHVCQUF1QjtBQUM5RCxNQUFNQyxtQ0FBbUMsR0FBQXJELE9BQUEsQ0FBQXFELG1DQUFBLEdBQUcsZ0NBQWdDO0FBQzVFLE1BQU1DLHlCQUF5QixHQUFBdEQsT0FBQSxDQUFBc0QseUJBQUEsR0FBRyxVQUFVO0FBQzVDLE1BQU1DLGlDQUFpQyxHQUFBdkQsT0FBQSxDQUFBdUQsaUNBQUEsR0FBRyxnQkFBZ0I7QUFDMUQsTUFBTUMsMEJBQTBCLEdBQUF4RCxPQUFBLENBQUF3RCwwQkFBQSxHQUFHLENBQUM7QUFDcEMsTUFBTUMsMEJBQTBCLEdBQUF6RCxPQUFBLENBQUF5RCwwQkFBQSxHQUFHLDZCQUE2QjtBQUNoRSxNQUFNQywwQkFBMEIsR0FBQTFELE9BQUEsQ0FBQTBELDBCQUFBLEdBQUcsd0NBQXdDO0FBQzNFLE1BQU1DLGlDQUFpQyxHQUFBM0QsT0FBQSxDQUFBMkQsaUNBQUEsR0FBRyxhQUFhO0FBQzlEO0FBQ08sTUFBTUMsY0FBYyxHQUFBNUQsT0FBQSxDQUFBNEQsY0FBQSxHQUFHLHNFQUFzRTtBQUNwRztBQUNPLE1BQU1DLHdCQUF3QixHQUFBN0QsT0FBQSxDQUFBNkQsd0JBQUEsR0FBRyw0QkFBNEI7QUFDN0QsTUFBTUMsZUFBZSxHQUFBOUQsT0FBQSxDQUFBOEQsZUFBQSxHQUFHLG1CQUFtQjtBQUMzQyxNQUFNQyxzQkFBc0IsR0FBQS9ELE9BQUEsQ0FBQStELHNCQUFBLEdBQUcsQ0FBQztBQUVoQyxNQUFNQyxtQkFBbUIsR0FBQWhFLE9BQUEsQ0FBQWdFLG1CQUFBLEdBQUcsQ0FDakNDLHVCQUFlLENBQUNDLEdBQUcsRUFDbkJELHVCQUFlLENBQUNFLFNBQVMsRUFDekJGLHVCQUFlLENBQUNHLElBQUksRUFDcEJILHVCQUFlLENBQUNJLEdBQUcsRUFDbkJKLHVCQUFlLENBQUNLLE9BQU8sRUFDdkJMLHVCQUFlLENBQUNNLGFBQWEsQ0FDOUI7O0FBRUQ7QUFDTyxNQUFNQyxtQkFBbUIsR0FBQXhFLE9BQUEsQ0FBQXdFLG1CQUFBLEdBQUcsQ0FDakM7RUFDRUMsS0FBSyxFQUFFO0FBQ1QsQ0FBQyxFQUNEO0VBQ0VBLEtBQUssRUFBRTtBQUNULENBQUMsRUFDRDtFQUNFQSxLQUFLLEVBQUU7QUFDVCxDQUFDLEVBQ0Q7RUFDRUEsS0FBSyxFQUFFO0FBQ1QsQ0FBQyxFQUNEO0VBQ0VBLEtBQUssRUFBRTtBQUNULENBQUMsRUFDRDtFQUNFQSxLQUFLLEVBQUU7QUFDVCxDQUFDLEVBQ0Q7RUFDRUEsS0FBSyxFQUFFO0FBQ1QsQ0FBQyxFQUNEO0VBQ0VBLEtBQUssRUFBRTtBQUNULENBQUMsRUFDRDtFQUNFQSxLQUFLLEVBQUU7QUFDVCxDQUFDLENBQ0Y7O0FBRUQ7QUFDTyxNQUFNQyxlQUFlLEdBQUExRSxPQUFBLENBQUEwRSxlQUFBLEdBQUcsQ0FDN0IsT0FBTyxFQUNQLFFBQVEsRUFDUixRQUFRLEVBQ1IsTUFBTSxFQUNOLE9BQU8sRUFDUCxPQUFPLEVBQ1AsTUFBTSxFQUNOLFNBQVMsQ0FDVjtBQUNEO0FBQ08sTUFBTUMsNEJBQTRCLEdBQUEzRSxPQUFBLENBQUEyRSw0QkFBQSxHQUFHLE9BQU87QUFDNUMsTUFBTUMsdUJBQXVCLEdBQUE1RSxPQUFBLENBQUE0RSx1QkFBQSxHQUFHLENBQUM7QUFDakMsTUFBTUMsd0JBQXdCLEdBQUE3RSxPQUFBLENBQUE2RSx3QkFBQSxHQUFHLEdBQUc7QUFDcEMsTUFBTUMsZUFBZSxHQUFBOUUsT0FBQSxDQUFBOEUsZUFBQSxHQUFHLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUM7QUFDckMsTUFBTUMsYUFBYSxHQUFBL0UsT0FBQSxDQUFBK0UsYUFBQSxHQUFHLENBQzNCO0VBQUVDLElBQUksRUFBRSxzQkFBc0I7RUFBRUMsTUFBTSxFQUFFLEVBQUU7RUFBRUMsUUFBUSxFQUFFO0FBQU0sQ0FBQyxFQUM3RDtFQUFFRixJQUFJLEVBQUUsb0JBQW9CO0VBQUVDLE1BQU0sRUFBRSxFQUFFO0VBQUVDLFFBQVEsRUFBRTtBQUFNLENBQUMsRUFDM0Q7RUFBRUYsSUFBSSxFQUFFLHFCQUFxQjtFQUFFQyxNQUFNLEVBQUUsRUFBRTtFQUFFQyxRQUFRLEVBQUU7QUFBSyxDQUFDLENBQzVEO0FBRU0sTUFBTUMsYUFBYSxHQUFBbkYsT0FBQSxDQUFBbUYsYUFBQSxHQUFHLEVBQUU7O0FBRS9COztBQVVPLE1BQU1DLDhCQUFnRSxHQUFBcEYsT0FBQSxDQUFBb0YsOEJBQUEsR0FBRztFQUM5RUMsY0FBYyxFQUFFLEVBQUU7RUFDbEJDLG9CQUFvQixFQUFFLENBQUM7RUFDdkJDLGtCQUFrQixFQUFFLEdBQUc7RUFDdkJDLFVBQVUsRUFBRSxDQUFDO0VBQ2JDLGVBQWUsRUFBRSxRQUFRO0VBQ3pCQyxrQkFBa0IsRUFBRTtBQUN0QixDQUFDOztBQUVEO0FBQ08sTUFBTUMsd0JBQXdCLEdBQUEzRixPQUFBLENBQUEyRix3QkFBQSxHQUFHLENBQUM7QUFDbEMsTUFBTUMsYUFBYSxHQUFBNUYsT0FBQSxDQUFBNEYsYUFBQSxHQUFHLEdBQUc7QUFDekIsTUFBTUMsYUFBYSxHQUFBN0YsT0FBQSxDQUFBNkYsYUFBQSxHQUFHLEdBQUc7QUFLekIsTUFBTUMsNEJBQTJELEdBQUE5RixPQUFBLENBQUE4Riw0QkFBQSxHQUFHO0VBQ3pFQyxXQUFXLEVBQUU7QUFDZixDQUFDO0FBQ00sTUFBTUMsT0FBTyxHQUFBaEcsT0FBQSxDQUFBZ0csT0FBQSxHQUFHLFlBQVk7QUFDNUIsTUFBTUMsWUFBWSxHQUFBakcsT0FBQSxDQUFBaUcsWUFBQSxHQUFHLFFBQVE7QUFDN0IsTUFBTUMsWUFBWSxHQUFBbEcsT0FBQSxDQUFBa0csWUFBQSxHQUFHLGNBQWM7QUFDbkMsTUFBTUMsVUFBVSxHQUFBbkcsT0FBQSxDQUFBbUcsVUFBQSxHQUFHLFlBQVk7QUFDL0IsTUFBTUMsVUFBVSxHQUFBcEcsT0FBQSxDQUFBb0csVUFBQSxHQUFHLFlBQVk7QUFDL0IsTUFBTUMsU0FBUyxHQUFBckcsT0FBQSxDQUFBcUcsU0FBQSxHQUFHLFdBQVc7O0FBRXBDO0FBQ08sTUFBTUMsaUNBQWlDLEdBQUF0RyxPQUFBLENBQUFzRyxpQ0FBQSxHQUFHLElBQUk7QUFDOUMsTUFBTUMsaUNBQWlDLEdBQUF2RyxPQUFBLENBQUF1RyxpQ0FBQSxHQUFHLEdBQUc7QUFDN0MsTUFBTUMsb0NBQW9DLEdBQUF4RyxPQUFBLENBQUF3RyxvQ0FBQSxHQUFHLElBQUk7QUFDakQsTUFBTUMsb0NBQW9DLEdBQUF6RyxPQUFBLENBQUF5RyxvQ0FBQSxHQUFHLElBQUk7QUFDakQsTUFBTUMsMENBQTBDLEdBQUExRyxPQUFBLENBQUEwRywwQ0FBQSxHQUFHLEdBQUc7QUFDdEQsTUFBTUMsb0NBQW9DLEdBQUEzRyxPQUFBLENBQUEyRyxvQ0FBQSxHQUFHLENBQUM7QUFDOUMsTUFBTUMsbUJBQW1CLEdBQUE1RyxPQUFBLENBQUE0RyxtQkFBQSxHQUFHO0VBQ2pDQyxDQUFDLEVBQUUsQ0FBQztFQUNKQyxDQUFDLEVBQUUsQ0FBQztFQUNKQyxDQUFDLEVBQUUsQ0FBQztFQUNKQyxDQUFDLEVBQUU7QUFDTCxDQUFDO0FBRU0sTUFBTUMsa0JBQWtCLEdBQUFqSCxPQUFBLENBQUFpSCxrQkFBQSxHQUFHO0VBQ2hDQyxJQUFJLEVBQUUsT0FBTztFQUNiQyxJQUFJLEVBQUUsT0FBTztFQUNiQyxTQUFTLEVBQUU7QUFDYixDQUFDO0FBY00sTUFBTUMsZ0NBQW9FLEdBQUFySCxPQUFBLENBQUFxSCxnQ0FBQSxHQUFHO0VBQ2xGQyxlQUFlLEVBQUUsTUFBTTtFQUN2QkMsa0JBQWtCLEVBQUUsTUFBTTtFQUMxQkMsZ0JBQWdCLEVBQUUsRUFBRTtFQUNwQkMsZ0JBQWdCLEVBQUUsRUFBRTtFQUNwQkMsZ0JBQWdCLEVBQUUsTUFBTTtFQUN4QkMsYUFBYSxFQUFFLE1BQU07RUFDckJDLGdCQUFnQixFQUFFLENBQUM7RUFDbkJDLGFBQWEsRUFBRTtJQUNiQyxJQUFJLEVBQUUsSUFBQUMsb0JBQWUsRUFBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQzlCQyxJQUFJLEVBQUUsTUFBTTtJQUNaQyxLQUFLLEVBQUUsU0FBUztJQUNoQnJGLEtBQUssRUFBRSxDQUFDO0lBQ1JzRixVQUFVLEVBQUU7RUFDZCxDQUFDO0VBQ0RDLGdCQUFnQixFQUFFO0FBQ3BCLENBQUM7QUFRTSxNQUFNQyx3QkFBb0QsR0FBQXBJLE9BQUEsQ0FBQW9JLHdCQUFBLEdBQUc7RUFDbEVDLE9BQU8sRUFBRSxPQUFPO0VBQ2hCQyxVQUFVLEVBQUUsR0FBRztFQUNmQyxRQUFRLEVBQUUsSUFBSTtFQUNkQyxTQUFTLEVBQUU7QUFDYixDQUFDO0FBRU0sTUFBTUMsaUJBQWlCLEdBQUF6SSxPQUFBLENBQUF5SSxpQkFBQSxHQUFHLENBQy9CeEUsdUJBQWUsQ0FBQ0csSUFBSSxFQUNwQkgsdUJBQWUsQ0FBQ0ssT0FBTyxFQUN2QkwsdUJBQWUsQ0FBQ00sYUFBYSxFQUM3Qk4sdUJBQWUsQ0FBQ0MsR0FBRyxDQUNwQjtBQUFDLElBRVV3RSxzQkFBc0IsR0FBQTFJLE9BQUEsQ0FBQTBJLHNCQUFBLDBCQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQXRCQSxzQkFBc0I7RUFBdEJBLHNCQUFzQjtFQUF0QkEsc0JBQXNCO0VBQUEsT0FBdEJBLHNCQUFzQjtBQUFBO0FBWTNCLE1BQU1DLFlBQVksR0FBQTNJLE9BQUEsQ0FBQTJJLFlBQUEsR0FBRyxhQUFhO0FBQ2xDLE1BQU1DLFVBQVUsR0FBQTVJLE9BQUEsQ0FBQTRJLFVBQUEsR0FBRyxZQUFZO0FBQy9CLE1BQU1DLElBQUksR0FBQTdJLE9BQUEsQ0FBQTZJLElBQUEsR0FBRyxNQUFNO0FBQ25CLE1BQU1DLFVBQVUsR0FBQTlJLE9BQUEsQ0FBQThJLFVBQUEsR0FBRyxZQUFZO0FBQy9CLE1BQU1DLGVBQWUsR0FBQS9JLE9BQUEsQ0FBQStJLGVBQUEsR0FBRyxTQUFTO0FBQ2pDLE1BQU1DLHNCQUFzQixHQUFBaEosT0FBQSxDQUFBZ0osc0JBQUEsR0FBRztFQUNwQyxDQUFDL0MsWUFBWSxHQUNYLGdHQUFnRztFQUNsRyxDQUFDRCxPQUFPLEdBQ04saVJBQWlSO0VBQ25SLENBQUM0QyxVQUFVLEdBQ1Q7QUFDSixDQUFDOztBQUVEO0FBQ08sTUFBTUssZ0JBQWdCLEdBQUFqSixPQUFBLENBQUFpSixnQkFBQSxHQUFHLENBQzlCLGFBQWEsRUFDYixXQUFXLEVBQ1gsYUFBYSxFQUNiLGVBQWUsRUFDZixZQUFZLEVBQ1osZ0JBQWdCLENBQ2pCO0FBRU0sTUFBTUMsb0JBQW9CLEdBQUFsSixPQUFBLENBQUFrSixvQkFBQSxHQUFHO0VBQ2xDQyxLQUFLLEVBQUUsQ0FBQztFQUNSQyxPQUFPLEVBQUUsV0FBVztFQUNwQkMsU0FBUyxFQUNQO0FBQ0osb0ZBQW9GO0VBQ2xGQyxZQUFZLEVBQUU7QUFDaEIsQ0FBQztBQUVNLE1BQU1DLGdCQUFnQixHQUFBdkosT0FBQSxDQUFBdUosZ0JBQUEsR0FBRztFQUM5QixDQUFDM0gsV0FBVyxHQUFHTixZQUFZO0VBQzNCLENBQUNPLG1CQUFtQixHQUFHTjtBQUN6QixDQUFDO0FBRU0sTUFBTWlJLDZCQUE2QixHQUFBeEosT0FBQSxDQUFBd0osNkJBQUEsR0FBRztBQUMzQztBQUNBO0VBQUV4QixJQUFJLEVBQUUsU0FBUztFQUFFeUIsSUFBSSxFQUFFO0FBQVMsQ0FBQyxDQUNwQztBQUVNLE1BQU1DLHdCQUF3QixHQUFBMUosT0FBQSxDQUFBMEosd0JBQUEsR0FBRztFQUN0Q0MsRUFBRSxFQUFFLFdBQVc7RUFDZkMsVUFBVSxFQUFFLElBQUk7RUFDaEJDLE9BQU8sRUFBRSxNQUFNO0VBQ2ZDLE1BQU0sRUFBRSxVQUFVO0VBQ2xCQyxZQUFZLEVBQUU7QUFDaEIsQ0FBQztBQUVNLE1BQU1DLHFCQUFxQixHQUFBaEssT0FBQSxDQUFBZ0sscUJBQUEsR0FBRztFQUNuQ0wsRUFBRSxFQUFFLFNBQVM7RUFDYkMsVUFBVSxFQUFFLEtBQUs7RUFDakJDLE9BQU8sRUFBRSxRQUFRO0VBQ2pCQyxNQUFNLEVBQUU7QUFDVixDQUFDIn0=