"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPARK_TIMESTAMP_DATATYPE = exports.SPARK_STRING_DATATYPE = exports.SPARK_PARTITION_INFO = exports.SPARK_HIVE_TABLE_REGEX = exports.SKIPPING_INDEX_ACCELERATION_METHODS = exports.SECURITY_DASHBOARDS_LOGOUT_URL = exports.SANITIZE_QUERY_REGEX = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.QUERY_LANGUAGE = exports.OLLY_QUESTION_URL_PARAM_KEY = exports.OBS_S3_DATA_SOURCE = exports.OBS_DEFAULT_CLUSTER = exports.INDEX_URL_PARAM_KEY = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_NAME = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPES = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = exports.CATALOG_CACHE_VERSION = exports.ASYNC_POLLING_INTERVAL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_ADD_FIELDS_TEXT = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DATA_SOURCE_NAME_URL_PARAM_KEY = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = 'datasourceName';
const DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = 'datasourceType';
const OLLY_QUESTION_URL_PARAM_KEY = exports.OLLY_QUESTION_URL_PARAM_KEY = 'olly_q';
const INDEX_URL_PARAM_KEY = exports.INDEX_URL_PARAM_KEY = 'indexPattern';
const DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_TYPE = 'DEFAULT_INDEX_PATTERNS';
const DEFAULT_DATA_SOURCE_NAME = exports.DEFAULT_DATA_SOURCE_NAME = 'Default cluster';
const DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = 'OpenSearch';
const DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = 'Default Group';
let QUERY_LANGUAGE = exports.QUERY_LANGUAGE = /*#__PURE__*/function (QUERY_LANGUAGE) {
  QUERY_LANGUAGE["PPL"] = "PPL";
  QUERY_LANGUAGE["SQL"] = "SQL";
  QUERY_LANGUAGE["DQL"] = "DQL";
  return QUERY_LANGUAGE;
}({});
let DATA_SOURCE_TYPES = exports.DATA_SOURCE_TYPES = /*#__PURE__*/function (DATA_SOURCE_TYPES) {
  DATA_SOURCE_TYPES["DEFAULT_CLUSTER_TYPE"] = "DEFAULT_INDEX_PATTERNS";
  DATA_SOURCE_TYPES["SPARK"] = "spark";
  DATA_SOURCE_TYPES["S3Glue"] = "s3glue";
  return DATA_SOURCE_TYPES;
}({});
const ASYNC_POLLING_INTERVAL = exports.ASYNC_POLLING_INTERVAL = 2000;
const CATALOG_CACHE_VERSION = exports.CATALOG_CACHE_VERSION = '1.0';
const ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = 'skipping';
const ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_TIME_INTERVAL = [{
  text: 'millisecond(s)',
  value: 'millisecond'
}, {
  text: 'second(s)',
  value: 'second'
}, {
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_REFRESH_TIME_INTERVAL = [{
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_ADD_FIELDS_TEXT = exports.ACCELERATION_ADD_FIELDS_TEXT = '(add fields here)';
const ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_REGEX = /^[a-z0-9_]+$/;
const ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_S3_URL_REGEX = /^(s3|s3a):\/\/[a-zA-Z0-9.\-]+/;
const SPARK_HIVE_TABLE_REGEX = exports.SPARK_HIVE_TABLE_REGEX = /Provider:\s*hive/;
const SANITIZE_QUERY_REGEX = exports.SANITIZE_QUERY_REGEX = /\s+/g;
const SPARK_TIMESTAMP_DATATYPE = exports.SPARK_TIMESTAMP_DATATYPE = 'timestamp';
const SPARK_STRING_DATATYPE = exports.SPARK_STRING_DATATYPE = 'string';
const ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_TYPES = [{
  label: 'Skipping Index',
  value: 'skipping'
}, {
  label: 'Covering Index',
  value: 'covering'
}, {
  label: 'Materialized View',
  value: 'materialized'
}];
const ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md';
const ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md#create-index-options';
const ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_INDEX_NAME_INFO = `All OpenSearch acceleration indices have a naming format of pattern: \`prefix_<index name>_suffix\`. They share a common prefix structure, which is \`flint_<data source name>_<database name>_<table name>_\`. Additionally, they may have a suffix that varies based on the index type. 
##### Skipping Index
- For 'Skipping' indices, a fixed index name 'skipping' is used, and this name cannot be modified by the user. The suffix added to this type is \`_index\`.
  - An example of a 'Skipping' index name would be: \`flint_mydatasource_mydb_mytable_skipping_index\`.
##### Covering Index
- 'Covering' indices allow users to specify their index name. The suffix added to this type is \`_index\`.
  - For instance, a 'Covering' index name could be: \`flint_mydatasource_mydb_mytable_myindexname_index\`.
##### Materialized View Index
- 'Materialized View' indices also enable users to define their index name, but they do not have a suffix.
  - An example of a 'Materialized View' index name might look like: \`flint_mydatasource_mydb_mytable_myindexname\`.
##### Note:
- All user given index names must be in lowercase letters, numbers and underscore. Spaces, commas, and characters -, :, ", *, +, /, \, |, ?, #, >, or < are not allowed.  
  `;
const SKIPPING_INDEX_ACCELERATION_METHODS = exports.SKIPPING_INDEX_ACCELERATION_METHODS = [{
  value: 'PARTITION',
  text: 'Partition'
}, {
  value: 'VALUE_SET',
  text: 'Value Set'
}, {
  value: 'MIN_MAX',
  text: 'Min Max'
}, {
  value: 'BLOOM_FILTER',
  text: 'Bloom Filter'
}];
const ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = [{
  label: 'window.start'
}, {
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}];
const SPARK_PARTITION_INFO = exports.SPARK_PARTITION_INFO = `# Partition Information`;
const OBS_DEFAULT_CLUSTER = exports.OBS_DEFAULT_CLUSTER = 'observability-default'; // prefix key for generating data source id for default cluster in data selector
const OBS_S3_DATA_SOURCE = exports.OBS_S3_DATA_SOURCE = 'observability-s3'; // prefix key for generating data source id for s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = 'Amazon S3'; // display group name for Amazon-managed-s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = 'Spark'; // display group name for OpenSearch-spark-s3 data sources in data selector
const SECURITY_DASHBOARDS_LOGOUT_URL = exports.SECURITY_DASHBOARDS_LOGOUT_URL = '/logout';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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