"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlToDatasourceType = exports.QUERY_RESTRICTED = exports.QUERY_ALL = exports.PrometheusURL = exports.OPENSEARCH_S3_DOCUMENTATION_URL = exports.OPENSEARCH_DOCUMENTATION_URL = exports.OPENSEARCH_ACC_DOCUMENTATION_URL = exports.DatasourceTypeToDisplayName = exports.AmazonS3URL = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const OPENSEARCH_DOCUMENTATION_URL = exports.OPENSEARCH_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/data-sources/';
const OPENSEARCH_S3_DOCUMENTATION_URL = exports.OPENSEARCH_S3_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/S3-data-source/';
const OPENSEARCH_ACC_DOCUMENTATION_URL = exports.OPENSEARCH_ACC_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/accelerate-external-data/';
const QUERY_RESTRICTED = exports.QUERY_RESTRICTED = 'query-restricted';
const QUERY_ALL = exports.QUERY_ALL = 'query-all';
const DatasourceTypeToDisplayName = exports.DatasourceTypeToDisplayName = {
  PROMETHEUS: 'Prometheus',
  S3GLUE: 'Amazon S3'
};
const PrometheusURL = exports.PrometheusURL = 'Prometheus';
const AmazonS3URL = exports.AmazonS3URL = 'AmazonS3AWSGlue';
const UrlToDatasourceType = exports.UrlToDatasourceType = {
  [PrometheusURL]: 'PROMETHEUS',
  [AmazonS3URL]: 'S3GLUE'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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