"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.samplePanelName = exports.createDemoPanel = exports.CUSTOM_PANEL_SLICE = exports.CUSTOM_PANELS_SAVED_OBJECT_TYPE = exports.CUSTOM_PANELS_DOCUMENTATION_URL = exports.CUSTOM_PANELS_API_PREFIX = exports.CREATE_PANEL_MESSAGE = void 0;
var _uuid = require("uuid");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const CUSTOM_PANELS_API_PREFIX = exports.CUSTOM_PANELS_API_PREFIX = '/api/observability/operational_panels';
const CUSTOM_PANELS_DOCUMENTATION_URL = exports.CUSTOM_PANELS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/operational-panels/';
const CREATE_PANEL_MESSAGE = exports.CREATE_PANEL_MESSAGE = 'Enter a name to describe the purpose of this Observability Dashboard.';
const CUSTOM_PANELS_SAVED_OBJECT_TYPE = exports.CUSTOM_PANELS_SAVED_OBJECT_TYPE = 'observability-panel';
const CUSTOM_PANEL_SLICE = exports.CUSTOM_PANEL_SLICE = 'customPanel';
const samplePanelName = exports.samplePanelName = '[Logs] Web traffic Panel';
const createDemoPanel = savedVisualizationIds => {
  return {
    name: samplePanelName,
    visualizations: [{
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[0],
      x: 4,
      y: 6,
      w: 8,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[1],
      x: 0,
      y: 2,
      w: 12,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[2],
      x: 0,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[3],
      x: 4,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[4],
      x: 8,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[5],
      x: 0,
      y: 4,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[6],
      x: 0,
      y: 6,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[7],
      x: 4,
      y: 4,
      w: 8,
      h: 2
    }],
    timeRange: {
      to: 'now/y',
      from: 'now/y'
    },
    queryFilter: {
      query: '',
      language: 'ppl'
    }
  };
};
exports.createDemoPanel = createDemoPanel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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