"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YELLOW_ORANGE_RED_PALETTE = exports.YELLOW_GREEN_BLUE_PALETTE = exports.SPECTRUM = exports.SINGLE_COLOR_PALETTE = exports.RED_BLUE_PALETTE = exports.REDS_PALETTE = exports.PIE_PALETTES = exports.OPACITY = exports.MULTI_COLOR_PALETTE = exports.HEX_CONTRAST_COLOR = exports.HEATMAP_SINGLE_COLOR = exports.HEATMAP_PALETTE_COLOR = exports.GREYS_PALETTE = exports.GREENS_PALETTE = exports.DEFAULT_PALETTE = exports.COLOR_WHITE = exports.COLOR_PALETTES = exports.COLOR_BLACK = exports.BLUE_RED_PALETTE = exports.BLUES_PALETTE = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const BLUES_PALETTE = exports.BLUES_PALETTE = {
  name: 'Blues',
  label: 'Blues',
  colors: ['rgb(5,10,172)', 'rgb(40,60,190)', 'rgb(70,100,245)', 'rgb(90,120,245)', 'rgb(106,137,247)', 'rgb(220,220,220)']
};
const REDS_PALETTE = exports.REDS_PALETTE = {
  name: 'Reds',
  label: 'Reds',
  colors: ['rgb(220,220,220)', 'rgb(245,195,157)', 'rgb(245,160,105)', 'rgb(178,10,28)']
};
const GREENS_PALETTE = exports.GREENS_PALETTE = {
  name: 'Greens',
  label: 'Greens',
  colors: ['rgb(0,68,27)', 'rgb(0,109,44)', 'rgb(35,139,69)', 'rgb(65,171,93)', 'rgb(116,196,118)', 'rgb(161,217,155)', 'rgb(199,233,192)', 'rgb(229,245,224)', 'rgb(247,252,245)']
};
const GREYS_PALETTE = exports.GREYS_PALETTE = {
  name: 'Greys',
  label: 'Greys',
  colors: ['rgb(0,0,0)', 'rgb(255,255,255)']
};
const BLUE_RED_PALETTE = exports.BLUE_RED_PALETTE = {
  name: 'Bluered',
  label: 'Blue-Red',
  colors: ['rgb(0,0,255)', 'rgb(255,0,0)']
};
const RED_BLUE_PALETTE = exports.RED_BLUE_PALETTE = {
  name: 'RdBu',
  label: 'Red-Blue',
  colors: ['rgb(5,10,172)', 'rgb(106,137,247)', 'rgb(190,190,190)', 'rgb(220,170,132)', 'rgb(230,145,90)', 'rgb(178,10,28)']
};
const YELLOW_ORANGE_RED_PALETTE = exports.YELLOW_ORANGE_RED_PALETTE = {
  name: 'YlOrRd',
  label: 'Yellow-Orange-Red',
  colors: ['rgb(128,0,38)', 'rgb(189,0,38)', 'rgb(227,26,28)', 'rgb(252,78,42)', 'rgb(253,141,60)', 'rgb(254,178,76)', 'rgb(254,217,118)', 'rgb(255,237,160)', 'rgb(255,255,204)']
};
const YELLOW_GREEN_BLUE_PALETTE = exports.YELLOW_GREEN_BLUE_PALETTE = {
  name: 'YlGnBu',
  label: 'Yellow-Green-Blue',
  colors: ['rgb(8,29,88)', 'rgb(37,52,148)', 'rgb(34,94,168)', 'rgb(29,145,192)', 'rgb(65,182,196)', 'rgb(127,205,187)', 'rgb(199,233,180)', 'rgb(237,248,217)', 'rgb(255,255,217)']
};
const DEFAULT_PALETTE = exports.DEFAULT_PALETTE = 'default';
const SINGLE_COLOR_PALETTE = exports.SINGLE_COLOR_PALETTE = 'singleColor';
const MULTI_COLOR_PALETTE = exports.MULTI_COLOR_PALETTE = 'multicolor';
const COLOR_PALETTES = exports.COLOR_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single color',
  type: 'text'
}, {
  value: MULTI_COLOR_PALETTE,
  title: 'Multicolored',
  type: 'text'
}, {
  value: BLUES_PALETTE.name,
  title: BLUES_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUES_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: REDS_PALETTE.name,
  title: REDS_PALETTE.label,
  palette: (0, _eui.colorPalette)(REDS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREENS_PALETTE.name,
  title: GREENS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREENS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: GREYS_PALETTE.name,
  title: GREYS_PALETTE.label,
  palette: (0, _eui.colorPalette)(GREYS_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: BLUE_RED_PALETTE.name,
  title: BLUE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(BLUE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: RED_BLUE_PALETTE.name,
  title: RED_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(RED_BLUE_PALETTE.colors, 20, true),
  type: 'gradient'
}, {
  value: YELLOW_ORANGE_RED_PALETTE.name,
  title: YELLOW_ORANGE_RED_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_ORANGE_RED_PALETTE.colors, 20),
  type: 'gradient'
}, {
  value: YELLOW_GREEN_BLUE_PALETTE.name,
  title: YELLOW_GREEN_BLUE_PALETTE.label,
  palette: (0, _eui.colorPalette)(YELLOW_GREEN_BLUE_PALETTE.colors, 20),
  type: 'gradient'
}];
const HEX_CONTRAST_COLOR = exports.HEX_CONTRAST_COLOR = 0xffffff;
const PIE_PALETTES = exports.PIE_PALETTES = [{
  value: DEFAULT_PALETTE,
  title: 'Default',
  type: 'text'
}, {
  value: SINGLE_COLOR_PALETTE,
  title: 'Single Color',
  type: 'text'
}];
const HEATMAP_PALETTE_COLOR = exports.HEATMAP_PALETTE_COLOR = {
  name: REDS_PALETTE.label,
  color: REDS_PALETTE.label
};
const HEATMAP_SINGLE_COLOR = exports.HEATMAP_SINGLE_COLOR = {
  name: 'singleColor',
  color: '#000000'
};
const OPACITY = exports.OPACITY = 'opacity';
const SPECTRUM = exports.SPECTRUM = 'spectrum';
const COLOR_BLACK = exports.COLOR_BLACK = 'rgb(0,0,0)';
const COLOR_WHITE = exports.COLOR_WHITE = 'rgb(255,255,255)';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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