"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textAreaMaxLength = exports.statsCommands = exports.regexForSuggestion = exports.regexForIndex = exports.pipeCommands = exports.numberTypes = exports.firstCommand = exports.STRING_FIELD_AFTER_PARSE = exports.RARE_TOP_FIELD_LOOP = exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = exports.PLUS_MINUS_FIELD_AFTER_SORT = exports.PLUS_MINUS_FIELD_AFTER_FIELDS = exports.PIPE_MATH_AFTER_EXPRESSIONS = exports.PIPE_COMMA_AFTER_INDEX = exports.PIPE_AFTER_WHERE = exports.PIPE_AFTER_STATS_GROUP_BY = exports.PIPE_AFTER_SPAN = exports.PIPE_AFTER_PARSE = exports.PIPE_AFTER_MATCH = exports.PIPE_AFTER_KEEP_EMPTY = exports.PIPE_AFTER_HEAD = exports.PIPE_AFTER_GROUP_BY = exports.PIPE_AFTER_CONSECUTIVE = exports.NUM_FIELD_AFTER_AGGREGATION = exports.MORE_INDEX_AFTER_COMMA = exports.MATH_AFTER_FIELD = exports.MATCH_FIELD_AFTER_WHERE = exports.INDEX_AFTER_EQUAL = exports.FIELD_SPAN_AFTER_GROUP_BY = exports.FIELD_IN_FIELD_LOOP = exports.FIELD_IN_FIELDS_LOOP = exports.FIELD_AFTER_SPAN = exports.FIELD_AFTER_PLUS_MINUS_SORT = exports.FIELD_AFTER_PLUS_MINUS = exports.FIELD_AFTER_EVAL_EQUAL = exports.FIELD_AFTER_COMMAND = exports.FIELD_AFTER_COMMA = exports.FIELD_AFTER_BY = exports.EQUAL_AFTER_WHERE_FIELD = exports.EQUAL_AFTER_SOURCE = exports.EQUAL_AFTER_EVAL_FIELD = exports.EMPTY_REGEX = exports.DATA_AFTER_WHERE_EQUAL = exports.DATA_AFTER_COMMA = exports.COMMA_PIPE_BY_AFTER_FIELD = exports.COMMA_PIPE_BY_AFTER_AGGREGATION = exports.COMMA_PIPE_AFTER_SORT_FIELD = exports.COMMA_PIPE_AFTER_RENAME_FIELD = exports.COMMA_PIPE_AFTER_FIELDS = exports.COMMA_PIPE_AFTER_FIELD = exports.COMMA_AFTER_FIELD = exports.CLOSE_AFTER_SPAN = exports.CLOSE_AFTER_FIELD = exports.CLOSE_AFTER_DATA = exports.AS_AFTER_FIELD = exports.AGGREGATION_FOR_STATS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
/* eslint-disable prettier/prettier */

const textAreaMaxLength = exports.textAreaMaxLength = 16384;
const firstCommand = exports.firstCommand = [{
  label: 'source'
}];
const pipeCommands = exports.pipeCommands = [{
  label: 'dedup'
}, {
  label: 'eval'
}, {
  label: 'fields'
}, {
  label: 'head'
}, {
  label: 'parse'
}, {
  label: 'rare'
}, {
  label: 'rename'
}, {
  label: 'sort'
}, {
  label: 'stats'
}, {
  label: 'top'
}, {
  label: 'where'
}];
const statsCommands = exports.statsCommands = [{
  label: 'count()'
}, {
  label: 'sum('
}, {
  label: 'avg('
}, {
  label: 'max('
}, {
  label: 'min('
}, {
  label: 'var_samp('
}, {
  label: 'var_pop('
}, {
  label: 'stddev_samp('
}, {
  label: 'stddev_pop('
}];
const numberTypes = exports.numberTypes = ['long', 'integer', 'short', 'byte', 'double', 'float', 'half_float', 'scaled_float', 'unsigned_long'];
const JUST_SEARCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*/;
const SEARCH_WHERE_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+\S+\s*=\s*\S+/;
const SEARCH_MATCH_REGEX = /\s*(search\s+source|source|index)\s*=\s*[^\\\/\?\"\<\>\|\s\,\#]*(\s*,\s*[^\\\/\?\"\<\>\|\s\,\#]+)*\s*\|\s*where\s+match\(\S+,\s*\S+\)/;
const EMPTY_REGEX = exports.EMPTY_REGEX = /^\s*\S*$/;
const FIELD_AFTER_COMMAND = exports.FIELD_AFTER_COMMAND = /^\s*(dedup|eval|rare|top|rename|where\s+match\()\s+\S*$/;

// Regex for where command
const MATCH_FIELD_AFTER_WHERE = exports.MATCH_FIELD_AFTER_WHERE = /^\s*where\s+\S*$/;
const EQUAL_AFTER_WHERE_FIELD = exports.EQUAL_AFTER_WHERE_FIELD = /^\s*where\s+(\S+)\s+$/;
const DATA_AFTER_WHERE_EQUAL = exports.DATA_AFTER_WHERE_EQUAL = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
const PIPE_AFTER_WHERE = exports.PIPE_AFTER_WHERE = /^\s*where\s+\S+\s*=\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const COMMA_AFTER_FIELD = exports.COMMA_AFTER_FIELD = /^\s*where\s+match\(\s*([^\s,]+)\s*$/;
const DATA_AFTER_COMMA = exports.DATA_AFTER_COMMA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')*)|(\d*\.?\d*)|\w*)$/;
const CLOSE_AFTER_DATA = exports.CLOSE_AFTER_DATA = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const PIPE_AFTER_MATCH = exports.PIPE_AFTER_MATCH = /^\s*where\s+match\(\s*\S+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s*\)\s*$/;

// Regex for dedup command
const FIELD_IN_FIELD_LOOP = exports.FIELD_IN_FIELD_LOOP = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*,\s*([^\s,]*)$/;
const COMMA_PIPE_AFTER_FIELD = exports.COMMA_PIPE_AFTER_FIELD = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s+$/;
const PIPE_AFTER_KEEP_EMPTY = exports.PIPE_AFTER_KEEP_EMPTY = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*keepempty=true\s+$/;
const PIPE_AFTER_CONSECUTIVE = exports.PIPE_AFTER_CONSECUTIVE = /^\s*dedup\s*\d*\s+\S+\s*(,\s*\S+\s*)*\s*consecutive=true\s+$/;

// Regex for eval command
const EQUAL_AFTER_EVAL_FIELD = exports.EQUAL_AFTER_EVAL_FIELD = /^\s*eval\s+(\S+)\s+$/;
const FIELD_AFTER_EVAL_EQUAL = exports.FIELD_AFTER_EVAL_EQUAL = /^\s*eval\s+\S+\s*=\s*\S*$/;
const MATH_AFTER_FIELD = exports.MATH_AFTER_FIELD = /^\s*eval\s+\S+\s*=\s*\S+\s+$/;
const PIPE_MATH_AFTER_EXPRESSIONS = exports.PIPE_MATH_AFTER_EXPRESSIONS = /^\s*eval\s+(\S+\s*=\s*\S+(\s*(\+|\-|\*|\/)\s*\S+)+)+\s+$/;

// Regex for fields command
const PLUS_MINUS_FIELD_AFTER_FIELDS = exports.PLUS_MINUS_FIELD_AFTER_FIELDS = /^\s*fields\s+\S*$/;
const FIELD_AFTER_PLUS_MINUS = exports.FIELD_AFTER_PLUS_MINUS = /^\s*fields\s+(\+|\-)\s*\S*$/;
const COMMA_PIPE_AFTER_FIELDS = exports.COMMA_PIPE_AFTER_FIELDS = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*\s+$/;
const FIELD_IN_FIELDS_LOOP = exports.FIELD_IN_FIELDS_LOOP = /^\s*fields\s+((\+|\-)\s+)?\S+\s*(,\s*\S+\s*)*,\s*\S*$/;

// Regex for rare/top command
const COMMA_PIPE_BY_AFTER_FIELD = exports.COMMA_PIPE_BY_AFTER_FIELD = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+\S*$/;
const RARE_TOP_FIELD_LOOP = exports.RARE_TOP_FIELD_LOOP = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*,\s*\S*$/;
const FIELD_AFTER_BY = exports.FIELD_AFTER_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S*$/;
const PIPE_AFTER_GROUP_BY = exports.PIPE_AFTER_GROUP_BY = /^\s*(rare|top(\s+\d+)?)\s+\S+\s*(,\s*\S+\s*)*\s+by\s+\S+\s+$/;

// Regex for rename command
const AS_AFTER_FIELD = exports.AS_AFTER_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)*\s*(,\s*)?\S+\s+\S*$/;
const COMMA_PIPE_AFTER_RENAME_FIELD = exports.COMMA_PIPE_AFTER_RENAME_FIELD = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+$/;
const FIELD_AFTER_COMMA = exports.FIELD_AFTER_COMMA = /^\s*rename\s+((,\s*)?\S+\s+as\s+\S+\s*)+\s*,\s+\S*$/;

// Regex for head command
const PIPE_AFTER_HEAD = exports.PIPE_AFTER_HEAD = /^\s*head\s+\d+\s+/;

// Regex for sort command
const PLUS_MINUS_FIELD_AFTER_SORT = exports.PLUS_MINUS_FIELD_AFTER_SORT = /^\s*sort(\s+\d+)?\s+\S*$/;
const FIELD_AFTER_PLUS_MINUS_SORT = exports.FIELD_AFTER_PLUS_MINUS_SORT = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+(\+|\-)\s*\S*$/;
const COMMA_PIPE_AFTER_SORT_FIELD = exports.COMMA_PIPE_AFTER_SORT_FIELD = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*\s+\S+\s+$/;
const PLUS_MINUS_FIELD_IN_FIELDS_LOOP = exports.PLUS_MINUS_FIELD_IN_FIELDS_LOOP = /^\s*sort(\s+\d+)?((,\s*)?\s+(\+|\-)?\s*\S+\s*)*,\s+\S*$/;

// Regex for stats command
const FIELD_SPAN_AFTER_GROUP_BY = exports.FIELD_SPAN_AFTER_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S*$/;
const NUM_FIELD_AFTER_AGGREGATION = exports.NUM_FIELD_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S*$/;
const FIELD_AFTER_SPAN = exports.FIELD_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*([^\s,]*)\s*$/;
const CLOSE_AFTER_SPAN = exports.CLOSE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')+")|(\d+\.?\d*)|\w+)\s+$/;
const PIPE_AFTER_SPAN = exports.PIPE_AFTER_SPAN = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+span\(\s*[^\s,]+\s*,\s*(("(\w|\s|')*")|(\d*\.?\d*)|\w*)\s*\)\s*$/;
const CLOSE_AFTER_FIELD = exports.CLOSE_AFTER_FIELD = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))*(,\s*)?(sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s+$/;
const COMMA_PIPE_BY_AFTER_AGGREGATION = exports.COMMA_PIPE_BY_AFTER_AGGREGATION = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+\S*$/;
const PIPE_AFTER_STATS_GROUP_BY = exports.PIPE_AFTER_STATS_GROUP_BY = /^\s*stats\s+((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+by\s+\S+\s+$/;
const AGGREGATION_FOR_STATS = exports.AGGREGATION_FOR_STATS = /^\s*stats\s+(((,\s*)?((sum|avg|max|min|var_samp|var_pop|stddev_samp|stddev_pop)\(\s*\S+\s*\)\s*)|((,\s*)?count\(\)\s*))+\s+,\s*)?\S*$/;

// Regex for parse command
const STRING_FIELD_AFTER_PARSE = exports.STRING_FIELD_AFTER_PARSE = /^\s*parse\s+\S*$/;
const PIPE_AFTER_PARSE = exports.PIPE_AFTER_PARSE = /^\s*parse\s+\S+\s+$/;

// Regex for source command
const EQUAL_AFTER_SOURCE = exports.EQUAL_AFTER_SOURCE = /^\s*source\s+$/;
const INDEX_AFTER_EQUAL = exports.INDEX_AFTER_EQUAL = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]*$/;
const PIPE_COMMA_AFTER_INDEX = exports.PIPE_COMMA_AFTER_INDEX = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*\s+$/;
const MORE_INDEX_AFTER_COMMA = exports.MORE_INDEX_AFTER_COMMA = /^\s*source\s+=\s+[^\\\/\?\"\<\>\|\s\,\#]+(,[^\\\/\?\"\<\>\|\s\,\#]+)*,\s*[^\\\/\?\"\<\>\|\s\,\#]*\s*$/;
const regexForSuggestion = exports.regexForSuggestion = [EMPTY_REGEX, FIELD_AFTER_COMMAND, MATCH_FIELD_AFTER_WHERE, EQUAL_AFTER_WHERE_FIELD, DATA_AFTER_WHERE_EQUAL, PIPE_AFTER_WHERE, COMMA_AFTER_FIELD, DATA_AFTER_COMMA, CLOSE_AFTER_DATA, PIPE_AFTER_MATCH, FIELD_IN_FIELD_LOOP, COMMA_PIPE_AFTER_FIELD, PIPE_AFTER_KEEP_EMPTY, PIPE_AFTER_CONSECUTIVE, EQUAL_AFTER_EVAL_FIELD, FIELD_AFTER_EVAL_EQUAL, MATH_AFTER_FIELD, PIPE_MATH_AFTER_EXPRESSIONS, PLUS_MINUS_FIELD_AFTER_FIELDS, FIELD_AFTER_PLUS_MINUS, COMMA_PIPE_AFTER_FIELDS, FIELD_IN_FIELDS_LOOP, COMMA_PIPE_BY_AFTER_FIELD, RARE_TOP_FIELD_LOOP, FIELD_AFTER_BY, PIPE_AFTER_GROUP_BY, COMMA_PIPE_AFTER_RENAME_FIELD, FIELD_AFTER_COMMA, AS_AFTER_FIELD, PIPE_AFTER_HEAD, PLUS_MINUS_FIELD_AFTER_SORT, FIELD_AFTER_PLUS_MINUS_SORT, PLUS_MINUS_FIELD_IN_FIELDS_LOOP, COMMA_PIPE_AFTER_SORT_FIELD, FIELD_SPAN_AFTER_GROUP_BY, NUM_FIELD_AFTER_AGGREGATION, FIELD_AFTER_SPAN, CLOSE_AFTER_SPAN, PIPE_AFTER_SPAN, CLOSE_AFTER_FIELD, COMMA_PIPE_BY_AFTER_AGGREGATION, PIPE_AFTER_STATS_GROUP_BY, AGGREGATION_FOR_STATS, STRING_FIELD_AFTER_PARSE, PIPE_AFTER_PARSE, EQUAL_AFTER_SOURCE, INDEX_AFTER_EQUAL, PIPE_COMMA_AFTER_INDEX, MORE_INDEX_AFTER_COMMA];
const regexForIndex = exports.regexForIndex = [JUST_SEARCH_REGEX, SEARCH_WHERE_REGEX, SEARCH_MATCH_REGEX];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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