"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationServiceMockWithoutMDSMock = exports.notificationServiceMock = exports.mainStateMock = exports.coreServicesMock = void 0;
var _services = require("../../public/services");
var _constants = require("../../common/constants");
var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const coreServicesMock = exports.coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn().mockName('addDanger'),
      addSuccess: jest.fn().mockName('addSuccess'),
      addError: jest.fn().mockName('addError')
    }
  }
};
const dataSourceIdMock = 'mockDataSourceId'; // Provide a mock dataSourceId
const multiDataSourceEnabledMock = true; // Provide a mock value for multiDataSourceEnabled

const browserServicesMock = new _services.NotificationService(_httpClientMock.default, dataSourceIdMock, multiDataSourceEnabledMock);
const browserServicesMockWithNoDataSource = new _services.NotificationService(_httpClientMock.default);
const notificationServiceMock = exports.notificationServiceMock = {
  notificationService: browserServicesMock
};
const notificationServiceMockWithoutMDSMock = exports.notificationServiceMockWithoutMDSMock = {
  notificationService: browserServicesMockWithNoDataSource
};
const mainStateMock = exports.mainStateMock = {
  availableChannels: _constants.CHANNEL_TYPE,
  availableConfigTypes: ['slack', 'chime', 'webhook', 'email', 'sns', 'smtp_account', 'ses_account', 'email_group'],
  tooltipSupport: true
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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