"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MOCK_DATA = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const mockChime = {
  name: 'Chime test channel',
  description: 'test description',
  config_type: 'chime',
  is_enabled: true,
  chime: {
    url: 'https://hooks.chime.aws/incomingwebhooks/sample_chime_url?token=123456'
  },
  config_id: 'test-chime',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSlack = {
  name: 'Slack test channel',
  description: 'test description',
  config_type: 'slack',
  is_enabled: false,
  slack: {
    url: 'https://hooks.slack.com/services/A123456/B1234567/A1B2C3D4E5F6G7H8I9J0K1L2'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockEmail = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1l8hq3kB0XwiBlEbanSo', 'dz8etXkBCzVy9Vy-0sgh', 'eD8ktXkBCzVy9Vy-A8j-', '1V8gq3kB0XwiBlEbAXSI', 'dD_8tHkBCzVy9Vy-5si0', '52XGr3kBqFjWrmvL43mv'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1l8hq3kB0XwiBlEbanSo': 'name1',
      'dz8etXkBCzVy9Vy-0sgh': 'name2',
      'eD8ktXkBCzVy9Vy-A8j-': 'name3',
      '1V8gq3kB0XwiBlEbAXSI': 'name4',
      'dD_8tHkBCzVy9Vy-5si0': 'name5',
      '52XGr3kBqFjWrmvL43mv': 'name6'
    },
    invalid_ids: [],
    sender_type: 'smtp_account'
  },
  config_id: 'DMG3zXkBPa6YFxmVfNmm',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockEmailWithSES = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1y8ud3xO0KjvOyRonaFb', 'qm8rgKxOPmIl9Il-0ftu', 'rQ8xgKxOPmIl9Il-N8w-', '1I8td3xO0KjvOyRoNKFV', 'qQ_8gUxOPmIl9Il-5fv0', '52KTe3xOdSwJeziY43zi'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1y8ud3xO0KjvOyRonaFb': 'name1',
      'qm8rgKxOPmIl9Il-0ftu': 'name2',
      'rQ8xgKxOPmIl9Il-N8w-': 'name3',
      '1I8td3xO0KjvOyRoNKFV': 'name4',
      'qQ_8gUxOPmIl9Il-5fv0': 'name5',
      '52KTe3xOdSwJeziY43zi': 'name6'
    },
    invalid_ids: ['52KTe3xOdSwJeziY43zi'],
    sender_type: 'ses_account'
  },
  config_id: 'QZT3mKxOCn6LSkzIsAzz',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockWebhook = {
  name: 'Webhook test channel',
  description: 'test description',
  config_type: 'webhook',
  is_enabled: true,
  webhook: {
    url: 'https://host:23/path?key1=%23%404&key2=&key3=value3',
    header_params: {
      key1: 'value1',
      key2: 'value2',
      key3: '',
      key4: 'value4',
      key5: 'value5',
      key6: 'value6'
    },
    method: 'POST'
  },
  config_id: '7mUjsHkBqFjWrmvLc3nl',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSNS = {
  name: 'SNS test channel',
  description: 'test description',
  config_type: 'sns',
  is_enabled: true,
  sns: {
    topic_arn: 'arn:aws:sns:us-west-2:012345678912:notifications-test',
    role_arn: 'arn:aws:iam::012345678912:role/NotificationsSNSRole'
  },
  config_id: 'erCDYHsBUMRLC5PZXfPN',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSender = {
  name: 'test-sender',
  description: 'test description',
  config_id: '72UysHkBqFjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  smtp_account: {
    host: 'example.com',
    port: '23',
    method: 'start_tls',
    from_address: 'sample@email.com'
  }
};
const mockMicrosoftTeams = {
  name: 'Microsoft Teams test channel',
  description: 'test description',
  config_type: 'microsoft_teams',
  is_enabled: false,
  microsoft_teams: {
    url: 'https://hooks.chime.aws/incomingwebhooks/sample_chime_url?token=123456'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSESSender = {
  name: 'test-ses-sender',
  description: 'test description',
  config_id: '72HlfUxOdSwJeziYSKxO',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  ses_account: {
    from_address: 'sample@email.com',
    region: 'us-west-2',
    role_arn: 'arn:aws:iam::012345678912:role/TestNotificationsSESRole'
  }
};
const mockRecipientGroup = {
  name: 'Test recipient group',
  description: 'test description',
  config_id: '72UysHkBqVjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  email_group: {
    recipient_list: [{
      recipient: 'test1@email.com'
    }, {
      recipient: 'test2@email.com'
    }, {
      recipient: 'test3@email.com'
    }, {
      recipient: 'test4@email.com'
    }, {
      recipient: 'test5@email.com'
    }, {
      recipient: 'test6@email.com'
    }]
  }
};
const MOCK_DATA = exports.MOCK_DATA = {
  channels: {
    items: [mockChime, mockSlack, mockEmail, mockEmailWithSES, mockWebhook, mockSNS, mockMicrosoftTeams],
    total: 7
  },
  chime: mockChime,
  slack: mockSlack,
  email: mockEmail,
  emailWithSES: mockEmailWithSES,
  webhook: mockWebhook,
  sns: mockSNS,
  microsoftTeams: mockMicrosoftTeams,
  sender: mockSender,
  sesSender: mockSESSender,
  senders: {
    items: [mockSender],
    total: 1
  },
  sesSenders: {
    items: [mockSESSender],
    total: 1
  },
  recipientGroup: mockRecipientGroup,
  recipientGroups: {
    items: [mockRecipientGroup],
    total: 1
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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