"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testEnvironment: 'jest-environment-jsdom',
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  snapshotSerializers: ['enzyme-to-json/serializer'],
  coveragePathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/', '<rootDir>/test/', '<rootDir>/public/services/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  moduleNameMapper: {
    '\\.(css|less|sass|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '\\.(gif|ttf|eot|svg)$': '<rootDir>/test/mocks/fileMock.ts'
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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