"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventRoutes = eventRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _MDSEnabledClientService = require("../../common/MDSEnabledClientService");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function eventRoutes(router, dataSourceEnabled) {
  let genericParamsAndDataSourceIdQuery = {
    params: _configSchema.schema.any()
  };
  if (dataSourceEnabled) {
    genericParamsAndDataSourceIdQuery = {
      ...genericParamsAndDataSourceIdQuery,
      query: _configSchema.schema.object({
        dataSourceId: _configSchema.schema.string()
      })
    };
  }
  router.get({
    path: `${_common.NODE_API.GET_EVENT}/{eventId}`,
    validate: genericParamsAndDataSourceIdQuery
  }, async (context, request, response) => {
    // @ts-ignore
    const client = _MDSEnabledClientService.MDSEnabledClientService.getClient(request, context, dataSourceEnabled);
    try {
      const resp = await client('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_common.NODE_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: genericParamsAndDataSourceIdQuery
  }, async (context, request, response) => {
    // @ts-ignore
    const client = _MDSEnabledClientService.MDSEnabledClientService.getClient(request, context, dataSourceEnabled);
    try {
      const resp = await client('notifications.sendTestMessage', {
        configId: request.params.configId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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