"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsDashboardsPlugin = void 0;
var _routes = require("./routes");
var _notificationsPlugin = require("./clusters/notificationsPlugin");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class notificationsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    this.logger.debug("notificationsDashboards: Setup");
    const router = core.http.createRouter();
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_notificationsPlugin.NotificationsPlugin);
    }
    core.http.registerRouteHandlerContext('notificationsContext', (context, request) => {
      return {
        logger: this.logger,
        notificationsClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(core) {
    this.logger.debug("notificationsDashboards: Started");
    return {};
  }
  stop() {}
}
exports.notificationsDashboardsPlugin = notificationsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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