"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationsPlugin = NotificationsPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function NotificationsPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.notifications = components.clientAction.namespaceFactory();
  const notifications = Client.prototype.notifications.prototype;
  notifications.getConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'GET'
  });
  notifications.createConfig = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    method: 'POST',
    needBody: true
  });
  notifications.getConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.deleteConfigs = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.CONFIGS
    },
    params: {
      config_id_list: {
        type: 'list',
        required: true
      }
    },
    method: 'DELETE'
  });
  notifications.updateConfigById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.CONFIGS}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });
  notifications.getEventById = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.EVENTS}/<%=eventId%>`,
      req: {
        eventId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  notifications.sendTestMessage = clientAction({
    url: {
      fmt: `${_common.OPENSEARCH_API.TEST_MESSAGE}/<%=configId%>`,
      req: {
        configId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  notifications.getServerFeatures = clientAction({
    url: {
      fmt: _common.OPENSEARCH_API.FEATURES
    },
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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