"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVER_DELAY = exports.REQUEST = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_API = exports.NODE_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'notificationsDashboards';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'notifications-dashboards';

// after delete operation returns, a delay is needed before the change reflects in another request
const SERVER_DELAY = exports.SERVER_DELAY = 1000;
const NODE_API_BASE_PATH = '/api/notifications';
const NODE_API = exports.NODE_API = Object.freeze({
  GET_CONFIGS: `${NODE_API_BASE_PATH}/get_configs`,
  GET_CONFIG: `${NODE_API_BASE_PATH}/get_config`,
  CREATE_CONFIG: `${NODE_API_BASE_PATH}/create_config`,
  DELETE_CONFIGS: `${NODE_API_BASE_PATH}/delete_configs`,
  UPDATE_CONFIG: `${NODE_API_BASE_PATH}/update_config`,
  GET_EVENT: `${NODE_API_BASE_PATH}/get_event`,
  GET_AVAILABLE_FEATURES: `${NODE_API_BASE_PATH}/features`,
  SEND_TEST_MESSAGE: `${NODE_API_BASE_PATH}/test_message`
});
const OPENSEARCH_API_BASE_PATH = '/_plugins/_notifications';
const OPENSEARCH_API = exports.OPENSEARCH_API = Object.freeze({
  CONFIGS: `${OPENSEARCH_API_BASE_PATH}/configs`,
  EVENTS: `${OPENSEARCH_API_BASE_PATH}/events`,
  TEST_MESSAGE: `${OPENSEARCH_API_BASE_PATH}/feature/test`,
  FEATURES: `${OPENSEARCH_API_BASE_PATH}/features`
});
const REQUEST = exports.REQUEST = Object.freeze({
  PUT: 'PUT',
  DELETE: 'DELETE',
  GET: 'GET',
  POST: 'POST',
  HEAD: 'HEAD'
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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