"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
class MDSEnabledClientService {
  static getClient(request, context, dataSourceEnabled) {
    const {
      dataSourceId = ""
    } = request.query || {};
    if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
      return context.dataSource.opensearch.legacy.getClient(dataSourceId.toString()).callAPI;
    } else {
      // fall back to default local cluster
      return context.notificationsContext.notificationsClient.asScoped(request).callAsCurrentUser;
    }
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJNRFNFbmFibGVkQ2xpZW50U2VydmljZSIsImdldENsaWVudCIsInJlcXVlc3QiLCJjb250ZXh0IiwiZGF0YVNvdXJjZUVuYWJsZWQiLCJkYXRhU291cmNlSWQiLCJxdWVyeSIsInRyaW0iLCJsZW5ndGgiLCJkYXRhU291cmNlIiwib3BlbnNlYXJjaCIsImxlZ2FjeSIsInRvU3RyaW5nIiwiY2FsbEFQSSIsIm5vdGlmaWNhdGlvbnNDb250ZXh0Iiwibm90aWZpY2F0aW9uc0NsaWVudCIsImFzU2NvcGVkIiwiY2FsbEFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiTURTRW5hYmxlZENsaWVudFNlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiXHJcbmV4cG9ydCBjbGFzcyBNRFNFbmFibGVkQ2xpZW50U2VydmljZSB7XHJcbiAgc3RhdGljIGdldENsaWVudChyZXF1ZXN0LCBjb250ZXh0LCBkYXRhU291cmNlRW5hYmxlZCkge1xyXG4gICAgY29uc3QgeyBkYXRhU291cmNlSWQgPSBcIlwiIH0gPSAocmVxdWVzdC5xdWVyeSB8fCB7fSkgYXMgeyBkYXRhU291cmNlSWQ/OiBzdHJpbmcgfTtcclxuICAgIGlmIChkYXRhU291cmNlRW5hYmxlZCAmJiBkYXRhU291cmNlSWQgJiYgZGF0YVNvdXJjZUlkLnRyaW0oKS5sZW5ndGggIT0gMCkge1xyXG4gICAgICByZXR1cm4gY29udGV4dC5kYXRhU291cmNlLm9wZW5zZWFyY2gubGVnYWN5LmdldENsaWVudChkYXRhU291cmNlSWQudG9TdHJpbmcoKSkuY2FsbEFQSTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIC8vIGZhbGwgYmFjayB0byBkZWZhdWx0IGxvY2FsIGNsdXN0ZXJcclxuICAgICAgcmV0dXJuIGNvbnRleHQubm90aWZpY2F0aW9uc0NvbnRleHQubm90aWZpY2F0aW9uc0NsaWVudC5hc1Njb3BlZChcclxuICAgICAgICByZXF1ZXN0LFxyXG4gICAgICApLmNhbGxBc0N1cnJlbnRVc2VyO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG5cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDTyxNQUFNQSx1QkFBdUIsQ0FBQztFQUNuQyxPQUFPQyxTQUFTQSxDQUFDQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsaUJBQWlCLEVBQUU7SUFDcEQsTUFBTTtNQUFFQyxZQUFZLEdBQUc7SUFBRyxDQUFDLEdBQUlILE9BQU8sQ0FBQ0ksS0FBSyxJQUFJLENBQUMsQ0FBK0I7SUFDaEYsSUFBSUYsaUJBQWlCLElBQUlDLFlBQVksSUFBSUEsWUFBWSxDQUFDRSxJQUFJLENBQUMsQ0FBQyxDQUFDQyxNQUFNLElBQUksQ0FBQyxFQUFFO01BQ3hFLE9BQU9MLE9BQU8sQ0FBQ00sVUFBVSxDQUFDQyxVQUFVLENBQUNDLE1BQU0sQ0FBQ1YsU0FBUyxDQUFDSSxZQUFZLENBQUNPLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQ0MsT0FBTztJQUN4RixDQUFDLE1BQU07TUFDTDtNQUNBLE9BQU9WLE9BQU8sQ0FBQ1csb0JBQW9CLENBQUNDLG1CQUFtQixDQUFDQyxRQUFRLENBQzlEZCxPQUNGLENBQUMsQ0FBQ2UsaUJBQWlCO0lBQ3JCO0VBQ0Y7QUFDRjtBQUFDQyxPQUFBLENBQUFsQix1QkFBQSxHQUFBQSx1QkFBQSJ9