"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateTermQuery = exports.generateMustQueries = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const generateTermQuery = (key, value) => {
  if (typeof value === 'string' || typeof value === 'number') {
    return {
      term: {
        [key]: {
          value
        }
      }
    };
  }
  return {
    terms: {
      [key]: value
    }
  };
};
exports.generateTermQuery = generateTermQuery;
const generateMustQueries = queries => {
  switch (queries.length) {
    case 0:
      return {
        match_all: {}
      };
    case 1:
      return queries[0];
    default:
      return {
        bool: {
          must: queries
        }
      };
  }
};
exports.generateMustQueries = generateMustQueries;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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