"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateModelSearchQuery = void 0;
var _query = require("./query");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const generateModelSearchQuery = ({
  states,
  nameOrId,
  extraQuery
}) => ({
  bool: {
    must: [...(states ? [(0, _query.generateTermQuery)('model_state', states)] : []), ...(nameOrId ? [{
      bool: {
        should: [{
          wildcard: {
            'name.keyword': {
              value: `*${nameOrId}*`,
              case_insensitive: true
            }
          }
        }, (0, _query.generateTermQuery)('_id', nameOrId)]
      }
    }] : []), ...(extraQuery ? [extraQuery] : [])],
    must_not: {
      exists: {
        field: 'chunk_number'
      }
    }
  }
});
exports.generateModelSearchQuery = generateModelSearchQuery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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