"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileService = void 0;
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

class ProfileService {
  static convertModel(model, id) {
    var _model$target_worker_;
    return {
      id,
      target_worker_nodes: model.target_worker_nodes,
      worker_nodes: model.worker_nodes,
      not_worker_nodes: (_model$target_worker_ = model.target_worker_nodes.filter(nodeId => {
        var _model$worker_nodes;
        return !((_model$worker_nodes = model.worker_nodes) !== null && _model$worker_nodes !== void 0 && _model$worker_nodes.includes(nodeId));
      })) !== null && _model$target_worker_ !== void 0 ? _model$target_worker_ : []
    };
  }
  static async getModel(params) {
    const {
      transport,
      modelId
    } = params;
    const result = (await transport.request({
      method: 'GET',
      path: `${_constants.PROFILE_BASE_API}/models/${modelId}?view=model`
    })).body;
    if (!result.models) {
      return {};
    }
    const model = result.models[modelId];
    return this.convertModel(model, modelId);
  }
}
exports.ProfileService = ProfileService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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