"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelService = void 0;
var _model = require("./utils/model");
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const modelSortFieldMapping = {
  name: 'name.keyword',
  id: '_id'
};
class ModelService {
  static async search({
    from,
    size,
    sort,
    transport,
    ...restParams
  }) {
    const {
      body: {
        hits
      }
    } = await transport.request({
      method: 'POST',
      path: `${_constants.MODEL_BASE_API}/_search`,
      body: {
        query: (0, _model.generateModelSearchQuery)(restParams),
        from,
        size,
        ...(sort ? {
          sort: sort.map(sorting => {
            const [field, direction] = sorting.split('-');
            return {
              [modelSortFieldMapping[field] || field]: direction
            };
          })
        } : {})
      }
    });
    return {
      data: hits.hits.map(({
        _id,
        _source
      }) => ({
        id: _id,
        ..._source
      })),
      total_models: hits.total.value
    };
  }
}
exports.ModelService = ModelService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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