"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorService = void 0;
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

class ConnectorService {
  static async search({
    from,
    size,
    transport
  }) {
    let result;
    try {
      result = await transport.request({
        method: 'POST',
        path: _constants.CONNECTOR_SEARCH_API,
        body: {
          query: {
            match_all: {}
          },
          from,
          size
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return {
          data: [],
          total_connectors: 0
        };
      }
      throw e;
    }
    return {
      data: result.body.hits.hits.map(({
        _id,
        _source
      }) => ({
        id: _id,
        ..._source
      })),
      total_connectors: result.body.hits.total.value
    };
  }
  static async getUniqueInternalConnectorNames({
    transport,
    size
  }) {
    let result;
    try {
      result = await transport.request({
        method: 'POST',
        path: _constants.MODEL_SEARCH_API,
        body: {
          size: 0,
          aggs: {
            unique_connector_names: {
              terms: {
                field: 'connector.name.keyword',
                size
              }
            }
          }
        }
      });
    } catch (e) {
      if (e instanceof Error && e.message.includes('index_not_found_exception')) {
        return [];
      }
      throw e;
    }
    if (!result.body.aggregations) {
      return [];
    }
    return result.body.aggregations.unique_connector_names.buckets.map(({
      key
    }) => key);
  }
}
exports.ConnectorService = ConnectorService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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