"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenSearchClientTransport = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getOpenSearchClientTransport = async ({
  context,
  dataSourceId
}) => {
  if (dataSourceId && context.dataSource) {
    return (await context.dataSource.opensearch.getClient(dataSourceId)).transport;
  }
  return context.core.opensearch.client.asCurrentUser.transport;
};
exports.getOpenSearchClientTransport = getOpenSearchClientTransport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0IiwiY29udGV4dCIsImRhdGFTb3VyY2VJZCIsImRhdGFTb3VyY2UiLCJvcGVuc2VhcmNoIiwiZ2V0Q2xpZW50IiwidHJhbnNwb3J0IiwiY29yZSIsImNsaWVudCIsImFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsidXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgT3BlblNlYXJjaENsaWVudCwgUmVxdWVzdEhhbmRsZXJDb250ZXh0IH0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcclxuXHJcbmV4cG9ydCBjb25zdCBnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0ID0gYXN5bmMgKHtcclxuICBjb250ZXh0LFxyXG4gIGRhdGFTb3VyY2VJZCxcclxufToge1xyXG4gIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCAmIHtcclxuICAgIGRhdGFTb3VyY2U/OiB7XHJcbiAgICAgIG9wZW5zZWFyY2g6IHtcclxuICAgICAgICBnZXRDbGllbnQ6IChkYXRhU291cmNlSWQ6IHN0cmluZykgPT4gUHJvbWlzZTxPcGVuU2VhcmNoQ2xpZW50PjtcclxuICAgICAgfTtcclxuICAgIH07XHJcbiAgfTtcclxuICBkYXRhU291cmNlSWQ/OiBzdHJpbmc7XHJcbn0pID0+IHtcclxuICBpZiAoZGF0YVNvdXJjZUlkICYmIGNvbnRleHQuZGF0YVNvdXJjZSkge1xyXG4gICAgcmV0dXJuIChhd2FpdCBjb250ZXh0LmRhdGFTb3VyY2Uub3BlbnNlYXJjaC5nZXRDbGllbnQoZGF0YVNvdXJjZUlkKSkudHJhbnNwb3J0O1xyXG4gIH1cclxuICByZXR1cm4gY29udGV4dC5jb3JlLm9wZW5zZWFyY2guY2xpZW50LmFzQ3VycmVudFVzZXIudHJhbnNwb3J0O1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1BLDRCQUE0QixHQUFHLE1BQUFBLENBQU87RUFDakRDLE9BQU87RUFDUEM7QUFVRixDQUFDLEtBQUs7RUFDSixJQUFJQSxZQUFZLElBQUlELE9BQU8sQ0FBQ0UsVUFBVSxFQUFFO0lBQ3RDLE9BQU8sQ0FBQyxNQUFNRixPQUFPLENBQUNFLFVBQVUsQ0FBQ0MsVUFBVSxDQUFDQyxTQUFTLENBQUNILFlBQVksQ0FBQyxFQUFFSSxTQUFTO0VBQ2hGO0VBQ0EsT0FBT0wsT0FBTyxDQUFDTSxJQUFJLENBQUNILFVBQVUsQ0FBQ0ksTUFBTSxDQUFDQyxhQUFhLENBQUNILFNBQVM7QUFDL0QsQ0FBQztBQUFDSSxPQUFBLENBQUFWLDRCQUFBLEdBQUFBLDRCQUFBIn0=