"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profileRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _profile_service = require("../services/profile_service");
var _constants = require("./constants");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const profileRouter = router => {
  router.get({
    path: `${_constants.DEPLOYED_MODEL_PROFILE_API_ENDPOINT}/{modelId}`,
    validate: {
      params: _configSchema.schema.object({
        modelId: _configSchema.schema.string({
          validate: value => {
            if (!/^[a-zA-Z0-9_-]+$/.test(value)) {
              return 'Invalid model id';
            }
          }
        })
      }),
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      const payload = await _profile_service.ProfileService.getModel({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        modelId: request.params.modelId
      });
      return response.ok({
        body: payload
      });
    } catch (error) {
      return response.badRequest({
        body: error
      });
    }
  });
};
exports.profileRouter = profileRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9wcm9maWxlX3NlcnZpY2UiLCJfY29uc3RhbnRzIiwiX3V0aWxzIiwicHJvZmlsZVJvdXRlciIsInJvdXRlciIsImdldCIsInBhdGgiLCJERVBMT1lFRF9NT0RFTF9QUk9GSUxFX0FQSV9FTkRQT0lOVCIsInZhbGlkYXRlIiwicGFyYW1zIiwic2NoZW1hIiwib2JqZWN0IiwibW9kZWxJZCIsInN0cmluZyIsInZhbHVlIiwidGVzdCIsInF1ZXJ5IiwiZGF0YV9zb3VyY2VfaWQiLCJtYXliZSIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJwYXlsb2FkIiwiUHJvZmlsZVNlcnZpY2UiLCJnZXRNb2RlbCIsInRyYW5zcG9ydCIsImdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQiLCJkYXRhU291cmNlSWQiLCJvayIsImJvZHkiLCJlcnJvciIsImJhZFJlcXVlc3QiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsicHJvZmlsZV9yb3V0ZXIudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcclxuXHJcbmltcG9ydCB7IElSb3V0ZXIgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xyXG5pbXBvcnQgeyBQcm9maWxlU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL3Byb2ZpbGVfc2VydmljZSc7XHJcbmltcG9ydCB7IERFUExPWUVEX01PREVMX1BST0ZJTEVfQVBJX0VORFBPSU5UIH0gZnJvbSAnLi9jb25zdGFudHMnO1xyXG5pbXBvcnQgeyBnZXRPcGVuU2VhcmNoQ2xpZW50VHJhbnNwb3J0IH0gZnJvbSAnLi91dGlscyc7XHJcblxyXG5leHBvcnQgY29uc3QgcHJvZmlsZVJvdXRlciA9IChyb3V0ZXI6IElSb3V0ZXIpID0+IHtcclxuICByb3V0ZXIuZ2V0KFxyXG4gICAge1xyXG4gICAgICBwYXRoOiBgJHtERVBMT1lFRF9NT0RFTF9QUk9GSUxFX0FQSV9FTkRQT0lOVH0ve21vZGVsSWR9YCxcclxuICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICBwYXJhbXM6IHNjaGVtYS5vYmplY3Qoe1xyXG4gICAgICAgICAgbW9kZWxJZDogc2NoZW1hLnN0cmluZyh7XHJcbiAgICAgICAgICAgIHZhbGlkYXRlOiAodmFsdWUpID0+IHtcclxuICAgICAgICAgICAgICBpZiAoIS9eW2EtekEtWjAtOV8tXSskLy50ZXN0KHZhbHVlKSkge1xyXG4gICAgICAgICAgICAgICAgcmV0dXJuICdJbnZhbGlkIG1vZGVsIGlkJztcclxuICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIH0sXHJcbiAgICAgICAgICB9KSxcclxuICAgICAgICB9KSxcclxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICBkYXRhX3NvdXJjZV9pZDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXHJcbiAgICAgICAgfSksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgYXN5bmMgKGNvbnRleHQsIHJlcXVlc3QsIHJlc3BvbnNlKSA9PiB7XHJcbiAgICAgIHRyeSB7XHJcbiAgICAgICAgY29uc3QgcGF5bG9hZCA9IGF3YWl0IFByb2ZpbGVTZXJ2aWNlLmdldE1vZGVsKHtcclxuICAgICAgICAgIHRyYW5zcG9ydDogYXdhaXQgZ2V0T3BlblNlYXJjaENsaWVudFRyYW5zcG9ydCh7XHJcbiAgICAgICAgICAgIGRhdGFTb3VyY2VJZDogcmVxdWVzdC5xdWVyeS5kYXRhX3NvdXJjZV9pZCxcclxuICAgICAgICAgICAgY29udGV4dCxcclxuICAgICAgICAgIH0pLFxyXG4gICAgICAgICAgbW9kZWxJZDogcmVxdWVzdC5wYXJhbXMubW9kZWxJZCxcclxuICAgICAgICB9KTtcclxuICAgICAgICByZXR1cm4gcmVzcG9uc2Uub2soeyBib2R5OiBwYXlsb2FkIH0pO1xyXG4gICAgICB9IGNhdGNoIChlcnJvcikge1xyXG4gICAgICAgIHJldHVybiByZXNwb25zZS5iYWRSZXF1ZXN0KHsgYm9keTogZXJyb3IgYXMgRXJyb3IgfSk7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICApO1xyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUdBLElBQUFDLGdCQUFBLEdBQUFELE9BQUE7QUFDQSxJQUFBRSxVQUFBLEdBQUFGLE9BQUE7QUFDQSxJQUFBRyxNQUFBLEdBQUFILE9BQUE7QUFWQTtBQUNBO0FBQ0E7QUFDQTs7QUFTTyxNQUFNSSxhQUFhLEdBQUlDLE1BQWUsSUFBSztFQUNoREEsTUFBTSxDQUFDQyxHQUFHLENBQ1I7SUFDRUMsSUFBSSxFQUFHLEdBQUVDLDhDQUFvQyxZQUFXO0lBQ3hEQyxRQUFRLEVBQUU7TUFDUkMsTUFBTSxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDcEJDLE9BQU8sRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTSxDQUFDO1VBQ3JCTCxRQUFRLEVBQUdNLEtBQUssSUFBSztZQUNuQixJQUFJLENBQUMsa0JBQWtCLENBQUNDLElBQUksQ0FBQ0QsS0FBSyxDQUFDLEVBQUU7Y0FDbkMsT0FBTyxrQkFBa0I7WUFDM0I7VUFDRjtRQUNGLENBQUM7TUFDSCxDQUFDLENBQUM7TUFDRkUsS0FBSyxFQUFFTixvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkJNLGNBQWMsRUFBRVAsb0JBQU0sQ0FBQ1EsS0FBSyxDQUFDUixvQkFBTSxDQUFDRyxNQUFNLENBQUMsQ0FBQztNQUM5QyxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FBT00sT0FBTyxFQUFFQyxPQUFPLEVBQUVDLFFBQVEsS0FBSztJQUNwQyxJQUFJO01BQ0YsTUFBTUMsT0FBTyxHQUFHLE1BQU1DLCtCQUFjLENBQUNDLFFBQVEsQ0FBQztRQUM1Q0MsU0FBUyxFQUFFLE1BQU0sSUFBQUMsbUNBQTRCLEVBQUM7VUFDNUNDLFlBQVksRUFBRVAsT0FBTyxDQUFDSixLQUFLLENBQUNDLGNBQWM7VUFDMUNFO1FBQ0YsQ0FBQyxDQUFDO1FBQ0ZQLE9BQU8sRUFBRVEsT0FBTyxDQUFDWCxNQUFNLENBQUNHO01BQzFCLENBQUMsQ0FBQztNQUNGLE9BQU9TLFFBQVEsQ0FBQ08sRUFBRSxDQUFDO1FBQUVDLElBQUksRUFBRVA7TUFBUSxDQUFDLENBQUM7SUFDdkMsQ0FBQyxDQUFDLE9BQU9RLEtBQUssRUFBRTtNQUNkLE9BQU9ULFFBQVEsQ0FBQ1UsVUFBVSxDQUFDO1FBQUVGLElBQUksRUFBRUM7TUFBZSxDQUFDLENBQUM7SUFDdEQ7RUFDRixDQUNGLENBQUM7QUFDSCxDQUFDO0FBQUNFLE9BQUEsQ0FBQTdCLGFBQUEsR0FBQUEsYUFBQSJ9