"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _services = require("../services");
var _constants = require("./constants");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const modelSortQuerySchema = _configSchema.schema.oneOf([_configSchema.schema.literal('name-asc'), _configSchema.schema.literal('name-desc'), _configSchema.schema.literal('model_state-asc'), _configSchema.schema.literal('model_state-desc'), _configSchema.schema.literal('id-asc'), _configSchema.schema.literal('id-desc')]);
const modelStateSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_common.MODEL_STATE.loadFailed), _configSchema.schema.literal(_common.MODEL_STATE.loaded), _configSchema.schema.literal(_common.MODEL_STATE.loading), _configSchema.schema.literal(_common.MODEL_STATE.partiallyLoaded), _configSchema.schema.literal(_common.MODEL_STATE.trained), _configSchema.schema.literal(_common.MODEL_STATE.uploaded), _configSchema.schema.literal(_common.MODEL_STATE.unloaded), _configSchema.schema.literal(_common.MODEL_STATE.uploading)]);
const modelRouter = router => {
  router.get({
    path: _constants.MODEL_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number({
          min: 0
        }),
        size: _configSchema.schema.number({
          max: 50
        }),
        sort: _configSchema.schema.maybe(_configSchema.schema.oneOf([modelSortQuerySchema, _configSchema.schema.arrayOf(modelSortQuerySchema)])),
        states: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(modelStateSchema), modelStateSchema])),
        nameOrId: _configSchema.schema.maybe(_configSchema.schema.string()),
        extra_query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const {
      from,
      size,
      sort,
      states,
      nameOrId,
      extra_query: extraQuery,
      data_source_id: dataSourceId
    } = request.query;
    try {
      const payload = await _services.ModelService.search({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId,
          context
        }),
        from,
        size,
        sort: typeof sort === 'string' ? [sort] : sort,
        states: typeof states === 'string' ? [states] : states,
        nameOrId,
        extraQuery
      });
      return response.ok({
        body: payload
      });
    } catch (err) {
      return response.badRequest({
        body: err.message
      });
    }
  });
};
exports.modelRouter = modelRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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