"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _constants = require("./constants");
var _connector_service = require("../services/connector_service");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const connectorRouter = router => {
  router.get({
    path: _constants.CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, res) => {
    try {
      const payload = await _connector_service.ConnectorService.search({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        from: 0,
        size: 10000
      });
      return res.ok({
        body: payload
      });
    } catch (err) {
      return res.badRequest({
        body: err.message
      });
    }
  });
  router.get({
    path: _constants.INTERNAL_CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, res) => {
    try {
      const data = await _connector_service.ConnectorService.getUniqueInternalConnectorNames({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        size: 10000
      });
      return res.ok({
        body: {
          data
        }
      });
    } catch (err) {
      return res.badRequest({
        body: err.message
      });
    }
  });
};
exports.connectorRouter = connectorRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9jb25zdGFudHMiLCJfY29ubmVjdG9yX3NlcnZpY2UiLCJfdXRpbHMiLCJjb25uZWN0b3JSb3V0ZXIiLCJyb3V0ZXIiLCJnZXQiLCJwYXRoIiwiQ09OTkVDVE9SX0FQSV9FTkRQT0lOVCIsInZhbGlkYXRlIiwicXVlcnkiLCJzY2hlbWEiLCJvYmplY3QiLCJkYXRhX3NvdXJjZV9pZCIsIm1heWJlIiwic3RyaW5nIiwiY29udGV4dCIsInJlcXVlc3QiLCJyZXMiLCJwYXlsb2FkIiwiQ29ubmVjdG9yU2VydmljZSIsInNlYXJjaCIsInRyYW5zcG9ydCIsImdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQiLCJkYXRhU291cmNlSWQiLCJmcm9tIiwic2l6ZSIsIm9rIiwiYm9keSIsImVyciIsImJhZFJlcXVlc3QiLCJtZXNzYWdlIiwiSU5URVJOQUxfQ09OTkVDVE9SX0FQSV9FTkRQT0lOVCIsImRhdGEiLCJnZXRVbmlxdWVJbnRlcm5hbENvbm5lY3Rvck5hbWVzIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbImNvbm5lY3Rvcl9yb3V0ZXIudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcclxuaW1wb3J0IHsgSVJvdXRlciB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XHJcbmltcG9ydCB7IENPTk5FQ1RPUl9BUElfRU5EUE9JTlQsIElOVEVSTkFMX0NPTk5FQ1RPUl9BUElfRU5EUE9JTlQgfSBmcm9tICcuL2NvbnN0YW50cyc7XHJcbmltcG9ydCB7IENvbm5lY3RvclNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9jb25uZWN0b3Jfc2VydmljZSc7XHJcbmltcG9ydCB7IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQgfSBmcm9tICcuL3V0aWxzJztcclxuXHJcbmV4cG9ydCBjb25zdCBjb25uZWN0b3JSb3V0ZXIgPSAocm91dGVyOiBJUm91dGVyKSA9PiB7XHJcbiAgcm91dGVyLmdldChcclxuICAgIHtcclxuICAgICAgcGF0aDogQ09OTkVDVE9SX0FQSV9FTkRQT0lOVCxcclxuICAgICAgdmFsaWRhdGU6IHtcclxuICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XHJcbiAgICAgICAgICBkYXRhX3NvdXJjZV9pZDogc2NoZW1hLm1heWJlKHNjaGVtYS5zdHJpbmcoKSksXHJcbiAgICAgICAgfSksXHJcbiAgICAgIH0sXHJcbiAgICB9LFxyXG4gICAgYXN5bmMgKGNvbnRleHQsIHJlcXVlc3QsIHJlcykgPT4ge1xyXG4gICAgICB0cnkge1xyXG4gICAgICAgIGNvbnN0IHBheWxvYWQgPSBhd2FpdCBDb25uZWN0b3JTZXJ2aWNlLnNlYXJjaCh7XHJcbiAgICAgICAgICB0cmFuc3BvcnQ6IGF3YWl0IGdldE9wZW5TZWFyY2hDbGllbnRUcmFuc3BvcnQoe1xyXG4gICAgICAgICAgICBkYXRhU291cmNlSWQ6IHJlcXVlc3QucXVlcnkuZGF0YV9zb3VyY2VfaWQsXHJcbiAgICAgICAgICAgIGNvbnRleHQsXHJcbiAgICAgICAgICB9KSxcclxuICAgICAgICAgIGZyb206IDAsXHJcbiAgICAgICAgICBzaXplOiAxMDAwMCxcclxuICAgICAgICB9KTtcclxuICAgICAgICByZXR1cm4gcmVzLm9rKHsgYm9keTogcGF5bG9hZCB9KTtcclxuICAgICAgfSBjYXRjaCAoZXJyKSB7XHJcbiAgICAgICAgcmV0dXJuIHJlcy5iYWRSZXF1ZXN0KHsgYm9keTogZXJyLm1lc3NhZ2UgfSk7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICApO1xyXG4gIHJvdXRlci5nZXQoXHJcbiAgICB7XHJcbiAgICAgIHBhdGg6IElOVEVSTkFMX0NPTk5FQ1RPUl9BUElfRU5EUE9JTlQsXHJcbiAgICAgIHZhbGlkYXRlOiB7XHJcbiAgICAgICAgcXVlcnk6IHNjaGVtYS5vYmplY3Qoe1xyXG4gICAgICAgICAgZGF0YV9zb3VyY2VfaWQ6IHNjaGVtYS5tYXliZShzY2hlbWEuc3RyaW5nKCkpLFxyXG4gICAgICAgIH0pLFxyXG4gICAgICB9LFxyXG4gICAgfSxcclxuICAgIGFzeW5jIChjb250ZXh0LCByZXF1ZXN0LCByZXMpID0+IHtcclxuICAgICAgdHJ5IHtcclxuICAgICAgICBjb25zdCBkYXRhID0gYXdhaXQgQ29ubmVjdG9yU2VydmljZS5nZXRVbmlxdWVJbnRlcm5hbENvbm5lY3Rvck5hbWVzKHtcclxuICAgICAgICAgIHRyYW5zcG9ydDogYXdhaXQgZ2V0T3BlblNlYXJjaENsaWVudFRyYW5zcG9ydCh7XHJcbiAgICAgICAgICAgIGRhdGFTb3VyY2VJZDogcmVxdWVzdC5xdWVyeS5kYXRhX3NvdXJjZV9pZCxcclxuICAgICAgICAgICAgY29udGV4dCxcclxuICAgICAgICAgIH0pLFxyXG4gICAgICAgICAgc2l6ZTogMTAwMDAsXHJcbiAgICAgICAgfSk7XHJcbiAgICAgICAgcmV0dXJuIHJlcy5vayh7IGJvZHk6IHsgZGF0YSB9IH0pO1xyXG4gICAgICB9IGNhdGNoIChlcnIpIHtcclxuICAgICAgICByZXR1cm4gcmVzLmJhZFJlcXVlc3QoeyBib2R5OiBlcnIubWVzc2FnZSB9KTtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gICk7XHJcbn07XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBRUEsSUFBQUMsVUFBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsa0JBQUEsR0FBQUYsT0FBQTtBQUNBLElBQUFHLE1BQUEsR0FBQUgsT0FBQTtBQVRBO0FBQ0E7QUFDQTtBQUNBOztBQVFPLE1BQU1JLGVBQWUsR0FBSUMsTUFBZSxJQUFLO0VBQ2xEQSxNQUFNLENBQUNDLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUVDLGlDQUFzQjtJQUM1QkMsUUFBUSxFQUFFO01BQ1JDLEtBQUssRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1FBQ25CQyxjQUFjLEVBQUVGLG9CQUFNLENBQUNHLEtBQUssQ0FBQ0gsb0JBQU0sQ0FBQ0ksTUFBTSxDQUFDLENBQUM7TUFDOUMsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNELE9BQU9DLE9BQU8sRUFBRUMsT0FBTyxFQUFFQyxHQUFHLEtBQUs7SUFDL0IsSUFBSTtNQUNGLE1BQU1DLE9BQU8sR0FBRyxNQUFNQyxtQ0FBZ0IsQ0FBQ0MsTUFBTSxDQUFDO1FBQzVDQyxTQUFTLEVBQUUsTUFBTSxJQUFBQyxtQ0FBNEIsRUFBQztVQUM1Q0MsWUFBWSxFQUFFUCxPQUFPLENBQUNQLEtBQUssQ0FBQ0csY0FBYztVQUMxQ0c7UUFDRixDQUFDLENBQUM7UUFDRlMsSUFBSSxFQUFFLENBQUM7UUFDUEMsSUFBSSxFQUFFO01BQ1IsQ0FBQyxDQUFDO01BQ0YsT0FBT1IsR0FBRyxDQUFDUyxFQUFFLENBQUM7UUFBRUMsSUFBSSxFQUFFVDtNQUFRLENBQUMsQ0FBQztJQUNsQyxDQUFDLENBQUMsT0FBT1UsR0FBRyxFQUFFO01BQ1osT0FBT1gsR0FBRyxDQUFDWSxVQUFVLENBQUM7UUFBRUYsSUFBSSxFQUFFQyxHQUFHLENBQUNFO01BQVEsQ0FBQyxDQUFDO0lBQzlDO0VBQ0YsQ0FDRixDQUFDO0VBQ0QxQixNQUFNLENBQUNDLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUV5QiwwQ0FBK0I7SUFDckN2QixRQUFRLEVBQUU7TUFDUkMsS0FBSyxFQUFFQyxvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbkJDLGNBQWMsRUFBRUYsb0JBQU0sQ0FBQ0csS0FBSyxDQUFDSCxvQkFBTSxDQUFDSSxNQUFNLENBQUMsQ0FBQztNQUM5QyxDQUFDO0lBQ0g7RUFDRixDQUFDLEVBQ0QsT0FBT0MsT0FBTyxFQUFFQyxPQUFPLEVBQUVDLEdBQUcsS0FBSztJQUMvQixJQUFJO01BQ0YsTUFBTWUsSUFBSSxHQUFHLE1BQU1iLG1DQUFnQixDQUFDYywrQkFBK0IsQ0FBQztRQUNsRVosU0FBUyxFQUFFLE1BQU0sSUFBQUMsbUNBQTRCLEVBQUM7VUFDNUNDLFlBQVksRUFBRVAsT0FBTyxDQUFDUCxLQUFLLENBQUNHLGNBQWM7VUFDMUNHO1FBQ0YsQ0FBQyxDQUFDO1FBQ0ZVLElBQUksRUFBRTtNQUNSLENBQUMsQ0FBQztNQUNGLE9BQU9SLEdBQUcsQ0FBQ1MsRUFBRSxDQUFDO1FBQUVDLElBQUksRUFBRTtVQUFFSztRQUFLO01BQUUsQ0FBQyxDQUFDO0lBQ25DLENBQUMsQ0FBQyxPQUFPSixHQUFHLEVBQUU7TUFDWixPQUFPWCxHQUFHLENBQUNZLFVBQVUsQ0FBQztRQUFFRixJQUFJLEVBQUVDLEdBQUcsQ0FBQ0U7TUFBUSxDQUFDLENBQUM7SUFDOUM7RUFDRixDQUNGLENBQUM7QUFDSCxDQUFDO0FBQUNJLE9BQUEsQ0FBQS9CLGVBQUEsR0FBQUEsZUFBQSJ9