"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "MlCommonsPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.MlCommonsPluginSetup;
  }
});
Object.defineProperty(exports, "MlCommonsPluginStart", {
  enumerable: true,
  get: function () {
    return _types.MlCommonsPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// This exports static code and TypeScript types,
// as well as, OpenSearch Dashboards Platform `plugin()` initializer.

function plugin(initializerContext) {
  return new _plugin.MlCommonsPlugin(initializerContext);
}
const config = exports.config = {
  schema: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9wbHVnaW4iLCJfdHlwZXMiLCJwbHVnaW4iLCJpbml0aWFsaXplckNvbnRleHQiLCJNbENvbW1vbnNQbHVnaW4iLCJjb25maWciLCJleHBvcnRzIiwic2NoZW1hIiwib2JqZWN0IiwiZW5hYmxlZCIsImJvb2xlYW4iLCJkZWZhdWx0VmFsdWUiXSwic291cmNlcyI6WyJpbmRleC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxyXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcclxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcclxuICovXHJcblxyXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xyXG5cclxuaW1wb3J0IHsgUGx1Z2luQ29uZmlnRGVzY3JpcHRvciwgUGx1Z2luSW5pdGlhbGl6ZXJDb250ZXh0IH0gZnJvbSAnLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcclxuaW1wb3J0IHsgTWxDb21tb25zUGx1Z2luIH0gZnJvbSAnLi9wbHVnaW4nO1xyXG5cclxuLy8gVGhpcyBleHBvcnRzIHN0YXRpYyBjb2RlIGFuZCBUeXBlU2NyaXB0IHR5cGVzLFxyXG4vLyBhcyB3ZWxsIGFzLCBPcGVuU2VhcmNoIERhc2hib2FyZHMgUGxhdGZvcm0gYHBsdWdpbigpYCBpbml0aWFsaXplci5cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBwbHVnaW4oaW5pdGlhbGl6ZXJDb250ZXh0OiBQbHVnaW5Jbml0aWFsaXplckNvbnRleHQpIHtcclxuICByZXR1cm4gbmV3IE1sQ29tbW9uc1BsdWdpbihpbml0aWFsaXplckNvbnRleHQpO1xyXG59XHJcblxyXG5leHBvcnQgeyBNbENvbW1vbnNQbHVnaW5TZXR1cCwgTWxDb21tb25zUGx1Z2luU3RhcnQgfSBmcm9tICcuL3R5cGVzJztcclxuXHJcbmV4cG9ydCBjb25zdCBjb25maWc6IFBsdWdpbkNvbmZpZ0Rlc2NyaXB0b3IgPSB7XHJcbiAgc2NoZW1hOiBzY2hlbWEub2JqZWN0KHtcclxuICAgIGVuYWJsZWQ6IHNjaGVtYS5ib29sZWFuKHsgZGVmYXVsdFZhbHVlOiB0cnVlIH0pLFxyXG4gIH0pLFxyXG59O1xyXG4iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFLQSxJQUFBQSxhQUFBLEdBQUFDLE9BQUE7QUFHQSxJQUFBQyxPQUFBLEdBQUFELE9BQUE7QUFTQSxJQUFBRSxNQUFBLEdBQUFGLE9BQUE7QUFqQkE7QUFDQTtBQUNBO0FBQ0E7O0FBT0E7QUFDQTs7QUFFTyxTQUFTRyxNQUFNQSxDQUFDQyxrQkFBNEMsRUFBRTtFQUNuRSxPQUFPLElBQUlDLHVCQUFlLENBQUNELGtCQUFrQixDQUFDO0FBQ2hEO0FBSU8sTUFBTUUsTUFBOEIsR0FBQUMsT0FBQSxDQUFBRCxNQUFBLEdBQUc7RUFDNUNFLE1BQU0sRUFBRUEsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO0lBQ3BCQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLE9BQU8sQ0FBQztNQUFFQyxZQUFZLEVBQUU7SUFBSyxDQUFDO0VBQ2hELENBQUM7QUFDSCxDQUFDIn0=