"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  PLUGIN_ID: true,
  PLUGIN_NAME: true,
  PLUGIN_DESC: true
};
exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLUGIN_DESC = void 0;
var _status = require("./status");
Object.keys(_status).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _status[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _status[key];
    }
  });
});
var _model = require("./model");
Object.keys(_model).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _model[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _model[key];
    }
  });
});
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'ml-commons-dashboards';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'Machine Learning';
const PLUGIN_DESC = exports.PLUGIN_DESC = `ML Commons for OpenSearch eases the development of machine learning features by providing a set of common machine learning (ML) algorithms through transport and REST API calls. Those calls choose the right nodes and resources for each ML request and monitors ML tasks to ensure uptime. This allows you to leverage existing open-source ML algorithms and reduce the effort required to develop new ML features.`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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