"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SQL_TRANSLATE_ROUTE = exports.SQL_QUERY_ROUTE = exports.PPL_TRANSLATE_ROUTE = exports.PPL_QUERY_ROUTE = exports.FORMAT_TEXT = exports.FORMAT_JSON = exports.FORMAT_CSV = exports.DEFAULT_HEADERS = exports.CLUSTER = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const SQL_TRANSLATE_ROUTE = exports.SQL_TRANSLATE_ROUTE = `/_plugins/_sql/_explain`;
const PPL_TRANSLATE_ROUTE = exports.PPL_TRANSLATE_ROUTE = `/_plugins/_ppl/_explain`;
const SQL_QUERY_ROUTE = exports.SQL_QUERY_ROUTE = `/_plugins/_sql`;
const PPL_QUERY_ROUTE = exports.PPL_QUERY_ROUTE = `/_plugins/_ppl`;
const FORMAT_CSV = exports.FORMAT_CSV = `format=csv`;
const FORMAT_JSON = exports.FORMAT_JSON = `format=json`;
const FORMAT_TEXT = exports.FORMAT_TEXT = `format=raw`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  SQL: 'opensearch-sql',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJTUUxfVFJBTlNMQVRFX1JPVVRFIiwiZXhwb3J0cyIsIlBQTF9UUkFOU0xBVEVfUk9VVEUiLCJTUUxfUVVFUllfUk9VVEUiLCJQUExfUVVFUllfUk9VVEUiLCJGT1JNQVRfQ1NWIiwiRk9STUFUX0pTT04iLCJGT1JNQVRfVEVYVCIsIkRFRkFVTFRfSEVBREVSUyIsIkFjY2VwdCIsIkNMVVNURVIiLCJBRE1JTiIsIlNRTCIsIkRBVEEiXSwic291cmNlcyI6WyJjb25zdGFudHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuZXhwb3J0IGNvbnN0IFNRTF9UUkFOU0xBVEVfUk9VVEUgPSBgL19wbHVnaW5zL19zcWwvX2V4cGxhaW5gO1xyXG5leHBvcnQgY29uc3QgUFBMX1RSQU5TTEFURV9ST1VURSA9IGAvX3BsdWdpbnMvX3BwbC9fZXhwbGFpbmA7XHJcbmV4cG9ydCBjb25zdCBTUUxfUVVFUllfUk9VVEUgPSBgL19wbHVnaW5zL19zcWxgO1xyXG5leHBvcnQgY29uc3QgUFBMX1FVRVJZX1JPVVRFID0gYC9fcGx1Z2lucy9fcHBsYDtcclxuZXhwb3J0IGNvbnN0IEZPUk1BVF9DU1YgPSBgZm9ybWF0PWNzdmA7XHJcbmV4cG9ydCBjb25zdCBGT1JNQVRfSlNPTiA9IGBmb3JtYXQ9anNvbmA7XHJcbmV4cG9ydCBjb25zdCBGT1JNQVRfVEVYVCA9IGBmb3JtYXQ9cmF3YDtcclxuXHJcbmV4cG9ydCBjb25zdCBERUZBVUxUX0hFQURFUlMgPSB7XHJcbiAgJ0NvbnRlbnQtVHlwZSc6ICdhcHBsaWNhdGlvbi9qc29uJyxcclxuICBBY2NlcHQ6ICdhcHBsaWNhdGlvbi9qc29uJyxcclxufTtcclxuXHJcbmV4cG9ydCBjb25zdCBDTFVTVEVSID0ge1xyXG4gIEFETUlOOiAnYWRtaW4nLFxyXG4gIFNRTDogJ29wZW5zZWFyY2gtc3FsJyxcclxuICBEQVRBOiAnZGF0YScsXHJcbn07XHJcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRU8sTUFBTUEsbUJBQW1CLEdBQUFDLE9BQUEsQ0FBQUQsbUJBQUEsR0FBSSx5QkFBd0I7QUFDckQsTUFBTUUsbUJBQW1CLEdBQUFELE9BQUEsQ0FBQUMsbUJBQUEsR0FBSSx5QkFBd0I7QUFDckQsTUFBTUMsZUFBZSxHQUFBRixPQUFBLENBQUFFLGVBQUEsR0FBSSxnQkFBZTtBQUN4QyxNQUFNQyxlQUFlLEdBQUFILE9BQUEsQ0FBQUcsZUFBQSxHQUFJLGdCQUFlO0FBQ3hDLE1BQU1DLFVBQVUsR0FBQUosT0FBQSxDQUFBSSxVQUFBLEdBQUksWUFBVztBQUMvQixNQUFNQyxXQUFXLEdBQUFMLE9BQUEsQ0FBQUssV0FBQSxHQUFJLGFBQVk7QUFDakMsTUFBTUMsV0FBVyxHQUFBTixPQUFBLENBQUFNLFdBQUEsR0FBSSxZQUFXO0FBRWhDLE1BQU1DLGVBQWUsR0FBQVAsT0FBQSxDQUFBTyxlQUFBLEdBQUc7RUFDN0IsY0FBYyxFQUFFLGtCQUFrQjtFQUNsQ0MsTUFBTSxFQUFFO0FBQ1YsQ0FBQztBQUVNLE1BQU1DLE9BQU8sR0FBQVQsT0FBQSxDQUFBUyxPQUFBLEdBQUc7RUFDckJDLEtBQUssRUFBRSxPQUFPO0VBQ2RDLEdBQUcsRUFBRSxnQkFBZ0I7RUFDckJDLElBQUksRUFBRTtBQUNSLENBQUMifQ==