"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class QueryService {
  constructor(logger) {
    this.logger = logger;
    _defineProperty(this, "describeQueryInternal", async (transport, query, path) => {
      try {
        const queryRequest = {
          query
        };
        const queryResponse = await transport.request({
          path,
          method: 'POST',
          body: JSON.stringify(queryRequest)
        });
        return {
          data: {
            ok: true,
            resp: queryResponse.body
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (transport, query) => {
      return this.describeQueryInternal(transport, query, '/_plugins/_sql');
    });
    _defineProperty(this, "describePPLQuery", async (transport, query) => {
      return this.describeQueryInternal(transport, query, '/_plugins/_ppl');
    });
  }
}
exports.QueryService = QueryService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJRdWVyeVNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsImxvZ2dlciIsIl9kZWZpbmVQcm9wZXJ0eSIsInRyYW5zcG9ydCIsInF1ZXJ5IiwicGF0aCIsInF1ZXJ5UmVxdWVzdCIsInF1ZXJ5UmVzcG9uc2UiLCJyZXF1ZXN0IiwibWV0aG9kIiwiYm9keSIsIkpTT04iLCJzdHJpbmdpZnkiLCJkYXRhIiwib2siLCJyZXNwIiwiZXJyIiwiaW5mbyIsInJlc3BvbnNlIiwiZGVzY3JpYmVRdWVyeUludGVybmFsIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbInF1ZXJ5X3NlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcclxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXHJcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXHJcbiAqL1xyXG5cclxuaW1wb3J0ICdjb3JlLWpzL3N0YWJsZSc7XHJcbmltcG9ydCBfIGZyb20gJ2xvZGFzaCc7XHJcbmltcG9ydCAncmVnZW5lcmF0b3ItcnVudGltZS9ydW50aW1lJztcclxuaW1wb3J0IHsgTG9nZ2VyLCBPcGVuU2VhcmNoQ2xpZW50IH0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcclxuXHJcbmV4cG9ydCBjbGFzcyBRdWVyeVNlcnZpY2Uge1xyXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgbG9nZ2VyOiBMb2dnZXIpIHt9XHJcblxyXG4gIHByaXZhdGUgZGVzY3JpYmVRdWVyeUludGVybmFsID0gYXN5bmMgKFxyXG4gICAgdHJhbnNwb3J0OiBPcGVuU2VhcmNoQ2xpZW50Wyd0cmFuc3BvcnQnXSxcclxuICAgIHF1ZXJ5OiBzdHJpbmcsXHJcbiAgICBwYXRoOiBzdHJpbmdcclxuICApID0+IHtcclxuICAgIHRyeSB7XHJcbiAgICAgIGNvbnN0IHF1ZXJ5UmVxdWVzdCA9IHtcclxuICAgICAgICBxdWVyeSxcclxuICAgICAgfTtcclxuXHJcbiAgICAgIGNvbnN0IHF1ZXJ5UmVzcG9uc2UgPSBhd2FpdCB0cmFuc3BvcnQucmVxdWVzdCh7XHJcbiAgICAgICAgcGF0aCxcclxuICAgICAgICBtZXRob2Q6ICdQT1NUJyxcclxuICAgICAgICBib2R5OiBKU09OLnN0cmluZ2lmeShxdWVyeVJlcXVlc3QpLFxyXG4gICAgICB9KTtcclxuXHJcbiAgICAgIHJldHVybiB7XHJcbiAgICAgICAgZGF0YToge1xyXG4gICAgICAgICAgb2s6IHRydWUsXHJcbiAgICAgICAgICByZXNwOiBxdWVyeVJlc3BvbnNlLmJvZHksXHJcbiAgICAgICAgfSxcclxuICAgICAgfTtcclxuICAgIH0gY2F0Y2ggKGVycikge1xyXG4gICAgICB0aGlzLmxvZ2dlci5pbmZvKCdlcnJvciBkZXNjcmliZVF1ZXJ5SW50ZXJuYWwnKTtcclxuICAgICAgdGhpcy5sb2dnZXIuaW5mbyhlcnIpO1xyXG5cclxuICAgICAgcmV0dXJuIHtcclxuICAgICAgICBkYXRhOiB7XHJcbiAgICAgICAgICBvazogZmFsc2UsXHJcbiAgICAgICAgICByZXNwOiBlcnIucmVzcG9uc2UsXHJcbiAgICAgICAgICBib2R5OiBlcnIuYm9keSxcclxuICAgICAgICB9LFxyXG4gICAgICB9O1xyXG4gICAgfVxyXG4gIH07XHJcblxyXG4gIGRlc2NyaWJlU1FMUXVlcnkgPSBhc3luYyAodHJhbnNwb3J0OiBPcGVuU2VhcmNoQ2xpZW50Wyd0cmFuc3BvcnQnXSwgcXVlcnk6IHN0cmluZykgPT4ge1xyXG4gICAgcmV0dXJuIHRoaXMuZGVzY3JpYmVRdWVyeUludGVybmFsKHRyYW5zcG9ydCwgcXVlcnksICcvX3BsdWdpbnMvX3NxbCcpO1xyXG4gIH07XHJcblxyXG4gIGRlc2NyaWJlUFBMUXVlcnkgPSBhc3luYyAodHJhbnNwb3J0OiBPcGVuU2VhcmNoQ2xpZW50Wyd0cmFuc3BvcnQnXSwgcXVlcnk6IHN0cmluZykgPT4ge1xyXG4gICAgcmV0dXJuIHRoaXMuZGVzY3JpYmVRdWVyeUludGVybmFsKHRyYW5zcG9ydCwgcXVlcnksICcvX3BsdWdpbnMvX3BwbCcpO1xyXG4gIH07XHJcbn1cclxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQU9PLE1BQU1BLFlBQVksQ0FBQztFQUN4QkMsV0FBV0EsQ0FBa0JDLE1BQWMsRUFBRTtJQUFBLEtBQWhCQSxNQUFjLEdBQWRBLE1BQWM7SUFBQUMsZUFBQSxnQ0FFWCxPQUM5QkMsU0FBd0MsRUFDeENDLEtBQWEsRUFDYkMsSUFBWSxLQUNUO01BQ0gsSUFBSTtRQUNGLE1BQU1DLFlBQVksR0FBRztVQUNuQkY7UUFDRixDQUFDO1FBRUQsTUFBTUcsYUFBYSxHQUFHLE1BQU1KLFNBQVMsQ0FBQ0ssT0FBTyxDQUFDO1VBQzVDSCxJQUFJO1VBQ0pJLE1BQU0sRUFBRSxNQUFNO1VBQ2RDLElBQUksRUFBRUMsSUFBSSxDQUFDQyxTQUFTLENBQUNOLFlBQVk7UUFDbkMsQ0FBQyxDQUFDO1FBRUYsT0FBTztVQUNMTyxJQUFJLEVBQUU7WUFDSkMsRUFBRSxFQUFFLElBQUk7WUFDUkMsSUFBSSxFQUFFUixhQUFhLENBQUNHO1VBQ3RCO1FBQ0YsQ0FBQztNQUNILENBQUMsQ0FBQyxPQUFPTSxHQUFHLEVBQUU7UUFDWixJQUFJLENBQUNmLE1BQU0sQ0FBQ2dCLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztRQUMvQyxJQUFJLENBQUNoQixNQUFNLENBQUNnQixJQUFJLENBQUNELEdBQUcsQ0FBQztRQUVyQixPQUFPO1VBQ0xILElBQUksRUFBRTtZQUNKQyxFQUFFLEVBQUUsS0FBSztZQUNUQyxJQUFJLEVBQUVDLEdBQUcsQ0FBQ0UsUUFBUTtZQUNsQlIsSUFBSSxFQUFFTSxHQUFHLENBQUNOO1VBQ1o7UUFDRixDQUFDO01BQ0g7SUFDRixDQUFDO0lBQUFSLGVBQUEsMkJBRWtCLE9BQU9DLFNBQXdDLEVBQUVDLEtBQWEsS0FBSztNQUNwRixPQUFPLElBQUksQ0FBQ2UscUJBQXFCLENBQUNoQixTQUFTLEVBQUVDLEtBQUssRUFBRSxnQkFBZ0IsQ0FBQztJQUN2RSxDQUFDO0lBQUFGLGVBQUEsMkJBRWtCLE9BQU9DLFNBQXdDLEVBQUVDLEtBQWEsS0FBSztNQUNwRixPQUFPLElBQUksQ0FBQ2UscUJBQXFCLENBQUNoQixTQUFTLEVBQUVDLEtBQUssRUFBRSxnQkFBZ0IsQ0FBQztJQUN2RSxDQUFDO0VBNUM2QztBQTZDaEQ7QUFBQ2dCLE9BQUEsQ0FBQXJCLFlBQUEsR0FBQUEsWUFBQSJ9