"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLService = void 0;
var _ml_commons = require("../../common/constants/ml_commons");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class MLService {
  constructor() {
    _defineProperty(this, "getTask", ({
      transport,
      taskId
    }) => transport.request({
      path: _ml_commons.OPENSEARCH_ML_COMMONS_API.singleTask.replace('{taskId}', taskId),
      method: 'GET'
    }).then(({
      body
    }) => body));
    _defineProperty(this, "executeAgent", ({
      transport,
      agentId,
      async,
      parameters
    }) => transport.request({
      path: _ml_commons.OPENSEARCH_ML_COMMONS_API.agentExecute.replace('{agentId}', agentId),
      method: 'POST',
      querystring: async ? 'async=true' : undefined,
      body: {
        parameters
      }
    }));
    _defineProperty(this, "getMLConfig", ({
      transport,
      configName
    }) => transport.request({
      path: _ml_commons.OPENSEARCH_ML_COMMONS_API.singleConfig.replace('{configName}', configName),
      method: 'GET'
    }).then(({
      body
    }) => body));
    _defineProperty(this, "analyzeLogPattern", ({
      transport,
      parameters
    }) => transport.request({
      method: 'POST',
      path: `/_plugins/_ml/tools/_execute/LogPatternAnalysisTool`,
      body: {
        parameters
      }
    }, {
      requestTimeout: 300000,
      maxRetries: 0
    }).then(({
      body
    }) => body));
    _defineProperty(this, "createMemory", ({
      transport,
      name
    }) => transport.request({
      path: _ml_commons.OPENSEARCH_ML_COMMONS_API.memory,
      method: 'POST',
      body: {
        name
      }
    }).then(({
      body
    }) => body));
  }
}
exports.MLService = MLService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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