"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseService = void 0;
var _shared = require("../../common/constants/shared");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class BaseService {
  constructor(core, logger) {
    this.core = core;
    this.logger = logger;
    _defineProperty(this, "dynamicConfig", undefined);
    _defineProperty(this, "coreStart", undefined);
    _defineProperty(this, "capabilitiesSwitcher", async (request, capabilities) => {
      var _authState$state;
      const {
        dynamicConfigService
      } = this.core;
      if (this.dynamicConfig === undefined) {
        this.dynamicConfig = await dynamicConfigService.getStartService();
      }
      const store = this.dynamicConfig.getAsyncLocalStore();
      const client = this.dynamicConfig.getClient();
      if (!this.coreStart) {
        const [coreStart] = await this.core.getStartServices();
        this.coreStart = coreStart;
      }
      const savedObjectsClient = this.coreStart.savedObjects.getScopedClient(request);
      const uiSettingsClient = this.coreStart.uiSettings.asScopedToClient(savedObjectsClient);
      const isAgenticFeatureEnabledBySetting = Boolean(await uiSettingsClient.get(_shared.ENABLE_AI_FEATURES).catch(() => false));
      const authState = this.core.http.auth.get(request);
      const ownerSupported = !!(authState !== null && authState !== void 0 && (_authState$state = authState.state) !== null && _authState$state !== void 0 && (_authState$state = _authState$state.authInfo) !== null && _authState$state !== void 0 && _authState$state.user_name);
      try {
        const dynamicConfig = await client.getConfig({
          pluginConfigPath: 'investigation'
        }, {
          asyncLocalStorageContext: store
        });
        return {
          investigation: {
            ...capabilities.investigation,
            enabled: dynamicConfig.enabled,
            agenticFeaturesEnabled: dynamicConfig.agenticFeaturesEnabled && isAgenticFeatureEnabledBySetting,
            ownerSupported
          }
        };
      } catch (e) {
        this.logger.error(e);
        return {};
      }
    });
  }
}
exports.BaseService = BaseService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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